#include "xgboost/autofree.h"
#include "shared/qt/config/config.h"

#define log_error_m   alog::logger().error  (__FILE__, __func__, __LINE__, "XGB")
#define log_warn_m    alog::logger().warn   (__FILE__, __func__, __LINE__, "XGB")
#define log_info_m    alog::logger().info   (__FILE__, __func__, __LINE__, "XGB")
#define log_verbose_m alog::logger().verbose(__FILE__, __func__, __LINE__, "XGB")
#define log_debug_m   alog::logger().debug  (__FILE__, __func__, __LINE__, "XGB")
#define log_debug2_m  alog::logger().debug2 (__FILE__, __func__, __LINE__, "XGB")

namespace xgb { // XGBoost

AutoXGBoosterFree::AutoXGBoosterFree(BoosterHandle bh)
    : hBooster(bh)
{}

AutoXGBoosterFree::~AutoXGBoosterFree()
{
    log_debug2_m << "AutoXGBoosterFree destructor";
    if (hBooster)
        XGBoosterFree(hBooster);
}

AutoXGDMatrixFree::AutoXGDMatrixFree(DMatrixHandle dmx)
    : hMatrix(dmx)
{}

AutoXGDMatrixFree::~AutoXGDMatrixFree()
{
    log_debug2_m << "AutoXGDMatrixFree destructor";
    if (hMatrix)
        XGDMatrixFree(hMatrix);
}

} // namespace xgb

#undef log_error_m
#undef log_warn_m
#undef log_info_m
#undef log_verbose_m
#undef log_debug_m
#undef log_debug2_m
