#include "defmac.h"
#include "3rdparty/xgboost/include/xgboost/learner.h"
#include "3rdparty/xgboost/include/xgboost/c_api.h"

namespace xgb { // XGBoost

struct AutoXGBoosterFree
{
    BoosterHandle hBooster = {0};
    AutoXGBoosterFree(BoosterHandle bh);
    ~AutoXGBoosterFree();
    DISABLE_DEFAULT_FUNC(AutoXGBoosterFree)
};

struct AutoXGDMatrixFree
{
    DMatrixHandle hMatrix = {0};
    AutoXGDMatrixFree(DMatrixHandle dmx);
    ~AutoXGDMatrixFree();
    DISABLE_DEFAULT_FUNC(AutoXGDMatrixFree)
};

} // namespace xgbm

#define XGBOOST_HANDLE_AUTO_FREE(HANDLE) \
    xgb::AutoXGBoosterFree __auto_handle_free__(HANDLE); \
    (void) __auto_handle_free__;

#define XGBOOST_MATRIX_AUTO_FREE(HANDLE) \
    xgb::AutoXGDMatrixFree __auto_matrix_free__(HANDLE); \
    (void) __auto_matrix_free__;

#define XGBOOST_HANDLE_AUTO_FREE2(HANDLE) \
    xgb::AutoXGBoosterFree __auto_handle_free2__(HANDLE); \
    (void) __auto_handle_free2__;

#define XGBOOST_MATRIX_AUTO_FREE2(HANDLE) \
    xgb::AutoXGDMatrixFree __auto_matrix_free2__(HANDLE); \
    (void) __auto_matrix_free2__;

