#pragma once

#include "tasks/ret_info.h"
#include "3rdparty/xgboost/include/xgboost/learner.h"
#include "3rdparty/xgboost/include/xgboost/c_api.h"

#include <QtCore>

namespace xgb { // XGBoost

/**
  @brief Первоначальная инициализация настроек XGBoost
  @return true - если ошибок не возникло, false - в противном случае.
  @details Данная функция производит чтение настроек из конфиг-файла.
           Все значения настроек, которые пристуствуют в конфиг-файле
           перезапишут значения которые сейчас находятся в БД.
*/
bool init();
/**
  @brief Применение настроек к хендлу XGBoost
  @param bh - хэндл XGBoost
  @param options - список настроек для применения
  @return
*/
task::RetInfo applyOptions(BoosterHandle bh, const QMap<QString, QString>& options);

} // namespace xgbm
