#pragma once

#include "shared/qt/quuidex.h"
#include "shared/qt/communication/commands_base.h"
#include "shared/qt/communication/serialization/json.h"

namespace communication {
namespace command {

//----------------------------- Список команд --------------------------------

/**
  Команда авторизации для сервиса UsersPool.
*/
extern const QUuidEx UPoolAuthorization;

/**
  Команда авторизации для ФОМС сервера.
*/
extern const QUuidEx FomsAuthorization;

/**
  Команда авторизации для WEB сервера.
*/
extern const QUuidEx WebAuthorization;

} // namespace command

namespace data {

struct AuthorizationBase
{
    QString password;
    J_SERIALIZE_ONE( password )
};

struct UPoolAuthorization : AuthorizationBase,
                            Data<&command::UPoolAuthorization,
                                  Message::Type::Command>
{};

struct FomsAuthorization : AuthorizationBase,
                           Data<&command::FomsAuthorization,
                                 Message::Type::Command>
{};

struct WebAuthorization : AuthorizationBase,
                          Data<&command::WebAuthorization,
                                Message::Type::Command>
{};

} // namespace data
} // namespace communication


