#include "authorization.h"
#include "commands.h"
#include "event_log.h"
#include "foms.h"
#include "group.h"
#include "model.h"
#include "notify.h"
#include "monitor.h"
#include "nsi.h"
#include "report.h"
#include "report_fed.h"
#include "score.h"
#include "send_score.h"
#include "sync_data.h"
#include "task.h"
#include "upool.h"
#include "user.h"
#include "version.h"
#include "xgboost.h"

#include "shared/qt/communication/commands_pool.h"

namespace communication {
namespace command {

#define REGISTRY_COMMAND_SINGLPROC(COMMAND, UUID) \
    const QUuidEx COMMAND = command::Pool::Registry{UUID, #COMMAND, false};

#define REGISTRY_COMMAND_MULTIPROC(COMMAND, UUID) \
    const QUuidEx COMMAND = command::Pool::Registry{UUID, #COMMAND, true};

REGISTRY_COMMAND_SINGLPROC(SpeedTest,                "b2e4557e-80eb-4b86-8bfa-7a12caade6d0")
REGISTRY_COMMAND_MULTIPROC(KeepWaitCommand,          "edbd2b76-eee4-4ad5-80c0-b95dc0e2dfeb")

REGISTRY_COMMAND_SINGLPROC(UPoolAuthorization,       "bf0510fb-66b8-454a-8eb9-ddd286520ffa")
REGISTRY_COMMAND_SINGLPROC(FomsAuthorization,        "2898212c-870e-44b0-adb8-8a1a845a1f70")
REGISTRY_COMMAND_SINGLPROC(WebAuthorization,         "7bd4b1c1-3f8f-4bcf-b941-5a0f1e7b449f")

REGISTRY_COMMAND_SINGLPROC(UPoolUserList,            "2ec05fe5-366a-41c9-a283-5a617767738d")
REGISTRY_COMMAND_SINGLPROC(UPoolValidUsers,          "c0feaea0-eb2f-4c12-92fd-74629bdd8ea9")
REGISTRY_COMMAND_SINGLPROC(UPoolChangesNotify,       "c0feaea0-eb2f-4c13-92fd-74629bdd8ea9")
REGISTRY_COMMAND_SINGLPROC(UPoolSidVerify,           "c0feaea0-eb2f-4c14-92fd-74629bdd8ea9")
REGISTRY_COMMAND_SINGLPROC(UPoolUserAuth,            "fc7f12a8-9643-4e81-9d27-53b99c19d319")

REGISTRY_COMMAND_SINGLPROC(UserActiveStatus,         "972a16d6-baa1-4410-98e4-1c7a9734481b")
REGISTRY_COMMAND_SINGLPROC(UserActiveSet,            "ef443931-fceb-497c-89cf-0156aa98a057")
REGISTRY_COMMAND_SINGLPROC(UserResetAuth,            "14c292a9-5e92-4c8d-8f61-ba3658254754")
REGISTRY_COMMAND_SINGLPROC(UserLogout,               "481a49e4-e970-4748-9c3d-5e131a4a08e7")
REGISTRY_COMMAND_SINGLPROC(UserInfo,                 "56f0f673-b93e-470d-9325-8e4a64afdc3e")
REGISTRY_COMMAND_SINGLPROC(UserList,                 "2fa92c5d-7f0a-44ca-9dcc-c10c9d5c60d3")

REGISTRY_COMMAND_SINGLPROC(FomsEcho,                 "a8313da2-dd5d-4697-89fe-c0d89a6b715f")

REGISTRY_COMMAND_SINGLPROC(TaskSyncDataNow,          "7aadf7c4-b689-4198-b994-aa52f9742283")
REGISTRY_COMMAND_SINGLPROC(TaskSyncDataStop,         "f15285d8-d155-4ef0-aa90-e37b718fbc60")
REGISTRY_COMMAND_SINGLPROC(TaskSyncDataInfo,         "8d80f7e0-25d0-4aba-9bcf-73ec8d529fcd")
REGISTRY_COMMAND_SINGLPROC(TaskSyncDataEdit,         "254c0f87-359a-4657-9092-d4e653dae348")

REGISTRY_COMMAND_SINGLPROC(SyncPlanNow,              "fc94e8e2-57b6-4501-83fe-563479c975b7")

REGISTRY_COMMAND_SINGLPROC(SupportCommand,           "fd6dfc73-3571-44c6-a7af-40abcca62522")
REGISTRY_COMMAND_SINGLPROC(GetSyncData,              "0a4359c7-e1e0-4cb6-89be-9d798930dc2c")
REGISTRY_COMMAND_SINGLPROC(SyncDataCheck,            "545535a0-ed69-4587-bdf7-f6cb19b8da60")
REGISTRY_COMMAND_SINGLPROC(SyncDataCount,            "ecc2fa12-1782-4ae4-8026-acbce9680f7d")

REGISTRY_COMMAND_SINGLPROC(NeedSendScore,            "848157cb-9be1-4fca-974a-b95fdf6c9db6")
REGISTRY_COMMAND_SINGLPROC(SendScore,                "cbff8923-0dfe-11e9-ab14-d663bd873d93")
REGISTRY_COMMAND_SINGLPROC(SendScoreCheck,           "53982e4a-9430-4cb3-8743-da3e696b6fd0")
REGISTRY_COMMAND_SINGLPROC(SendScoreCrcOk,           "40f2b4a9-46e6-4186-8354-ab1d212887df")

REGISTRY_COMMAND_SINGLPROC(GroupCreate,              "5fc81e1e-2b4d-43c0-983e-8e218ff9e8f9")
REGISTRY_COMMAND_SINGLPROC(GroupEdit,                "02118def-10e5-4fca-b492-63cf5f62a1d9")
REGISTRY_COMMAND_SINGLPROC(GroupDelete,              "b5bcfc10-40eb-4b99-ac3e-44e4377944eb")
REGISTRY_COMMAND_SINGLPROC(GroupInfo,                "47afc108-ff2e-45d4-86f8-0b6292f6c358")
REGISTRY_COMMAND_SINGLPROC(GroupList,                "ee9f9ffd-62a7-4bf3-87bf-02644a99c260")
REGISTRY_COMMAND_SINGLPROC(AssignGroup,              "842876d0-3ee0-4c56-a125-3e715e40c1d2")

REGISTRY_COMMAND_SINGLPROC(TaskStartNow,             "3088861b-f6ff-456f-9c6c-0325344898c2")
REGISTRY_COMMAND_SINGLPROC(TaskProgress,             "12561ec5-e3ba-45ff-96b8-f147456afaba")
REGISTRY_COMMAND_SINGLPROC(TaskInterrupt,            "903ccdae-443f-4aaa-89d2-6eb4f787ebb3")
REGISTRY_COMMAND_SINGLPROC(TaskInterruptDone,        "7b63393f-2a54-4132-9b00-367625e9b85c")

REGISTRY_COMMAND_SINGLPROC(TaskModelCreate,          "50d9cc3e-c54e-42dc-9ca9-af740764d489")
REGISTRY_COMMAND_SINGLPROC(TaskModelEdit,            "2a3e45d9-42b5-4861-8ddc-9b0bc8538743")
REGISTRY_COMMAND_SINGLPROC(TaskModelDelete,          "7dfebaa2-79b2-44d0-9654-3969842484b1")
REGISTRY_COMMAND_SINGLPROC(TaskModelInfo,            "33263c34-4afb-4f85-b4fb-67f49933428a")
REGISTRY_COMMAND_SINGLPROC(TaskModelList,            "e59db341-1dfb-48ad-a2ad-8ad48a1f85f3")

REGISTRY_COMMAND_SINGLPROC(TaskScoreCreate,          "b87fd1ab-663e-4586-ab38-07a2d3de675c")
REGISTRY_COMMAND_SINGLPROC(TaskScoreEdit,            "30545d4e-a83f-4b4a-b4ca-2c7321c50e3f")
REGISTRY_COMMAND_SINGLPROC(TaskScoreDelete,          "3bf9ccd5-b1e7-4f73-a47f-5043fceb1aad")
REGISTRY_COMMAND_SINGLPROC(TaskScoreInfo,            "90a04054-39ed-4601-ae89-b8f4c11f5b9e")
REGISTRY_COMMAND_SINGLPROC(TaskScoreList,            "5c0210ab-cc1e-4704-b747-03922dc3e27f")

REGISTRY_COMMAND_SINGLPROC(TaskContentCreate,        "2e51292d-c37a-4dcb-9035-6f78a38569e6")
REGISTRY_COMMAND_SINGLPROC(TaskAlert,                "292d2e51-9f5a-9035-94dc-6fa38585c37a")
REGISTRY_COMMAND_SINGLPROC(SyncProgress,             "cd03f508-6098-4ad3-a758-7ec4bb632cf8")

REGISTRY_COMMAND_SINGLPROC(ModelEdit,                "16a56acd-e551-41d9-ac0c-e0ed9f1fab78")
REGISTRY_COMMAND_SINGLPROC(ModelDelete,              "7615c9e3-b236-4365-9b0b-ada257f17bba")
REGISTRY_COMMAND_SINGLPROC(ModelInfo,                "28c510a8-7923-46ed-89a5-5699362b8bc5")
REGISTRY_COMMAND_SINGLPROC(ModelList,                "829aef04-b7d0-4efa-9906-69369c0a30f0")

REGISTRY_COMMAND_SINGLPROC(ScoreEdit,                "8ec320fa-73f9-4ddf-b535-c2bdb5837da0")
REGISTRY_COMMAND_SINGLPROC(ScoreDelete,              "7c9f6b60-8ef2-4e72-85da-dde4eb66c37b")
REGISTRY_COMMAND_SINGLPROC(ScoreInfo,                "71253bcc-5b18-487a-a9ef-0a06acdb1bca")
REGISTRY_COMMAND_SINGLPROC(ScoreList,                "d7fc2b29-8c9a-4d84-bb72-ad005ac3dffe")

REGISTRY_COMMAND_SINGLPROC(TaskSyncNsiNow,           "12cf09ce-be54-4bbe-967d-6a383e3335e3")
REGISTRY_COMMAND_SINGLPROC(TaskSyncNsiInfo,          "10ae0a99-b69f-4ae9-90f6-3866d09c48a8")
REGISTRY_COMMAND_SINGLPROC(TaskSyncNsiEdit,          "8f0969a4-cea5-4609-ba84-ca87289fb2b8")

REGISTRY_COMMAND_SINGLPROC(SyncNsiVidmp,             "feadcdf0-e4d4-4b6d-8716-c850e0a8931f")
REGISTRY_COMMAND_SINGLPROC(SyncNsiProfile,           "66e3dc8f-9b0b-44ca-826e-08ab531aae5a")
REGISTRY_COMMAND_SINGLPROC(SyncNsiLpu,               "342801f6-4a79-48d9-9d20-aed8d3b277a8")
REGISTRY_COMMAND_SINGLPROC(SyncNsiMkb,               "0c4ab327-5799-410a-b49c-5896883d88da")

REGISTRY_COMMAND_SINGLPROC(NsiVidmpList,             "18d4ba47-95aa-45c1-8ed4-5f888638f90a")
REGISTRY_COMMAND_SINGLPROC(NsiProfileList,           "d1da093d-346e-45ff-88cf-75a97cc94e6f")
REGISTRY_COMMAND_SINGLPROC(NsiLpuList,               "d0fa1b55-2f33-4b32-b189-1fd8a78e98d5")
REGISTRY_COMMAND_SINGLPROC(NsiMkbList,               "a2322349-7629-426d-9e36-b36e6a5a8099")

REGISTRY_COMMAND_SINGLPROC(TaskReportCreate,         "147b9b31-c4a5-468f-ae5d-b930f9cfc1d1")
REGISTRY_COMMAND_SINGLPROC(ReportEdit,               "4e61d479-100d-4c72-be13-2c359d819389")
REGISTRY_COMMAND_SINGLPROC(ReportDelete,             "6c62b4fb-308f-43ea-b198-8047311f64ca")
REGISTRY_COMMAND_SINGLPROC(ReportInfo,               "9dec65db-9e82-4651-a0d0-4cd35d53b6f6")
REGISTRY_COMMAND_SINGLPROC(ReportList,               "c9dbbd69-e70f-4123-910a-886863b639e9")
REGISTRY_COMMAND_SINGLPROC(ReportData,               "7091cd69-1a27-4c13-b4c1-720064300559")

REGISTRY_COMMAND_SINGLPROC(TaskReportFedCreate,      "9b3765ab-0a25-4ab8-a321-fbddad7aaff7")
REGISTRY_COMMAND_SINGLPROC(ReportFedEdit,            "f93ac937-acc1-49c7-8cc4-8f48d6d087cc")
REGISTRY_COMMAND_SINGLPROC(ReportFedDelete,          "546957c0-18ac-48af-ac80-0dfef5f56fa0")
REGISTRY_COMMAND_SINGLPROC(ReportFedInfo,            "6c984825-53fb-4c62-812e-36fdab12e6b2")
REGISTRY_COMMAND_SINGLPROC(ReportFedList,            "a62a1c48-7d6c-47b6-b380-8ea4be0c19c4")
REGISTRY_COMMAND_SINGLPROC(ReportFedName,            "04f50670-5536-4634-ba5c-b5588d4580de")

REGISTRY_COMMAND_SINGLPROC(TaskReportFedNow,         "8c63c898-6d92-4294-bf74-0dc588e6e0e5")
REGISTRY_COMMAND_SINGLPROC(TaskReportFedInfo,        "7f1fe59f-5259-4afe-820e-34ec6bbf6aaa")
REGISTRY_COMMAND_SINGLPROC(TaskReportFedEdit,        "7d8b30c8-45b7-40a4-9766-363fe9d63ec5")

REGISTRY_COMMAND_SINGLPROC(ModelXgbDelete,           "be983008-05c5-4009-b4d1-9d6e4dd6884c")
REGISTRY_COMMAND_SINGLPROC(ModelXgbInfo,             "16f55bb2-ecea-406e-8569-cf64ec545e2e")
REGISTRY_COMMAND_SINGLPROC(ModelXgbEdit,             "5d199423-be4d-49a3-8687-8a7e1fdc9a2a")
REGISTRY_COMMAND_SINGLPROC(ModelXgbOption,           "11b010e6-8d7d-4641-a3b2-abaf2be675ad")

REGISTRY_COMMAND_SINGLPROC(EventLogList,             "87f3207f-8f65-4be9-8841-9b55fcb6c23f")

REGISTRY_COMMAND_SINGLPROC(Monitoring,               "641fd153-22e4-4959-9e6b-889d6cea3181")
REGISTRY_COMMAND_SINGLPROC(MonitorThresholdInfo,     "c4f71462-1b05-43b4-a9b3-ccca214b460e")
REGISTRY_COMMAND_SINGLPROC(MonitorThresholdEdit,     "e6fbdc6d-bd88-4a48-b4e8-10e37e90b31b")

REGISTRY_COMMAND_SINGLPROC(NotifyAddressCreate,      "18e8a60f-6b25-4903-bfb1-991e850cd8d5")
REGISTRY_COMMAND_SINGLPROC(NotifyAddressEdit,        "822f52be-fae0-4a28-bc41-b1fafeb137cc")
REGISTRY_COMMAND_SINGLPROC(NotifyAddressDelete,      "86765158-c347-456c-b410-912f28664aa6")
REGISTRY_COMMAND_SINGLPROC(NotifyAddressInfo,        "bb147aa5-9231-4e59-9788-ddef800a4e9a")
REGISTRY_COMMAND_SINGLPROC(NotifyAddressList,        "02702123-a260-4986-a02e-1a17254e8e11")

REGISTRY_COMMAND_SINGLPROC(NotifyTriggerCreate,      "a12a2a6c-e888-4b33-93fa-9d2428d29c8c")
REGISTRY_COMMAND_SINGLPROC(NotifyTriggerEdit,        "0748b67f-88f8-4015-b87e-fcea834cb84b")
REGISTRY_COMMAND_SINGLPROC(NotifyTriggerDelete,      "2e2467ab-3544-492e-a2ff-d862be323f58")
REGISTRY_COMMAND_SINGLPROC(NotifyTriggerInfo,        "abf0d51b-8c63-40af-8ab7-fcaad953e84c")
REGISTRY_COMMAND_SINGLPROC(NotifyTriggerList,        "a118e57e-d8e1-418d-82d4-8e157f521539")

REGISTRY_COMMAND_SINGLPROC(AisVersion,               "3b52226b-cf24-4ccf-bb61-7877a3348dde")

REGISTRY_COMMAND_SINGLPROC(SendMailDebug,            "f1f2dca3-244b-4c8a-88ae-70d637680fa7")

#undef REGISTRY_COMMAND_SINGLPROC
#undef REGISTRY_COMMAND_MULTIPROC

} // namespace command
} // namespace communication
