/*****************************************************************************
  В модуле представлен список идентификаторов команд для коммуникации между
  клиентской и серверной частями приложения.
  В данном модуле представлен список команд персональный для этого приложения.

  Требование надежности коммуникаций: однажды назначенный идентификатор коман-
  ды не должен более меняться.
*****************************************************************************/

#pragma once

//#include "sync_data.h"
//#include "sync_nsi.h"
#include "shared/list.h"
#include "shared/clife_base.h"
#include "shared/clife_ptr.h"
#include "shared/qt/quuidex.h"
#include "shared/qt/communication/commands_base.h"
#include "shared/qt/communication/serialization/json.h"
#include <sys/time.h>

namespace communication {
namespace command {

//----------------------------- Список команд --------------------------------

/**
  Команда для тестирования скорости работы протокола коммуникаций
*/
extern const QUuidEx SpeedTest;

/*****************************************************************************
  Блок команд для работы с СМО
*****************************************************************************/

/**
  Команда для отладки системы отправки почтовых сообщений
*/
extern const QUuidEx SendMailDebug;

/**
  Команда, которая продляет время ожидания стандартного таймаута для команды.
*/
extern const QUuidEx KeepWaitCommand;

/** FOMS
  Команда проверяет наличие поддержки заданной команды.
*/
extern const QUuidEx SupportCommand;

} // namespace command

namespace data {

struct SpeedTest : Data<&command::SpeedTest,
                         Message::Type::Command,
                         Message::Type::Answer>
{
    QUuidEx uuid;
    J_SERIALIZE_ONE( uuid )
};

//--------------------------- Блок команд для СМО ----------------------------

struct SendMailDebug : Data<&command::SendMailDebug,
                             Message::Type::Command>
{
    QList<QString> addresses;
    QString subject;
    QString body;

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( addresses )
        J_SERIALIZE_ITEM( subject   )
        J_SERIALIZE_ITEM( body      )
    J_SERIALIZE_END
};

struct KeepWaitCommand : Data<&command::KeepWaitCommand,
                               Message::Type::Command>
{
    // Идентификатор команды
    QUuidEx commandId;

    // Идентификатор сообщение
    QUuidEx messageId;

    // Время в секундах, на которое необходимо продлить ожидание
    qint32 timeToAdd = 0;

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( commandId )
        J_SERIALIZE_ITEM( messageId )
        J_SERIALIZE_ITEM( timeToAdd )
    J_SERIALIZE_END
};

struct SupportCommand : Data<&command::SupportCommand,
                              Message::Type::Command,
                              Message::Type::Answer>
{
    // Идентификатор команды
    QUuidEx commandId;

    // true - если команда поддерживается, иначе false
    bool isSupport = {false};

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( commandId )
        J_SERIALIZE_ITEM( isSupport )
    J_SERIALIZE_END
};

} // namespace data
} // namespace communication


