import qbs
import GccUtl
import QbsUtl

Product {
    name: "Commands"
    targetName: "commands"

    type: "staticlibrary"

    Depends { name: "cpp" }
    Depends { name: "RapidJson" }
    Depends { name: "SharedLib" }
    Depends { name: "Qt"; submodules: ["core", "network"] }

    cpp.archiverName: GccUtl.ar(cpp.toolchainPathPrefix)
    cpp.defines: project.cppDefines
    cpp.cxxFlags: project.cxxFlags
    cpp.cxxLanguageVersion: project.cxxLanguageVersion

    property var exportIncludePaths: [
        "../",
    ]
    cpp.includePaths: exportIncludePaths

    // Эта декларация нужна для подавления Qt warning-ов
    cpp.systemIncludePaths: Qt.core.cpp.includePaths

    files: [
        "authorization.h",
        "commands.cpp",
        "commands.h",
        "error.h",
        "event_log.h",
        "filter.h",
        "foms.h",
        "group.h",
        "model.h",
        "monitor.h",
        "notify.h",
        "nsi.h",
        "paging.h",
        "report.h",
        "report_fed.h",
        "score.h",
        "send_score.h",
        "sync_data.h",
        "task.h",
        "time_range.h",
        "upool.h",
        "user.h",
        "version.h",
        "xgboost.h",
    ]
    Export {
        Depends { name: "cpp" }
        cpp.includePaths: product.exportIncludePaths
    }
}
