#pragma once
#include "shared/qt/communication/commands_base.h"

namespace communication {
namespace error {

//--- 10 Ошибки по работе с базой данных ---
DECL_ERROR_CODE(connect_to_database,          10, "2361b42b-7324-4230-8d00-a1c9348d7a58", u8"Ошибка подключения к базе данных")
DECL_ERROR_CODE(begin_transaction,            10, "d521450f-73f9-49a0-afe8-831dd66af353", u8"Ошибка старта транзакции")
DECL_ERROR_CODE(commit_transaction,           10, "5bc8301e-c1c5-4fa6-aeb8-c1b7b86afefe", u8"Ошибка завершения транзакции")
DECL_ERROR_CODE(rollback_transaction,         10, "ee3f3100-4643-4adf-8c6b-ca823e460d60", u8"Ошибка отмены транзакции")

DECL_ERROR_CODE(select_sql_statement,         10, "f99e821c-7f40-4c6e-aea2-b64ab5ec064c", u8"Ошибка выполнения 'select' sql-запроса")
DECL_ERROR_CODE(insert_sql_statement,         10, "141463a6-6cce-41c5-8a05-2473152ffe57", u8"Ошибка выполнения 'insert' sql-запроса")
DECL_ERROR_CODE(update_sql_statement,         10, "76861790-a004-4170-82e7-3ad608448645", u8"Ошибка выполнения 'update' sql-запроса")
DECL_ERROR_CODE(insert_or_update_sql,         10, "a1ba61bd-8c6d-464a-83e0-1db0d3f25246", u8"Ошибка выполнения 'insert or update' sql-запроса")
DECL_ERROR_CODE(delete_sql_statement,         10, "4ea9c633-0dec-4922-bdf7-3c5fa65f1075", u8"Ошибка выполнения 'delete' sql-запроса")

//--- 20 Ошибки общего плана ---
DECL_ERROR_CODE(failed_user_auth,             20, "2e3eb742-2dbe-48f6-9e2b-d7c6bd0eb2ec", u8"Ошибка аутентификации пользователя")
DECL_ERROR_CODE(user_is_inactive,             20, "446dcb56-60bc-4f8e-8fdb-9429d0774f21", u8"Пользователь не активен")
DECL_ERROR_CODE(user_not_found,               20, "a3806b79-4a15-44c9-ad0b-738e84a4093c", u8"Пользователь не найден")
DECL_ERROR_CODE(failed_web_authoriz,          20, "d1d8705a-89a9-4dce-a332-3019f47a6391", u8"Неудачная авторизация web-сервера")

DECL_ERROR_CODE(report_not_found,             20, "5d27d4b4-c395-49c0-a8b2-dd48df2cf7b3", u8"Отчет не найден")
//DECL_ERROR_CODE(update_valid_flag,          20, "049bf4a9-ed8e-4088-8920-195ffce439ba", u8"Ошибка обновления поля IS_VALID в базе данных")
//DECL_ERROR_CODE(update_active_flag,         20, "b7cf60c3-6128-43c6-882e-6ae1885e29f3", u8"Ошибка обновления поля IS_ACTIVE в базе данных")
DECL_ERROR_CODE(admin_privileges,             20, "3b2b8f38-398b-480e-a4b3-0498dec23d7f", u8"Требуются права администратора")
DECL_ERROR_CODE(webapp_privileges,            20, "9c006eed-d1dc-4a7a-97b9-5979970e72f2", u8"Требуются права web-приложения")
//DECL_ERROR_CODE(user_hashid,                20, "d486aa57-c2c7-42be-848b-5f362e9bcf52", u8"Incorrect user hash id")

DECL_ERROR_CODE(group_not_found,              20, "48719eab-415e-49c2-92c6-c6bb2124c591", u8"Группа не найдена")
DECL_ERROR_CODE(delete_group_with_users,      20, "eb9c378b-3888-4884-b0df-faf13d7739c6", u8"Невозможно удалить группу содержащую пользователей")
DECL_ERROR_CODE(delete_default_group,         20, "5abe9110-93aa-475c-a573-f3ce6f06247b", u8"Невозможно удалить группу по умолчанию")

//--- 30 Ошибки по работе с задачами ---
DECL_ERROR_CODE(task_not_found,               30, "d9a76e6e-c8a1-4217-b8e1-0f7262ecebca", u8"Задача не найдена")
DECL_ERROR_CODE(task_identification_error,    30, "b6823804-3bdc-4b7b-9c07-30e36f093dc3", u8"Идентификатор задачи некорректный")
DECL_ERROR_CODE(task_already_running,         30, "3d61e522-5e40-4a96-88dc-a49384c6b44a", u8"Задача уже выполняется")
DECL_ERROR_CODE(task_not_running,             30, "56ca7744-fa8a-4d35-9762-5d083fe4d94b", u8"Задача не запущена")
DECL_ERROR_CODE(task_calc_next_run,           30, "e8b48ad1-5a6e-40e2-a684-5418a70e30f3", u8"Ошибка вычисления планового времени запуска")
//DECL_ERROR_CODE(task_int_error,             30, "ad1fad9b-3791-45a9-8acd-57e2a2d060a7", u8"Task interruput error")
DECL_ERROR_CODE(task_inncorrect_name,         30, "ef8e4079-e598-4e9b-b681-f07b0c93e437", u8"Некорректное имя или описание задачи")
//DECL_ERROR_CODE(task_no_access,             30, "0960a563-1356-4c6b-9dcb-95c04136601c", u8"No access to run task")
DECL_ERROR_CODE(edit_running_task,            30, "0ed75c91-f6fd-45c8-a7d7-dd3426424af1", u8"Невозможно отредактировать запущенную задачу")
DECL_ERROR_CODE(edit_task_denied,             30, "eae164d3-d93b-4a9e-8db3-7d3af8c57962", u8"Недостаточно прав на редактирование задачи")
DECL_ERROR_CODE(delete_running_task,          30, "7b656a86-90d5-4d5b-a106-2f5772a4fcbf", u8"Невозможно удалить запущенную задачу")
DECL_ERROR_CODE(change_run_mode_task,         30, "a334cde4-d173-4b02-94bb-48831f6e68e7", u8"Невозможно изменить режим запуска у запущенной задачи")
DECL_ERROR_CODE(syncdata_task_not_found,      30, "d4ecb9f5-2b77-49a0-9a07-e06d7b06582c", u8"Задача регулярной синхронизации данных не найдена")
DECL_ERROR_CODE(syncdata_not_running,         30, "92341e85-6f2a-4ef9-93a6-6cdcecba5524", u8"Задача регулярной синхронизации данных не запущена")
DECL_ERROR_CODE(learnmodel_task_not_found,    30, "9f11994b-2bc7-465d-af75-1ccfebfa1c04", u8"Задача обучения модели не найдена")
DECL_ERROR_CODE(learnmodel_task_has_child,    30, "ad53d285-5b61-4f85-8f93-3eef616a2fc4", u8"Задача обучения модели имеет зависимости")
DECL_ERROR_CODE(learnmodel_not_running,       30, "3bfa8a3a-019e-4933-ac3a-8cc67b4c8ddb", u8"Задача обучения модели не запущена")
DECL_ERROR_CODE(scorecalc_task_not_found,     30, "3746b075-6366-4c30-a8ed-16d3ca370808", u8"Задача вычисления применения не найдена")
DECL_ERROR_CODE(scorecalc_task_has_child,     30, "8305c655-7b0f-47bf-a8be-c81b96aceee3", u8"Задача вычисления применения имеет зависимости")
DECL_ERROR_CODE(scorecalc_not_running,        30, "6102232a-5ecc-404d-95ec-bc2ea488b8c6", u8"Задача вычисления применения не запущена")
DECL_ERROR_CODE(learnmodel_periodic_exists,   30, "fc278b26-2a30-41ce-a238-7d742d9aaec7", u8"Периодическая задача обучения модели уже существует")
DECL_ERROR_CODE(scorecalc_periodic_exists,    30, "eba4cb8f-459d-4495-9659-60162b4a7c2e", u8"Периодическая задача вычисления применения уже существует")
DECL_ERROR_CODE(reportfed_task_not_found,     30, "a9edb78c-0cb1-4279-83a7-741386b4fb7b", u8"Задача для создания федерального отчета не найдена")
DECL_ERROR_CODE(syncnsi_task_not_found,       30, "3839e1e0-b81e-4383-8531-d266121326d2", u8"Задача синхронизации справочников НСИ не найдена")

DECL_ERROR_CODE(model_not_found,              30, "0a1cc217-d071-42d8-99da-df70877fe4c2", u8"Модель не найдена")
DECL_ERROR_CODE(model_has_child,              30, "51133e53-ae52-45ba-9e87-29f704129d6d", u8"Модель имеет зависимости")
DECL_ERROR_CODE(score_not_found,              30, "ae441a99-a1e3-4e62-bf8a-2c15210004ec", u8"Применение не найдено")
DECL_ERROR_CODE(score_has_child,              30, "d7f662cb-190f-4b00-97c7-fb023faa0fd6", u8"Применение имеет зависимости")
DECL_ERROR_CODE(notice_not_found,             30, "6edf22ff-f2d4-4a2c-aab6-2fd6b53784d4", u8"Уведомление не найдено")

//--- 40 Ошибки по работе с отчетами ---
DECL_ERROR_CODE(report_name_undef,            40, "3d3e7131-ee04-41be-abbe-0e69dd26c693", u8"Имя для отчета не определено")
DECL_ERROR_CODE(report_type_undef,            40, "2fd27dc7-d965-4a49-83b0-11b74503539f", u8"Не определено тип для отчета")
DECL_ERROR_CODE(report_ranging_undef,         40, "ae8bb032-5dc8-4660-8337-ac9f06e4f063", u8"Не определено ранжирование для отчета")
DECL_ERROR_CODE(report_present_undef,         40, "c2fa7423-dff6-4bec-be60-ef83776e44e9", u8"Не определено представление для отчета")
DECL_ERROR_CODE(report_incorrect_period,      40, "fec3a3b9-615d-4c57-aaf8-295ff7dfa3d0", u8"Некорректный временной период для отчета")
DECL_ERROR_CODE(report_task_running,          40, "238f1996-7fe7-426a-94ae-16e9be0d7fb5", u8"Задача создания отчета уже запущена")

//--- 50 Ошибки по работе с json ---
DECL_ERROR_CODE(json_parse_error,             50, "fd665c40-c2e1-4697-b673-b15e6db9c846", u8"Json parse error")

//--- 60 Ошибки ФОМС сервера  ---
DECL_ERROR_CODE(foms_database_unavailable,    60, "60e36d14-fc4f-4e7e-a249-c7fca1aaca1b", u8"Database unavailable")

//--- 70 Ошибки системы уведомлений  ---
DECL_ERROR_CODE(notify_address_not_unique,    70, "048ec57d-6ec0-45a2-9e68-6494e761342b", u8"Адрес уведомления не уникальный")
DECL_ERROR_CODE(notify_address_not_found,     70, "720e3fde-ae8e-4417-96d1-07d05ccb46be", u8"Адрес уведомления не найден")
DECL_ERROR_CODE(notify_trigger_not_found,     70, "e14b0007-4c63-46f4-97bf-a5420c6a0f8e", u8"Триггер для уведомления не найден")
DECL_ERROR_CODE(notify_foms_already_exists,   70, "0e4370eb-9b68-45bc-a62d-ff713c310dad", u8"Триггер 'foms' уже существует")
DECL_ERROR_CODE(notify_evlog_already_exists,  70, "d2058553-1e5d-4756-b38c-27f15436a06e", u8"Триггер 'evlog' уже существует")
DECL_ERROR_CODE(notify_unknown_trigger_type,  70, "21126943-39f1-4c6d-9ca1-9e2f9137e77f", u8"Неизвестный тип триггера")

//--- 80 Ошибки LDAP сервера  ---
DECL_ERROR_CODE(ldap_answer,                  80, "66b13d1d-6ec3-4600-baca-451e3f3accf9", u8"Ошибка работы с LDAP сервером")

} // namespace error
} // namespace communication
