#pragma once

#include "paging.h"
#include "time_range.h"

#include "shared/qt/quuidex.h"
#include "shared/qt/communication/commands_base.h"
#include "shared/qt/communication/serialization/json.h"

namespace communication {
namespace command {

//----------------------------- Список команд --------------------------------

/** WEB
  Получение списк событий из журнала
*/
extern const QUuidEx EventLogList;

} // namespace command

//---------------- Структуры данных используемые в сообщениях ----------------

namespace data {

struct EventLog
{
    // Время события
    QDateTime createDate = {QDateTime::currentDateTime()};

    // Идентификатор пользователя
    QUuidEx userId;

    // Идентификатор задачи
    QUuidEx taskId;

    // Наименование пользователя
    QString userName;

    // Наименование задачи
    QString taskName;

    // Уровень логирования
    alog::Level level = {alog::Level::Info};

    // Описание события
    QString description;

    // Точка в коде, где событие было эмитировано
    QString location;

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( createDate  )
        J_SERIALIZE_ITEM( userId      )
        J_SERIALIZE_ITEM( taskId      )
        J_SERIALIZE_ITEM( userName    )
        J_SERIALIZE_ITEM( taskName    )
        J_SERIALIZE_ITEM( level       )
        J_SERIALIZE_ITEM( description )
        J_SERIALIZE_ITEM( location    )
   J_SERIALIZE_END
};

struct EventFilter
{
    // Идентификатор пользователя
    QUuidEx userId;

    // Идентификатор задачи
    QUuidEx taskId;

    // Показывать системные записи (для них пользователь не определен)
    bool selectAll = {false};

    // Сортировать список событий по убыванию даты создания
    bool descendSort = {false};

    // Фильтр "Дата создания"
    TimeRange createDate;

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( taskId      )
        J_SERIALIZE_ITEM( userId      )
        J_SERIALIZE_ITEM( selectAll   )
        J_SERIALIZE_ITEM( descendSort )
        J_SERIALIZE_ITEM( createDate  )
    J_SERIALIZE_END
};

struct EventLogList : Data<&command::EventLogList,
                            Message::Type::Command,
                            Message::Type::Answer>
{
    // Фильтр выбора данных
    EventFilter filter;

    // Фильтр для постраничной выборки данных
    PagingInfo paging;

    // Результирующая выборка
    QList<EventLog> items;

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( filter )
        J_SERIALIZE_ITEM( paging )
        J_SERIALIZE_ITEM( items  )
    J_SERIALIZE_END
};

} // namespace data
} // namespace communication


