/*****************************************************************************
  В модуле представлен список идентификаторов команд для коммуникации между
  клиентской и серверной частями приложения.
  В данном модуле представлен список команд персональный для этого приложения.

  Требование надежности коммуникаций: однажды назначенный идентификатор коман-
  ды не должен более меняться.
*****************************************************************************/

#pragma once

#include "shared/qt/quuidex.h"
#include "shared/qt/communication/commands_base.h"
#include "shared/qt/communication/serialization/json.h"
#include <sys/time.h>

namespace communication {
namespace command {

//----------------------------- Список команд --------------------------------

/**
  Команда  используется  для  опроса  ФОМС-сервера  на  предмет работоспособного
  состояния. Если ФОМС сервер находится полностью  в рабочем состоянии, то ответ-
  ное сообщение должно быть пустым со статусом  выполнения  ExecStatus::Success.
  В противном случае сообщение должно вернуть причину неработоспособности сервера.
*/
extern const QUuidEx FomsEcho;


} // namespace command

namespace data {


} // namespace data
} // namespace communication


