#pragma once

#include "shared/qt/quuidex.h"
#include "shared/qt/communication/commands_base.h"
#include "shared/qt/communication/serialization/json.h"

namespace communication {
namespace command {

//----------------------------- Список команд --------------------------------

/** WEB
  Удаление опции из списка базовых настроек XGBoost
*/
extern const QUuidEx ModelXgbDelete;

/** WEB
  Получение списка опций базовых настроек XGBoost
*/
extern const QUuidEx ModelXgbInfo;

/** WEB
  Редактирование опций базовых настроек XGBoost
*/
extern const QUuidEx ModelXgbEdit;

/** WEB
  Включение/отключение опций базовых настроек XGBoost
*/
extern const QUuidEx ModelXgbOption;

} // namespace command

//---------------- Структуры данных используемые в сообщениях ----------------

namespace data {

struct XgbParam
{
   QString name;
   QString value;
   bool    enabled = {true};

   J_SERIALIZE_BEGIN
       J_SERIALIZE_ITEM( name    )
       J_SERIALIZE_ITEM( value   )
       J_SERIALIZE_ITEM( enabled )
   J_SERIALIZE_END
};

struct ModelXgbDelete : Data<&command::ModelXgbDelete,
                              Message::Type::Command>
{
    QUuidEx id;
    QVector<XgbParam> items;

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( id    )
        J_SERIALIZE_ITEM( items )
    J_SERIALIZE_END
};

struct ModelXgbDeleteA : Data<&command::ModelXgbDelete,
                               Message::Type::Answer>
{
    QUuidEx id;
    J_SERIALIZE_ONE( id )
};

struct ModelXgbInfo : Data<&command::ModelXgbInfo,
                            Message::Type::Command>
{
    QUuidEx id;
    J_SERIALIZE_ONE( id )
};

struct ModelXgbInfoA : Data<&command::ModelXgbInfo,
                             Message::Type::Answer>
{
    QUuidEx id;
    QVector<XgbParam> items;

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( id    )
        J_SERIALIZE_ITEM( items )
    J_SERIALIZE_END
};

struct ModelXgbEdit : Data<&command::ModelXgbEdit,
                            Message::Type::Command>
{
    QUuidEx id;
    QVector<XgbParam> items;

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( id    )
        J_SERIALIZE_ITEM( items )
    J_SERIALIZE_END
};

struct ModelXgbEditA : Data<&command::ModelXgbEdit,
                             Message::Type::Answer>
{
    QUuidEx id;
    J_SERIALIZE_ONE( id )
};

struct ModelXgbOption : Data<&command::ModelXgbOption,
                              Message::Type::Command>
{
    QUuidEx id;
    QString name;
    bool    enable = {true};

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( id     )
        J_SERIALIZE_ITEM( name   )
        J_SERIALIZE_ITEM( enable )
    J_SERIALIZE_END
};

struct ModelXgbOptionA : Data<&command::ModelXgbOption,
                               Message::Type::Answer>
{
    QUuidEx id;
    J_SERIALIZE_ONE( id )
};

} // namespace data
} // namespace communication


