#pragma once

#include "commands/commands.h"
#include "commands/group.h"
#include "commands/nsi.h"
#include "commands/upool.h"
#include "commands/user.h"
#include "commands/task.h"
#include "commands/model.h"
#include "commands/report.h"
#include "commands/report_fed.h"
#include "commands/score.h"
#include "commands/notify.h"
#include "commands/xgboost.h"
#include "commands/event_log.h"
#include "commands/sync_data.h"

#include "shared/steady_timer.h"
#include "shared/qt/communication/message.h"
#include "shared/qt/communication/func_invoker.h"
#include "shared/qt/communication/transport/tcp.h"

//#include "../../aisexpert/database/firebird_driver.h"

#include "ui_main_window.h"
#include <QLabel>
#include <QTimer>
#include <QMainWindow>
#include <unistd.h>

using namespace std;
using namespace communication;
using namespace communication::transport;

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
public:
    explicit MainWindow(QWidget *parent = nullptr);
    ~MainWindow();

    bool init(const tcp::Socket::Ptr&);
    void deinit();

    void saveGeometry();
    void loadGeometry();

    void saveSettings();
    void loadSettings();

private slots:
    void message(const communication::Message::Ptr&);
    void socketConnected(communication::SocketDescriptor);
    void socketDisconnected(communication::SocketDescriptor);
    void getMonitoring();
    //void updateLabels(QListWidgetItem& current);

    //--- Обработчики команд ---
    void command_WebAuthorization(const Message::Ptr&);

    void command_SpeedTest(const Message::Ptr&);
    void command_Error(const Message::Ptr&);
    void command_UPoolUserList(const Message::Ptr&);
    void command_UPoolUserAuth(const Message::Ptr&);
    void command_UPoolUserInvalidated(const Message::Ptr&);
    void command_UserInfo(const Message::Ptr&);
    void command_UserList(const Message::Ptr&);
    void command_Monitoring(const Message::Ptr&);

    void command_TaskSyncDataInfo(const Message::Ptr&);

    void command_GroupInfo(const Message::Ptr&);
    void command_GroupList(const Message::Ptr&);
    void command_GroupDelete(const Message::Ptr&);

    void command_TaskProgress(const Message::Ptr&);
    void command_TaskInterrupt(const Message::Ptr&);

    void command_TaskModelCreate(const Message::Ptr&);
    void command_TaskModelEdit(const Message::Ptr&);
    void command_TaskModelDelete(const Message::Ptr&);
    void command_TaskModelInfo(const Message::Ptr&);
    void command_TaskModelList(const Message::Ptr&);

    void command_TaskScoreCreate(const Message::Ptr&);
    void command_TaskScoreEdit(const Message::Ptr&);
    void command_TaskScoreDelete(const Message::Ptr&);
    void command_TaskScoreInfo(const Message::Ptr&);
    void command_TaskScoreList(const Message::Ptr&);
    void command_TaskAlert(const Message::Ptr&);

    void command_ModelEdit(const Message::Ptr&);
    void command_ModelDelete(const Message::Ptr&);
    void command_ModelInfo(const Message::Ptr&);
    void command_ModelList(const Message::Ptr&);
    
    void command_ScoreEdit(const Message::Ptr&);
    void command_ScoreDelete(const Message::Ptr&);
    void command_ScoreInfo(const Message::Ptr&);
    void command_ScoreList(const Message::Ptr&);
    
    void command_TaskReportCreate(const Message::Ptr&);
    void command_ReportList(const Message::Ptr&);    
    void command_ReportInfo(const Message::Ptr&);
    void command_ReportData(const Message::Ptr&);

    void command_TaskReportFedCreate(const Message::Ptr&);
    void command_ReportFedList(const Message::Ptr&);

    void command_TaskContentCreate(const Message::Ptr&);

    void command_ModelXgbDelete(const Message::Ptr&);
    void command_ModelXgbInfo(const Message::Ptr&);
    void command_ModelXgbEdit(const Message::Ptr&);
    void command_ModelXgbOption(const Message::Ptr&);

    void command_EventLogList(const Message::Ptr&);

    void command_SyncProgress(const Message::Ptr&);

    void on_btnSpeedTest_clicked(bool);
    void on_btnSendMailDemo_clicked(bool);

    void on_btnAisConnect_clicked(bool);
    void on_btnAisDisconnect_clicked(bool);
    void on_btnAddTypeTask_clicked(bool);
    void on_btnUpdateTypeTask_clicked(bool);
    void on_btnDeleteTypeTask_clicked(bool);
    void on_btnAddTask_clicked(bool);
    void on_btnUpdateTask_clicked(bool);
    void on_btnDeleteTask_clicked(bool);
    void on_btnGroupAdd_clicked(bool);
    void on_btnGroupEdit_clicked(bool);
    void on_btnGroupDelete_clicked(bool);
    void on_btnGroupInfo_clicked(bool);

    void on_btnAssignGroupUser_clicked(bool);

    void on_btnGetUsers_clicked(bool);
    void on_btnUserInfo_clicked(bool);
    void on_btnCheckPassw_clicked(bool);

    void on_btnDbConnect_clicked(bool);
    void on_btnDbDisconnect_clicked(bool);

    void on_btnDbSelect_clicked(bool);
    void on_btnDbInsert_clicked(bool);
    void on_btnDbGTransact_clicked(bool);
    void on_btnDbDelete_clicked(bool);

    void on_btnSynData_clicked(bool);
    //void on_btnCalcRating_clicked(bool);
    void on_btnSendData_clicked(bool);

    void on_btnSyncDataNow_clicked(bool);
    void on_btnSyncDataInfo_clicked(bool);
    void on_btnSyncDataSet_clicked(bool);
    void on_btnSyncIterrupt_clicked(bool);
    void on_btnCreateSyncPlanningDebug_clicked(bool);
    void on_btnKeepWaitCommand_clicked(bool);
    void on_chkSyncDataMute_clicked(bool);
    void on_btnTaskSyncProgress_clicked(bool);

    void on_btnSyncNsiNow_clicked(bool);

    void on_btnTaskModelStartNow_clicked(bool);
    void on_btnTaskModelStopNow_clicked(bool);

    void on_btnTaskModelCreate_clicked(bool);
    void on_btnTaskModelEdit_clicked(bool);
    void on_btnTaskModelDelete_clicked(bool);
    void on_btnTaskModelInfo_clicked(bool);
    void on_btnTaskModelList_clicked(bool);

    void on_btnTaskScoreStartNow_clicked(bool);
    void on_btnTaskScoreStopNow_clicked(bool);

    void on_btnTaskScoreCreate_clicked(bool);
    void on_btnTaskScoreEdit_clicked(bool);
    void on_btnTaskScoreDelete_clicked(bool);
    void on_btnTaskScoreInfo_clicked(bool);
    void on_btnTaskScoreList_clicked(bool);

    void on_btnModelEdit_clicked(bool);
    void on_btnModelDelete_clicked(bool);
    void on_btnModelInfo_clicked(bool);
    void on_btnModelList_clicked(bool);

    void on_btnScoreEdit_clicked(bool);
    void on_btnScoreDelete_clicked(bool);
    void on_btnScoreInfo_clicked(bool);
    void on_btnScoreList_clicked(bool);

    void on_btnXgbBaseOptionsList_clicked(bool);
    void on_btnAddXgbOptSet_clicked(bool);
    void on_btnClearXgbOptSet_clicked(bool);
    void on_btnXgbEditOptions_clicked(bool);
    void on_btnXgbDelOptions_clicked(bool);
    void on_btnEnableXgbOptSet_clicked(bool);
    void on_btnDisableXgbOptSet_clicked(bool);

    /*void on_btnModelEditButton_clicked(bool);
    void on_btnModelDeleteButton_clicked(bool);
    void on_btnModelInfoButton_clicked(bool);
    void on_btnModelListButton_clicked(bool);*/

    void on_btnCreateReport_clicked(bool);
    void on_btnReportList_clicked(bool);
    void on_btnReportInfo_clicked(bool);
    void on_btnEditReport_clicked(bool);
    void on_btnReportDelete_clicked(bool);
    void on_btnEventLogsClear_clicked(bool);
    void on_btnEventLogsUpdate_clicked(bool);
    void on_btnSendScore_clicked(bool);

    void on_btnXmlCreate_clicked(bool);

    void on_btnTaskReportFedNow_clicked(bool);
    void on_btnCreateReportFed_clicked(bool);
    void on_btnTaskReportFedEdit_clicked(bool);

    void on_btnReportFedList_clicked(bool);
    void on_btnReportFedDelete_clicked(bool);

    void on_btnMonitorThresholdEdit_clicked(bool);

    void checkConnections();
    //void getTaskTypes();
    //void getTasksLog();
    void getGroups();
    void getAisUsers();
    void getTaskModels();
    void getTaskScores(const QUuidEx& userId);
    void getModels();
    void getNotices();
    //void currentTaskTypeChanged(QListWidgetItem*);
    //void currentTaskChanged(QListWidgetItem*);
    void currentGroupChanged(QListWidgetItem*);
    void currentAisUserChanged(QListWidgetItem*);

    void on_lstTaskModels_itemClicked(QListWidgetItem *item);
    void on_lstTaskScores_itemClicked(QListWidgetItem *item);

    void on_lstModels_itemClicked(QListWidgetItem *item);
    void on_lstScores_itemClicked(QListWidgetItem *item);

private:
    Q_OBJECT
    Ui::MainWindow *ui;
    QTimer _connectTimer;
    QLabel* _labelConnectStatus;

    FunctionInvoker _funcInvoker;
    tcp::Socket::Ptr _socket;

    steady_timer _testTimer;
    quint32 _testCount;
    bool _testFirst;

    quint64 _webHashId = {0};

    bool _isMonitoringRunning;
    int  _updateTime;
    QTimer _timerMonitoringUpdate;
    void startMonitoring();

//    QDate GetReportEndDate();
//    int   GetId();

    communication::data::TaskReportCreate GetReportFromUI();
    bool CheckReportData(const communication::data::TaskReportCreate& reportData);
};

Q_DECLARE_METATYPE(communication::data::User)
Q_DECLARE_METATYPE(communication::data::Group)
Q_DECLARE_METATYPE(communication::data::Task)
Q_DECLARE_METATYPE(communication::data::Model)
Q_DECLARE_METATYPE(communication::data::Score)
Q_DECLARE_METATYPE(communication::data::Report)
Q_DECLARE_METATYPE(communication::data::ReportFed)
