import qbs
import QbsUtl
import ProbExt

Product {
    name: "Web Emulator"
    targetName: "web-emulator"
    condition: true

    type: "application"
    destinationDirectory: "./bin"

    Depends { name: "cpp" }
    Depends { name: "cppstdlib" }
    Depends { name: "Commands" }
    Depends { name: "RapidJson" }
    Depends { name: "SharedLib" }
    Depends { name: "Yaml" }
    Depends { name: "lib.firebird" }
    Depends { name: "Qt"; submodules: ["core", "network", "sql", "xml"] }
    Depends {
        condition: Qt.core.versionMajor < 5
        name: "Qt.gui";
    }
    Depends {
        condition: Qt.core.versionMajor >= 5
        name: "Qt.widgets";
    }

    cpp.defines: {
        var def = project.cppDefines;
        return def;
    }

    cpp.cxxFlags: project.cxxFlags
    cpp.cxxLanguageVersion: project.cxxLanguageVersion

    cpp.driverFlags: [
        "--param", "inline-unit-growth=150",
        "--param", "max-inline-insns-single=1000",
    ]

    cpp.systemIncludePaths: QbsUtl.concatPaths(
        Qt.core.cpp.includePaths,
        lib.firebird.includePath
    )

    cpp.rpaths: QbsUtl.concatPaths(
        cppstdlib.path,
        lib.firebird.libraryPath,
        "$ORIGIN/../lib"
    )

    cpp.libraryPaths: QbsUtl.concatPaths(
        lib.firebird.libraryPath
    )

    cpp.dynamicLibraries: {
        var libs = [
            "pthread",
        ].concat(lib.firebird.dynamicLibraries);
        return libs;
    }

    files: [
        "web_emulator.cpp",
        "main_window.cpp",
        "main_window.h",
        "main_window.ui",
        //"../../aisexpert/database/firebird_driver.cpp",
        //"../../aisexpert/database/firebird_driver.h",
        //"../../aisexpert/database/sql_func.cpp",
        //"../../aisexpert/database/sql_func.h",
        //"../../aisexpert/database/sqlcachedresult.cpp",
        //"../../aisexpert/database/sqlcachedresult.h",
    ]

//    property var test: {
//        console.info("=== lib.firebird.includePath ===");
//        console.info(lib.firebird.includePath);
//    }

} // Product

