import qbs
import QbsUtl
import ProbExt

Product {
    name: "XGBoost (example)"
    targetName: "xgboost"
    condition: true

    type: "application"
    destinationDirectory: "./bin"

    Depends { name: "cpp" }
    Depends { name: "cppstdlib" }
    Depends { name: "DmlcCore" }
    Depends { name: "Rabit" }
    Depends { name: "XGBoost" }
    //Depends { name: "SharedLib" }
    //Depends { name: "Yaml" }
    //Depends { name: "lib.firebird" }
    Depends { name: "Qt"; submodules: ["core", "network", "sql", "xml"] }

    cpp.cxxFlags: project.cxxFlags.concat([
        "-Wno-sign-compare",
        "-Wno-unused-variable",
        "-Wno-unused-but-set-variable",
    ])
    cpp.cxxLanguageVersion: project.cxxLanguageVersion

    cpp.systemIncludePaths: QbsUtl.concatPaths(
        Qt.core.cpp.includePaths
    )

    Properties {
        condition: qbs.targetOS.contains("windows")
                   && qbs.toolchain && qbs.toolchain.contains("mingw")

        cpp.staticLibraries: [
            project.windowsKitsPath + "/WS2_32.Lib"
        ]
    }

    cpp.driverFlags: [
        "-fopenmp"
    ]

    files: [
        "utils.cpp",
        "utils.h",
        "xgboost.cpp",
    ]

//    property var test: {
//        console.info("=== cpp.staticLibraries ===");
//        console.info(cpp.staticLibraries);
//    }

} // Product
