#pragma once
#include "user_record.h"
#include <QtCore>
#include <memory>

/**
  Функции для работы с учетными записями ActiveDirectory
*/
namespace account
{

/// Проверка пользователя на валидность
bool checkUser(const QString& login, const QString& password, QString& sid);
/// Получить SID пользователя с логином "login"
void getUserSID(const QString& login, QString& sid);
/// Получение списка пользователей
void getUsers(user::Record::Map& users);
/// Проверка пользователя на валидность
bool checkUser(const QString& login, const QString& password, QString& sid);
/// Аутентифицировать пару "login" и "password"
bool authenticate(const QString& login, const QString& password);
/// Состоит ли пользователь "login" в группе "group"
bool inGroup(const QString& group, const QString& login);
///


} // namespace accounts
