#include "shared/defmac.h"
#if defined(MINGW) && defined(WINDOWS_ACTIVE_DIRECTORY)
#pragma once
#include <string>
#include <vector>
#include "user_record.h"

#define INFO_BUFFER_SIZE 32767

namespace domain
{

bool GetMachineName(QString& machine);
bool GetCurrentUser(QString& user);
bool GetDomainName(const QString& machine, QString& domain );

bool Login(const QString& login, const QString& domain, const QString& passw);
bool InGroup(const QString& login, const QString& group);
bool GetUsers(user::Record::Map& users);
bool UserSID(const QString& login, QString& _sid);

} //namespace domain

#endif
