#ifdef WINDOWS_ACTIVE_DIRECTORY_LDAP
#include <ldap.h>
#include "user_record.h"
#include "defmac.h"

namespace ldap_proto {

struct LDAPMessageFree
{
    LDAPMessage* hResult;
    LDAPMessageFree(LDAPMessage* result);
    ~LDAPMessageFree();
    DISABLE_DEFAULT_FUNC(LDAPMessageFree)
};

#define LDAP_RESULT_AUTO_FREE(HANDLE) \
    LDAPMessageFree __auto_handle_free__(HANDLE); \
    (void) __auto_handle_free__;

struct LDAPUnBind
{
    LDAP* ld;
    LDAPUnBind(LDAP* ld);
    ~LDAPUnBind();
    DISABLE_DEFAULT_FUNC(LDAPUnBind)
};

#define LDAP_RESULT_AUTO_UNBIND(HANDLE) \
    LDAPUnBind __auto_handle_unbind__(HANDLE); \
    (void) __auto_handle_unbind__;


using namespace  std;

bool Login(const QString& login, const QString& domain, const QString& passw);
bool InGroup(const QString& login, const QString& group);
bool UserSID(const QString& login, QString& _sid);
void GetUsers(user::Record::Map& users);
void appendDc(QString& base, const QString& domain) noexcept;

} // namespace ldap_proto

#endif // #ifdef WINDOWS_ACTIVE_DIRECTORY_LDAP
