#pragma once
#include <QtCore>

namespace user
{

/**
 * @brief Формат записи данных о пользователе в кеше.
 */
struct Record
{
    typedef QMap<QString /*SID пользователя*/, Record> Map;

    ~Record() {}

    QString login;
    QString name;
    bool    isAdmin = {false};
    bool    isValid = {false};
};

template<typename R1, typename  R2>
inline bool operator== (const R1& r1, const R2& r2)
{
    return r1.login == r2.login
           && r1.name == r2.name
           && r1.isAdmin == r2.isAdmin
           && r1.isValid == r2.isValid;
}

template<typename R1, typename  R2>
inline bool operator!= (const R1& r1, const R2& r2)
{
    return !operator== (r1, r2);
}

} // namespace user
