#pragma once
#include "defmac.h"
#include "commands/upool.h"
#include "user_record.h"
#include <QtCore>
#include <QVector>
#include <QMap>

namespace user {

using namespace communication;
using namespace communication::data;

class Cache
{
public:
    Cache();

    // Чтение/запись списка пользователей в кеше
    Record::Map users() const {return _users;}
    void setUsers(Record::Map& users) {_users = users;}

    QVector<UPoolUserInfo> upoolUsers() const;

    // Название группы администраторов
    QString rootGroup() const {return _rootGroup;}
    void setRootGroup(const QString& group) {_rootGroup = group;}

    // Название группы пользователей
    QString userGroup() const {return _userGroup;}
    void setUserGroup(const QString& group) {_userGroup = group;}

    // Обновление кеша пользователей запрос в AD или конфиг
    void actualize();

    bool isAdmin(const QString& login);

    bool validateUsers(const Record::Map& aisUsers);
    void validateSids(const QList<UPoolUserInfo>& aisUsers);

    void notifyChanges(const QList<UPoolUserInfo>& changeUsers,
                       const QList<UPoolUserInfo>& newUsers,
                       const QList<QString>& deleteUsers) const;
private:
    DISABLE_DEFAULT_COPY(Cache)

    void applyChanges(const Record::Map& users);

    // Актуальный список пользователей из AD
    Record::Map _users;
    // Название группы администраторов
    QString _rootGroup;
    // Название группы пользователей
    QString _userGroup;

    bool _first = {true};
};

Cache& cache();

} // namespace user
