import qbs
import QbsUtl
import ProbExt

Product {
    name: "UsersPool"
    targetName: "userspool"
    condition: true

    type: "application"
    destinationDirectory: "./bin"

    Depends { name: "cpp" }
    Depends { name: "cppstdlib" }
    Depends { name: "Commands" }
    Depends { name: "RapidJson" }
    Depends { name: "SharedLib" }
    Depends { name: "Yaml" }
    Depends { name: "Qt"; submodules: ["core", "network"] }

    cpp.defines: {
        var def = project.cppDefines;
        return def;
    }

    cpp.cxxFlags: project.cxxFlags
    cpp.cxxLanguageVersion: project.cxxLanguageVersion

    cpp.driverFlags: [
        "--param", "inline-unit-growth=150",
        "--param", "max-inline-insns-single=1000",
    ]

    cpp.systemIncludePaths: QbsUtl.concatPaths(
        Qt.core.cpp.includePaths
    )

    cpp.rpaths: QbsUtl.concatPaths(
        cppstdlib.path,
        "$ORIGIN/../lib"
    )

    cpp.libraryPaths: {
        var path = [];

        if (qbs.targetOS.contains("windows")
            && qbs.toolchain && qbs.toolchain.contains("mingw"))
        {
            path.push(project.windowsKitsPath);
        }
        return path;
    }

    cpp.dynamicLibraries: {
        var libs = [
            "pthread"
        ];

        if (qbs.targetOS.contains("linux"))
        {
            libs.push("ldap", "ssl", "sasl2")
        }

        if (qbs.targetOS.contains("windows")
            && qbs.toolchain && qbs.toolchain.contains("mingw"))
        {
            libs.push("Ole32", "OleAut32", "Gdi32", "User32", "Activeds",
                      "Advapi32", "Adsldpc", "uuid", "ADSIid", "Netapi32");
        }
        return libs;
    }

    files: [
        "account_manager/account_manager.h",
        "account_manager/account_manager.cpp",
        "account_manager/active_directory.h",
        "account_manager/active_directory.cpp",
        "account_manager/function.cpp",
        "account_manager/function.h",
        "account_manager/user_record.h",
        "account_manager/users_cache.h",
        "account_manager/users_cache.cpp",
        "account_manager/ldap_error.h",
        "account_manager/ldap_proto.h",
        "account_manager/ldap_proto.cpp",
        "userspool.cpp",
        "userspool_appl.cpp",
        "userspool_appl.h",
    ]

} // Product

