#pragma once

#include "shared/qt/communication/message.h"
#include <QtCore>
#include <QCoreApplication>
#include <atomic>
#include <ctime>

using namespace communication;
using namespace communication::transport;

class Application : public QCoreApplication
{
public:
    Application(int& argc, char** argv);

    bool init();

    static void stop() {_stop = true;}
    static bool isStopped() {return _stop;}

public slots:
    void stop(int exitCode);

    void message(const communication::Message::Ptr&);
    void socketConnected(communication::SocketDescriptor);
    void socketDisconnected(communication::SocketDescriptor);

    void updateUserList();

private:
    Q_OBJECT
    void timerEvent(QTimerEvent* event) override;

private:
    static volatile bool _stop;
    static std::atomic_int _exitCode;

    int _stopTimerId = {-1};
    int _userListTimerId = {-1};

    typedef QVector<QPair<SocketDescriptor, std::time_t>> SocketPair;
    // Список сокетов ожидающих авторизацию
    SocketPair _waitingAuthorizSockets;
    // Список сокетов ожидающих закрытие
    SocketPair _waitingCloseSockets;

//    struct User
//    {
//        QString login;
//        QString passw;
//        QString name;
//        QString sid;
//        bool    isAdmin = {false};
//    };
    // Список тестовых пользователей
    //QVector<User> _users;

};

