#pragma once

#include "shared/container_ptr.h"
#include "shared/qt/communication/commands_base.h"
#include "shared/qt/communication/serialization/json.h"

namespace communication {
namespace command {

//----------------------------- Список команд --------------------------------

/** WEB
  Команда для получения информации о нагрузке на аппаратную и программную части
*/
extern const QUuidEx Monitoring;


/** WEB
  Команда для получения информации о порогах мониторинга для web-интерфейса
*/
extern const QUuidEx MonitorThresholdInfo;

/** WEB
  Команда для редактирования информации о порогах мониторинга для web-интерфейса
*/
extern const QUuidEx MonitorThresholdEdit;

} // namespace command

namespace data {

struct MonitorHardItem
{
    quint32  system  = {0}; // Потребление ресурса системой в целом
    quint32  process = {0}; // Потребление ресурса программой
    quint32  total   = {0}; // Общее количество ресурса (памяти RAM или HDD)

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( system  )
        J_SERIALIZE_ITEM( process )
        J_SERIALIZE_ITEM( total   )
    J_SERIALIZE_END
};

struct MonitorHardware
{
    MonitorHardItem cpu; // Размерность: проценты (%)
    MonitorHardItem ram; // Размерность: Мбайты
    MonitorHardItem hdd; // Размерность: Мбайты

    QString processName;
    quint32 PID            = {0}; // Process ID - идентификатор процесса
    quint32 nThreads       = {0}; // Общее число потоков процесса
    double  cpuMaxCoreTemp = {0}; // Температура самого горячего ядра процессора

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( cpu            )
        J_SERIALIZE_ITEM( ram            )
        J_SERIALIZE_ITEM( hdd            )
        J_SERIALIZE_ITEM( processName    )
        J_SERIALIZE_ITEM( PID            )
        J_SERIALIZE_ITEM( nThreads       )
        J_SERIALIZE_ITEM( cpuMaxCoreTemp )
    J_SERIALIZE_END
};

struct MonitorSoftItem
{
    quint32 modelCount  = {0};
    quint32 scoreCount  = {0};
    quint32 reportCount = {0};

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( modelCount  )
        J_SERIALIZE_ITEM( scoreCount  )
        J_SERIALIZE_ITEM( reportCount )
    J_SERIALIZE_END
};

struct MonitorSoftware
{
    MonitorSoftItem inWork;      // Задачи находящиеся в работе на данный момент
    MonitorSoftItem inDeferred;  // Отложенные задачи
    qint32 errorCount = {-1};    // Количество задач  завершившихся  с  ошибками
                                 // за последние сутки. Если не удалось получить
                                 // этот параметр,  то  поле  будет  содержать
                                 // занчение -1
    bool fomsIsActive = {false}; // Признак доступности АИС ТФОМС

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( inWork       )
        J_SERIALIZE_ITEM( inDeferred   )
        J_SERIALIZE_ITEM( errorCount   )
        J_SERIALIZE_ITEM( fomsIsActive )
    J_SERIALIZE_END
};

struct Monitoring : Data<&command::Monitoring,
                          Message::Type::Answer>
{
    typedef container_ptr<Monitoring> Ptr;

    MonitorHardware hardware; // Мониторинг технических средств
    MonitorSoftware software; // Функциональный мониторинг

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( hardware )
        J_SERIALIZE_ITEM( software )
    J_SERIALIZE_END
};


struct MonitorThreshold
{
    struct Border
    {
        qint32 warn = {0}; // Уровень предупреждения (в процентах)
        qint32 crit = {0}; // Критический уровень (в процентах)

        J_SERIALIZE_BEGIN
            J_SERIALIZE_ITEM( warn )
            J_SERIALIZE_ITEM( crit )
        J_SERIALIZE_END
    };

    Border cpu;
    Border ram;
    Border hdd;
    Border cputmp;

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( cpu    )
        J_SERIALIZE_ITEM( ram    )
        J_SERIALIZE_ITEM( hdd    )
        J_SERIALIZE_ITEM( cputmp )
    J_SERIALIZE_END
};

struct MonitorThresholdInfo : MonitorThreshold,
                              Data<&command::MonitorThresholdInfo,
                                    Message::Type::Answer,
                                    Message::Type::Event>
{};

struct MonitorThresholdEdit : MonitorThreshold,
                              Data<&command::MonitorThresholdEdit,
                                    Message::Type::Command>
{};

} // namespace data
} // namespace communication


