#pragma once

#include "shared/qt/communication/serialization/json.h"

namespace communication {
namespace data {

struct PagingInfo
{
    // Определяет количество записей на странице (выборке)
    quint32 limit = {0};

    // Определяет сдвиг (исчисляется в записях) от начала данных
    quint32 offset = {0};

    // Возвращаемый параметр, содержит общее число записей в наборе данных.
    // Если общее число записей не удалось получить параметр будет равен -1
    qint32 total = {-1};

#ifdef JSON_SERIALIZATION
    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( limit  )
        J_SERIALIZE_ITEM( offset )
        J_SERIALIZE_ITEM( total  )
    J_SERIALIZE_END
#endif
};

} // namespace data
} // namespace communication

