#pragma once

#include "shared/qt/quuidex.h"
#include "shared/qt/communication/serialization/json.h"

namespace communication {
namespace command {

//----------------------------- Список команд --------------------------------

/** WEB
  Возвращает версию АИС Эксперт
*/
extern const QUuidEx AisVersion;

} // namespace command

//---------------- Структуры данных используемые в сообщениях ----------------

namespace data {

struct AisVersion : Data<&command::AisVersion,
                          Message::Type::Answer>
{
    quint8  major;   // Старший номер версии
    quint8  minor;   // Младший номер версии
    quint8  patch;   // Номер исправления
    QString strver;  // Строковое представление версии
    QString gitrev;  // Хэш git-коммита

    J_SERIALIZE_BEGIN
        J_SERIALIZE_ITEM( major  )
        J_SERIALIZE_ITEM( minor  )
        J_SERIALIZE_ITEM( patch  )
        J_SERIALIZE_ITEM( strver )
        J_SERIALIZE_ITEM( gitrev )
    J_SERIALIZE_END
};

} // namespace data
} // namespace communication


