//#include "aisexpert_appl.h"
//#include "event_log.h"
#include "functions.h"
//#include "user_rights.h"
//#include "xgboost/options.h"
//#include "database/connect.h"
//#include "database/firebird_driver.h"
//#include "monitoring/mail_smtp.h"
//#include "monitoring/notifier.h"
//#include "monitoring/observer.h"
//#include "monitoring/http_connector.h"
//#include "tasks/scheduler.h"
//#include "tasks/sync_plan.h"
//#include "tasks/send_score.h"
#include "shared/defmac.h"
#include "shared/utils.h"
#include "shared/logger/logger.h"
#include "shared/logger/config.h"
#include "shared/qt/logger/logger_operators.h"
#include "shared/qt/qhashex.h"
#include "shared/qt/quuidex.h"
#include "shared/qt/communication/commands_base.h"
#include "shared/qt/communication/commands_pool.h"
#include "shared/qt/communication/message.h"
#include "shared/qt/communication/functions.h"
#include "shared/qt/communication/transport/tcp.h"
#include "shared/qt/config/config.h"
#include "shared/qt/version/version_number.h"
#include "shared/thread/thread_pool.h"
#include "main_window.h"

#include <QtCore>
#include <QApplication>
#include <QNetworkProxy>

#ifdef MINGW
#include <windows.h>
#else
#include <signal.h>
#endif
#include <unistd.h>

using namespace std;
using namespace communication;
using namespace communication::transport;

void initLoggerExt()
{
    QString logConf;
#ifdef MINGW
    config::base().getValue("logger.conf_win", logConf);
#else
    config::base().getValue("logger.conf", logConf);
#endif
    if (!logConf.isEmpty())
    {
        config::dirExpansion(logConf);
        if (QFile::exists(logConf))
            alog::loadSavers(logConf.toStdString());
        else
            log_error << "Logger config file not exists: " << logConf;
    }
    alog::printSaversInfo();
}

void stopLog()
{
    alog::logger().flush();
    alog::logger().waitingFlush();
    alog::logger().stop();
}

void stopProgram()
{
//    monitoring::httpConnector().close();

    /*
    #define STOP_THREAD(THREAD_FUNC, NAME, TIMEOUT) \
        if (!THREAD_FUNC.stop(TIMEOUT * 1000)) { \
            log_info << "Thread '" NAME "': Timeout expired, thread will be terminated"; \
            THREAD_FUNC.terminate(); \
        }
    */

//    STOP_THREAD(task::sendScore(),      "SendScore",       5*60 /* 5 мин*/)
//    STOP_THREAD(task::syncPlan(),       "SyncPlan",        5*60 /* 5 мин*/)
//    STOP_THREAD(task::scheduler(),      "Scheduler",       3*60 /* 3 мин*/)
//    STOP_THREAD(monitoring::mailSmtp(), "MonitorMailSmtp", 65   /*65 сек*/)
//    STOP_THREAD(monitoring::notifier(), "MonitorNotifier", 30   /*30 сек*/)
//    STOP_THREAD(monitoring::observer(), "MonitorObserver", 30   /*30 сек*/)

//    #undef STOP_THREAD

//    webCon().reset();
//    tcp::listener().close();

    fomsCon().disconnect();
//    upoolCon()->disconnect();

    // Удаляем сэйвер для записи лог-сообщений в БД
//    alog::logger().removeSaver("eventlog");

//    // Перед отключением БД нужно сбросить все лог-сообщения
//    alog::logger().flush();
//    alog::logger().waitingFlush();

//    dbpool().close();

    log_info << "'Ais Enulator' is stopped";
    stopLog();

    trd::threadPool().stop();
}

int main(int argc, char *argv[])
{
    // Устанавливаем в качестве разделителя целой и дробной части символ '.',
    // если этого не сделать - функции преобразования строк в числа (std::atof)
    // буду неправильно работать.
    qputenv("LC_NUMERIC", "C");

    // Пул потоков запустим после кода демонизации
    trd::threadPool().stop();

    int ret = 0;
    try
    {
        alog::logger().start();

#ifdef NDEBUG
        alog::logger().addSaverStdOut(alog::Level::Info, true);
#else
        alog::logger().addSaverStdOut(alog::Level::Debug2);
#endif

        QDir homeDir = QDir::home();
        if (!homeDir.exists())
        {
            log_error << "Home dir " << homeDir.path() << " not exists";
            stopLog();
            return 1;
        }

        // Путь к основному конфиг-файлу
        QString configFile = config::dir() + "/ais-emulator.conf";
        if (!QFile::exists(configFile))
        {
            log_error << "Config file " << configFile << " not exists";
            stopLog();
            return 1;
        }

        config::base().setReadOnly(true);
        config::base().setSaveDisabled(true);
        if (!config::base().readFile(configFile.toStdString()))
        {
            stopLog();
            return 1;
        }

        QString configFileS;
#ifdef MINGW
        config::base().getValue("state.file_win", configFileS);
#else
        config::base().getValue("state.file", configFileS);
#endif
        config::dirExpansion(configFileS);
        config::state().readFile(configFileS.toStdString());

        QString logFile;
#ifdef MINGW
        config::base().getValue("logger.file_win", logFile);
        config::dirExpansion(logFile);
#else
        config::base().getValue("logger.file", logFile);
#endif
        config::dirExpansion(logFile);
        QFileInfo logFileInfo {logFile};
        QString logFileDir = logFileInfo.absolutePath();
        if (!QDir(logFileDir).exists())
            if (!QDir().mkpath(logFileDir))
            {
                log_error << "Failed create log directory: " << logFileDir;
                stopLog();
                return 1;
            }

        // Создаем дефолтный сэйвер для логгера
        {
            std::string logLevelStr = "info";
            config::base().getValue("logger.level", logLevelStr);

            bool logContinue = true;
            config::base().getValue("logger.continue", logContinue);

            alog::Level logLevel = alog::levelFromString(logLevelStr);
            alog::SaverPtr saver {new alog::SaverFile("default",
                                                      logFile.toStdString(),
                                                      logLevel,
                                                      logContinue)};
            alog::logger().addSaver(saver);
        }

        log_info << "'Ais Emulator' is running"
                 << " (version " << productVersion().toString() << ")";
        alog::logger().flush();

        alog::logger().removeSaverStdOut();
        alog::logger().removeSaverStdErr();

        // Создаем дополнительные сэйверы для логгера
        initLoggerExt();

        if (!communication::command::checkUnique())
        {
            stopProgram();
            return 1;
        }

        if (!communication::error::checkUnique())
        {
            stopProgram();
            return 1;
        }

        // Пул потоков нужно активировать после кода демонизации
        trd::threadPool().start();

        QApplication appl {argc, argv};
        QApplication::setApplicationName("Ais Emulator " + productVersion().toString());

        // Устанавливаем текущую директорию. Эта конструкция работает только
        // когда создан экземпляр QCoreApplication.
        if (QDir::setCurrent(QCoreApplication::applicationDirPath()))
        {
            log_debug << "Set work directory: " << QCoreApplication::applicationDirPath();
        }
        else
        {
            log_error << "Failed set work directory";
            stopProgram();
            return 1;
        }

        QNetworkProxy::setApplicationProxy(QNetworkProxy::NoProxy);

        // Инициализация подключения к ФОМС
        QHostAddress hostAddress = QHostAddress::Any;
        config::readHostAddress("foms.address", hostAddress);

        int port = 62065;
        config::base().getValue("foms.port", port);
        if (!fomsCon().socket()->init({hostAddress, port}))
        {
            stopProgram();
            return 1;
        }
        fomsCon().socket()->setCompressionLevel(0);
        fomsCon().socket()->setCheckProtocolCompatibility(false);
        fomsCon().socket()->setMessageFormat(SerializationFormat::Json);

        MainWindow mw;
        if (!mw.init())
        {
            //QMessageBox::critical(0, qApp->applicationName(), errMessage);
            stopProgram();
            return 1;
        }
        mw.loadGeometry();
        mw.loadSettings();
        mw.show();

        alog::logger().removeSaverStdOut();
        alog::logger().removeSaverStdErr();

        QMetaObject::invokeMethod(&mw, "checkFomsConnect",  Qt::QueuedConnection);

        ret = appl.exec();

        mw.saveGeometry();
        mw.saveSettings();
        mw.deinit();

        fomsCon().disconnect();
        config::state().save();
    }
    catch (std::exception& e)
    {
        log_error << "Failed initialization. Detail: " << e.what();
        ret = 1;
    }
    catch (...)
    {
        log_error << "Failed initialization. Unknown error";
        ret = 1;
    }

    stopProgram();
    return ret;
}
