#include "functions.h"
//#include "database/connect.h"
//#include "database/sql_func.h"

#include "shared/safe_singleton.h"
#include "shared/spin_locker.h"
#include "shared/logger/logger.h"
#include "shared/qt/logger/logger_operators.h"
#include "shared/qt/communication/logger_operators.h"

#define log_error_m   alog::logger().error  (__FILE__, __func__, __LINE__, "Functions")
#define log_warn_m    alog::logger().warn   (__FILE__, __func__, __LINE__, "Functions")
#define log_info_m    alog::logger().info   (__FILE__, __func__, __LINE__, "Functions")
#define log_verbose_m alog::logger().verbose(__FILE__, __func__, __LINE__, "Functions")
#define log_debug_m   alog::logger().debug  (__FILE__, __func__, __LINE__, "Functions")
#define log_debug2_m  alog::logger().debug2 (__FILE__, __func__, __LINE__, "Functions")

namespace communication {
namespace transport {

bool FomsCon::isConnected() const
{
    SpinLocker locker(_lock); (void) locker;
    return (_socket && _socket->isConnected());
}

tcp::Socket::Ptr FomsCon::socket() const
{
    SpinLocker locker(_lock); (void) locker;
    return _socket;
}

bool FomsCon::send(const Message::Ptr& message) const
{
    SpinLocker locker(_lock); (void) locker;
    if (_socket && _isAuthorized)
        return _socket->send(message);

    return false;
}

void FomsCon::disconnect()
{
    SpinLocker locker(_lock); (void) locker;
    _socket->stop();
    _isAuthorized = false;
}

bool FomsCon::isAuthorized() const
{
    SpinLocker locker(_lock); (void) locker;
    return _isAuthorized;
}

void FomsCon::setAuthorized(bool val)
{
    SpinLocker locker(_lock); (void) locker;
    _isAuthorized = val;
}

FomsCon& fomsCon()
{
    return ::safe_singleton<FomsCon>();
}

} // namespace transport
} // namespace communication

#undef log_error_m
#undef log_warn_m
#undef log_info_m
#undef log_verbose_m
#undef log_debug_m
#undef log_debug2_m
