/*****************************************************************************
  Модуль с функциями общего назначения

*****************************************************************************/

#pragma once

#include "commands/paging.h"
#include "commands/task.h"

#include "shared/defmac.h"
#include "shared/simple_timer.h"
#include "shared/qt/quuidex.h"
#include "shared/qt/qhashex.h"
#include "shared/spin_locker.h"
#include "shared/qt/communication/message.h"
#include "shared/qt/communication/transport/tcp.h"

#include <QtCore>
#include <QtSql>
#include <atomic>
#include <functional>

namespace communication {
namespace transport {

/**
  Используется для обработки подключений к ФОМС-серверу
*/
class FomsCon
{
public:
    bool isConnected() const;

    bool isAuthorized() const;
    void setAuthorized(bool);

    tcp::Socket::Ptr socket() const;
    bool send(const Message::Ptr& message) const;
    void disconnect();

private:
    FomsCon() = default;
    DISABLE_DEFAULT_COPY(FomsCon)

private:
    bool _isAuthorized = {false};
    tcp::Socket::Ptr _socket {new tcp::Socket};

    mutable std::atomic_flag  _lock = ATOMIC_FLAG_INIT;
    template<typename T, int> friend T& ::safe_singleton();
};

FomsCon& fomsCon();

} // namespace transport
} // namespace communication
