#pragma once

#include "shared/qt/communication/message.h"
#include "shared/qt/communication/func_invoker.h"

#include <QMainWindow>
#include <QLabel>

using namespace std;
using namespace communication;
using namespace communication::transport;

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
public:
    explicit MainWindow(QWidget *parent = nullptr);
    ~MainWindow();

    bool init();
    void deinit();

    void saveGeometry();
    void loadGeometry();

    void saveSettings();
    void loadSettings();

public slots:
    void message(const communication::Message::Ptr&);
    void fomsSocketConnected(communication::SocketDescriptor);
    void fomsSocketDisconnected(communication::SocketDescriptor);

    void checkFomsConnect();

    void on_btnConnect_clicked(bool);
    void on_btnDisconnect_clicked(bool);
    void on_btnAuthorization_clicked(bool);

    void on_chkAutoConnect_clicked(bool);
    void on_chkAutoAuthoriz_clicked(bool);

    void on_chkSyncDataCheck_clicked(bool);

    void on_btnGetSyncData1_clicked(bool);
    void on_btnGetSyncData2_clicked(bool);
    void on_btnGetSyncData3_clicked(bool);
    void on_btnSyncDataCheck_clicked(bool);
    void on_btnSyncNsiVidmp_clicked(bool);


private:
    Q_OBJECT
    void timerEvent(QTimerEvent* event) override;

    //--- Обработчики команд ---
    void command_FomsAuthorization(const Message::Ptr&);
    void command_KeepWaitCommand(const Message::Ptr&);
    void command_GetSyncData(const Message::Ptr&);
    void command_GetSyncData1(const Message::Ptr&);
    void command_GetSyncData2(const Message::Ptr&);
    void command_GetSyncData3(const Message::Ptr&);
    void command_SyncDataCheck(const Message::Ptr&);
    void command_SyncNsiVidmp(const Message::Ptr&);

private:
    Ui::MainWindow *ui;
    QLabel* _labelConnectStatus;

    int _fomsConTimerId = {-1};
    FunctionInvoker _funcInvoker;

    const int _defaultWaitTimeout = {60}; // 60 сек
    int _waitTimeout = {_defaultWaitTimeout};

    Message::Ptr _answerMessage;
};
