#include <fstream>
#include <vector>
#include <iterator>
#include <string>
#include <algorithm>
#include <QtCore>
#include <QVector>
#include <QList>

namespace readers {

class CSVReader
{
public:

    QString filename()  {return _filename;}
    QString directory() {return _directory;}
    QChar delimeter()   {return _delimeter;}
    QVector<QString> columnNames() {return  _columnNames;}

    CSVReader();

    void setOptions(const QString&   filename,
                    const QDateTime& timeMark,
                    const quint64    beginTime = 0,
                    const quint64    endTime = 0,
                    const QChar      delimeter = ';');

    bool open();
    void close();

    QVector<QStringList> readRows( qint32 lines);
    void writeRows(const QVector<QStringList>& data);
private:
    QString _filename;
    QString _directory;
    quint64 _beginTime;
    quint64 _endTime;
    QDateTime _timeMark;
    QChar _delimeter;
    bool _isOpen = false;
    QByteArray _content;
    QTextStream _stream;
    quint64 _pos;
    QVector<QString> _columnNames;
    QFile _file;

    QMutex _writeLock;
};

CSVReader& readerStub();
CSVReader& writerStub();

} //namespace readers
