import qbs
import QbsUtl
import ProbExt

Product {
    name: "Foms Emulator"
    targetName: "foms-emulator"
    condition: true

    type: "application"
    destinationDirectory: "./bin"

    Depends { name: "cpp" }
    Depends { name: "cppstdlib" }
    Depends { name: "Commands" }
    Depends { name: "RapidJson" }
    Depends { name: "SharedLib" }
    Depends { name: "Yaml" }
    Depends { name: "Qt"; submodules: ["core", "network"] }

//     ProbExt.LibValidationProbe {
//         id: libValidationProbe
//         checkingLibs: [
//             lib.opencv,
//             lib.pylon
//         ]
//     }

    cpp.defines: {
        var def = project.cppDefines;
        return def;
    }

    cpp.cxxFlags: project.cxxFlags
    cpp.cxxLanguageVersion: project.cxxLanguageVersion

    cpp.driverFlags: [
        "--param", "inline-unit-growth=150",
        "--param", "max-inline-insns-single=1000",
    ]

    cpp.systemIncludePaths: QbsUtl.concatPaths(
        Qt.core.cpp.includePaths
    )

    cpp.rpaths: QbsUtl.concatPaths(
        cppstdlib.path,
        "$ORIGIN/../lib"
    )

//     cpp.libraryPaths: QbsUtl.concatPaths(
//         lib.opencv.libraryPath,
//         lib.pylon.libraryPath,
//         //lib.caffe.libraryPath,
//         project.buildDirectory + "/lib",
//         "/usr/lib/x86_64-linux-gnu/hdf5/serial"
//     )

    cpp.dynamicLibraries: {
        var libs = [
            "pthread",

        ];
        return libs;
    }

//     //cpp.staticLibraries: lib.caffe.staticLibrariesPaths(product)

    files: [
        "foms_emulator.cpp",
        "foms_emulator_appl.cpp",
        "foms_emulator_appl.h",
        "file_utils/csv_reader.cpp",
        "file_utils/csv_reader.h",
    ]

} // Product

