#pragma once

#include "commands/sync_data.h"
#include "shared/qt/communication/message.h"
#include "shared/qt/communication/func_invoker.h"

#include <QtCore>
#include <QCoreApplication>
#include <atomic>

using namespace communication;
using namespace communication::transport;

class Application : public QCoreApplication
{
public:
    Application(int &argc, char **argv);

    static void stop() {_stop = true;}
    static bool isStopped() {return _stop;}

public slots:
    void stop(int exitCode);

    void message(const communication::Message::Ptr&);
    void socketConnected(communication::SocketDescriptor);
    void socketDisconnected(communication::SocketDescriptor);

private:
    Q_OBJECT
    void timerEvent(QTimerEvent* event) override;

    //--- Обработчики команд ---
    void command_FomsAuthorization(const Message::Ptr&);
    void command_GetSyncData(const Message::Ptr&);
    void command_GetSyncData1(const Message::Ptr&);
    void command_GetSyncData2(const Message::Ptr&);
    void command_GetSyncData3(const Message::Ptr&);
    void command_SyncDataCheck(const Message::Ptr&);
    void command_SyncDataCheck1(const Message::Ptr&);
    void command_SyncDataCheck2(const Message::Ptr&);
    void command_SendScore(const Message::Ptr&);
    void command_BreakDataTransfer(const Message::Ptr&);
    void command_SyncNsiVidmp(const Message::Ptr&);

    //--- Методы получения/сохранения данных из/в БД ---
    void requestSyncData(QVector<data::DataItem> &dataBlock,
                         QDateTime begin, QDateTime end, QDateTime timeMark);

private:
    static volatile bool _stop;
    static std::atomic_int _exitCode;

    int _stopTimerId = {-1};

    FunctionInvoker _funcInvoker;
    // Буфер данных для отправки в АИС Эксперт
    QVector<communication::data::DataItem> _data;

    // Временные метки ожидания авторизации
    quint64 _waitingAuthorizSocket = quint64(-1);
    quint64 _waitingCloseSocket = quint64(-1);

    struct CrcItem
    {
        QUuidEx   GKEY;
        QDateTime TIME_MARK;
        bool operator== (const CrcItem& ci) {
            return (GKEY == ci.GKEY) && (TIME_MARK == ci.TIME_MARK);
        }
    };
    QVector<CrcItem> _crc;

};

