# Не самая подходящая для питона структура проекта, по этому импорт выглядит не очень опрятно
# В дальнейшем, когда pyproto будет доступен для установки через pip импорт нужно будет переделать
import sys
sys.path.append("../..")

from copy import copy
from datetime import datetime

from pyproto.pyproto import BaseCommand, Message
from pyproto.pyproto.flags import ExecStatus
from pyproto.pyproto.tools import time_to_int

import config
from commands.userCommands import (
        KEEP_WAIT_COMMAND,
        FOMS_AUTHORIZATION,
        GET_SYNC_DATA,
        SYNC_DATA_CHECK,
        SYNC_NSI_VIDMP
    )


class FomsAuthorization(BaseCommand):
    COMMAND_UUID = FOMS_AUTHORIZATION

    @staticmethod
    def handler(msg):
        password = msg.get_content()['password']
        ans = msg.get_answer_copy()
        if password != config.listener['password']:
            print('WRONG ANSWER')
            ans.set_status(ExecStatus.Failed)
        ans.send_answer()


class KeepWaitCommand(BaseCommand):
    COMMAND_UUID = KEEP_WAIT_COMMAND

    @staticmethod
    def initial(connection, command_id, msg_id, time):
        msg = connection.create_command_msg(KeepWaitCommand.COMMAND_UUID)
        content = dict(
            commandId=command_id,
            messageId=msg_id,
            timeToAdd=time)
        msg.set_content(content)
        return msg

    @staticmethod
    def handler(msg: Message):
        pass


class GetSyncData(BaseCommand):
    COMMAND_UUID = GET_SYNC_DATA

    item = {
        "GKEY": "84d1da82-4331-4972-90bc-ae5aaa68f6cd",
        "IDSL": None,
        "TIME_MARK": None,
        "OT_PER": "1805",
        "MSK_OT": "28",
        "CODE_MSK": "28",
        "VID_MP": "11",
        "USL_OK": "3",
        "PROFIL": "71",
        "MKB1": "J069",
        "MKB2": "",
        "MKB3": "",
        "CODE_USL": "1719600",
        "CODE_MD": "3045",
        "KOL_USL": 1.0,
        "KOL_FACT": 0.0,
        "ISH_MOV": "32",
        "RES_GOSP": "2",
        "TARIF_B": 276.0,
        "TARIF_S": 276.0,
        "TARIF_1K": 0.0,
        "SUM_RUB": 276.0,
        "VID_TR": "",
        "EXTR": 0,
        "CODE_OTD": "",
        "SOUF": 1,
        "SPEC_MD": "90200",
        "DOMC_TYPE": "3",
        "OKATO_INS": "46000000",
        "NOVOR": "0",
        "CODE_LPU": "450102",
        "VID_SF": "14",
        "NHISTORY": "2021064",
        "PERSCODE": "24352",
        "DATE_IN": 1555915540,
        "DATE_OUT": 1555915540,
        "TARIF_D": 0.0,
        "VID_KOEFF": "6",
        "USL_TMP": "",
        "BIRTHDAY": 1555915540,
        "SEX": "1",
        "COUNTRY": "643",
        "SEX_P": "",
        "BIRTHDAY_P": 1555915540,
        "INV": 0,
        "DATE_NPR": 1555915540,
        "FOR_POM": 3,
        "MSE": 0,
        "P_CEL": "2.6",
        "DN": 0,
        "TAL_P": 1555915540,
        "PROFIL_K": 0,
        "NAPR_MO": "",
        "MKB0": "",
        "DS_ONK": 0,
        "VAL_KOEFF": 1.0,
        "C_ZAB": 0,
        "CODE_NOM1": "",
        "CODE_NOM2": "",
        "CODE_NOM3": "",
        "VAL_TMP": "",
        "TIME_FIX": "",
        "TIME_IN": "",
        "TIME_OUT": "",
        "DATE_FIX": "2001-10-07",
        "KATEG_MD": "2",
        "POST_MD": "114",
        "KOL_DEF": "0",
        "VID_PROV": "6",
        "MED_AREA": "",
        "TAL_HMP": "",
        "DATE_HMP": 1555915540,
        "MCOD_OUT": "",
        "NOM_NPR": "",
        "SERIES": "",
        "NAME_MSK": "",
        "OKATO_NAS": "46252558000",
        "PR_LG": "",
        "EKMP": 0.0,
        "MEE": 0.0
    }

    @staticmethod
    def get_sync_data_1(msg: Message):
        ans = msg.get_answer_copy()  # type: Message
        content = ans.get_content()  # type: dict

        datetime_ = datetime.strptime("01.04.2019 11:22:33.444", "%d.%m.%Y %H:%M:%S.%f")
        time_ = time_to_int(datetime_)
        GetSyncData.item['TIME_MARK'] = time_
        content['items'] = [GetSyncData.item]
        ans.send_answer()

    @staticmethod
    def get_sync_data_2(msg: Message):
        ans = msg.get_answer_copy()  # type: Message
        content = ans.get_content()  # type: dict

        datetime_ = datetime.strptime("01.01.1900", "%d.%m.%Y")
        time_ = time_to_int(datetime_)
        items = []

        size = 50
        if content['timeMark'] == -2208999600000:
            size = 5000

        for i in range(size):
            GetSyncData.item['TIME_MARK'] = time_ + i
            items.append(copy(GetSyncData.item))

        content['items'] = items
        ans.send_answer()

    @staticmethod
    def get_sync_data_3(msg: Message):
        ans = msg.get_answer_copy()  # type: Message
        content = ans.get_content()  # type: dict

        datetime_ = datetime.strptime("01.01.1900", "%d.%m.%Y")
        time_ = time_to_int(datetime_)
        items = []

        size = msg.get_content().get('count')
        # это значитс 1ая пачка
        if content['timeMark'] == time_:
            SyncDataCheck.CRC_ITEMS = []

            for i in range(size):
                GetSyncData.item['TIME_MARK'] = time_ + i
                items.append(copy(GetSyncData.item))

                SyncDataCheck.CRC_ITEMS.append(GetSyncData.item['TIME_MARK'])

        # это значитс 2ая пачка
        elif content['timeMark'] == time_ + (size - 1):
            time_shift = content['timeMark']
            for i in range(size-1):
                GetSyncData.item['TIME_MARK'] = time_shift + (i if i % 2 != 0 else i-1)
                items.append(copy(GetSyncData.item))

                SyncDataCheck.CRC_ITEMS.append(GetSyncData.item['TIME_MARK'])

            GetSyncData.item['TIME_MARK'] = time_shift + (size-1)
            items.append(copy(GetSyncData.item))
            SyncDataCheck.CRC_ITEMS.append(GetSyncData.item['TIME_MARK'])
        # это значит 3ая пачка
        else:
            msg.my_connection.KEEP_WAIT_COMMAND_exec(GetSyncData.COMMAND_UUID, msg.get_id(), 10)
            # time.sleep(3)

            time_shift = content['timeMark']
            for i in range(size//2):
                GetSyncData.item['TIME_MARK'] = time_shift + i
                items.append(copy(GetSyncData.item))

                SyncDataCheck.CRC_ITEMS.append(GetSyncData.item['TIME_MARK'])

        content['items'] = items
        ans.send_answer()

    @staticmethod
    def handler(msg: Message):
        if msg.tag() == 2:
            GetSyncData.get_sync_data_2(msg)
        elif msg.tag() == 3:
            GetSyncData.get_sync_data_3(msg)
        else:
            GetSyncData.get_sync_data_1(msg)


class SyncDataCheck(BaseCommand):
    COMMAND_UUID =SYNC_DATA_CHECK
    CRC_ITEMS = []

    @staticmethod
    def sync_data_check1(msg: Message):
        """Просто заглушка"""
        ans = msg.get_answer_copy()
        content = ans.get_content()
        content['crc'] = 42
        ans.send_answer()

    @staticmethod
    def sync_data_check2(msg: Message):
        ans = msg.get_answer_copy()
        content = ans.get_content()
        crc_sum = 0

        # Удаляем повторения
        SyncDataCheck.CRC_ITEMS = list(set(SyncDataCheck.CRC_ITEMS))

        # Подсчёт контрольной суммы
        for item in SyncDataCheck.CRC_ITEMS:
            crc_sum ^= item + 2**64

        content['crc'] = crc_sum
        ans.send_answer()

    @staticmethod
    def handler(msg: Message):
        if msg.tag() == 2:
            SyncDataCheck.sync_data_check2(msg)
        else:
            SyncDataCheck.sync_data_check1(msg)


class SyncNsiVidmp(BaseCommand):
    COMMAND_UUID = SYNC_NSI_VIDMP

    @staticmethod
    def handler(msg: Message):
        ans = msg.get_answer_copy()
        items = [
            {"id": 1, "name": "первичная медико-санитарная помощь"},
            {"id": 2, "name": "скорая, в том числе специализированная, медицинская помощь"},
            {"id": 3, "name": "специализированная, в том числе высокотехнологичная, медицинская помощь"},
            {"id": 4, "name": "паллиативная медицинская помощь"},
            {"id": 11, "name": "первичная доврачебная медико-санитарная помощь"},
            {"id": 12, "name": "первичная врачебная медико-санитарная помощь"},
            {"id": 13, "name": "первичная специализированная медико-санитарная помощь"}
        ]
        content = dict(items=items)
        ans.set_content(content)
        ans.send_answer()
