﻿using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace AisFomsWorker.Db
{
	/// <summary>
	/// Вставляемая запись в БД по выгрузке данных
	/// </summary>
	[Table("ais.HistorySyncData"/*, Schema = "ais"*/)]
	public class HistoryRecord : LoadItem
	{
		[Key] [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
		[Dapper.Contrib.Extensions.KeyAttribute()]
		public Int64 HistorySyncData_Id { get; set; }

		/// <summary>
		/// Внешний ключ на табл. QuerySyncData
		/// </summary>
		public Int64 QuerySyncData_Id { get; set; }

		/// <summary>
		/// ГУИД случая
		/// </summary>
		public Guid IDSL { get; set; }

		/// <summary>
		/// ГУИД услуги в случае
		/// </summary>
		public Guid GKEY { get; set; }

		public DateTime TIME_MARK { get; set; }
		public long QTIME_MARK { get; set; }

		public int QDATE_IN { get; set; }
		public int QDATE_OUT { get; set; }
		public int QBIRTHDAY { get; set; }
		public int QBIRTHDAY_P { get; set; }
		public int QDATE_NPR { get; set; }
		public int QTAL_P { get; set; }

		//public DateTime? dt_ins { get; set; }
		//public string user_ins { get; set; }
	}
}
