﻿using Newtonsoft.Json;
using System;

namespace AisFomsWorker.Dll
{
	/// <summary>
	/// Запрос на сверку контрольной суммы синхронизацию данных
	/// </summary>
	public class CheckContent : SyncContent {
		public Int64 crc { get; set; }
	}

	public class CheckParam: CheckContent
	{
		[JsonIgnore] public DateTime DatBeg { get; set; }
		[JsonProperty("DatBeg")]
		public string Dat_Beg {
			get { return DatBeg.ToString("dd.MM.yyyy"); }
			set { DatBeg = DateTime.Parse(value); }
		}

		[JsonIgnore] public DateTime DatEnd { get; set; }
		[JsonProperty("DatEnd")]
		public string Dat_End
		{
			get { return DatEnd.ToString("dd.MM.yyyy"); }
			set { DatEnd = DateTime.Parse(value); }
		}

		[JsonIgnore] public DateTime TimeMark { get; set; }
		[JsonProperty("TimeMark")]
		public string Time_Mark
		{
			get { return TimeMark.ToString("dd.MM.yyyy HH:mm:ss.fff"); }
			set { TimeMark = DateTime.Parse(value); }
		}
	}
}
