﻿using System;
using System.Collections.Generic;

namespace AisFomsWorker.Dll
{
	public enum Command
	{
		Unknown,
		Error,
		ProtocolCompatible,
		CloseConnection,
		Hello,
		KeepWaitCommand,


		SpeedTest,
		UPoolAuthorization,
		FomsAuthorization,
		WebAuthorization,
		UPoolUserList,
		UPoolValidUsers,
		UPoolChangesNotify,
		UPoolSidVerify,
		UPoolUserAuth,
		UserActiveStatus,
		UserActiveSet,
		UserResetAuth,
		UserLogout,
		UserInfo,
		UserList,
		FomsEcho,
		SyncData,
		SendData,
		SyncDataCheck,
		RequestSyncData,
		GetSyncData,
		GetSyncData2,
		SyncDataCount,
		RequestNsiData,
		GetNsiData,
		SendScore,
		SendScoreData,
		SendScoreCheck,

		SendReport,
		SendReportData,

		SmoScores,
		RequestSmoScore,
		GetSmoScoreData,
		BreakDataTransfer,

		GroupAdd,
		GroupEdit,
		GroupDelete,
		GroupInfo,
		GroupList,
		AssignGroup,

		TaskStartNow,
		TaskProgress,
		TaskInterrupt,
		TaskInterruptDone,

		TaskModelCreate,
		TaskModelEdit,
		TaskModelDelete,
		TaskModelInfo,
		TaskModelList,

		TaskScoreCreate,
		TaskScoreEdit,
		TaskScoreDelete,
		TaskScoreInfo,
		TaskScoreList,

		TaskContentCreate,
		TaskAlert,

		ModelEdit,
		ModelDelete,
		ModelInfo,
		ModelList,

		ScoreEdit,
		ScoreDelete,
		ScoreInfo,
		ScoreList,

		CreateSyncPlanning,
		CreateSyncPlanningDebug,
		SyncDataNow,
		SyncDataEnabled,
		SyncDataInfo,
		SyncDataSet,
		// NSI
		SyncNsiVidmp,
		SyncNsiProfile,
		SyncNsiLpu,
		SyncNsiMkb,

		TaskReportCreate,
		ReportInfo,
		ReportList,
		ReportData,
		ReportEdit,
		ReportDelete,

		ModelXgbDelete,
		ModelXgbInfo,
		ModelXgbEdit,
		ModelXgbOption,

		EventLogList,
		Monitoring,

		AisVersion,
	}

	public class Commands
	{
		private static Dictionary<Command, string> cmd = new Dictionary<Command, string>();
		private static Dictionary<string, Command> cmd2 = new Dictionary<string, Command>();

		private static void REGISTRY_COMMAND_SINGLPROC(Command command, string id)
		{
			try
			{
				cmd.Add(command, id);
				cmd2.Add(id, command);
			}
			catch
			{
			}
		}

		public static Command GetCommand(string id)
		{
			Command c;
			if (cmd2.TryGetValue(id, out c))
			{
				return c;
			}
			return Command.Unknown;
		}

		public static string GetCommandID(Command command)
		{
			string id;
			if (cmd.TryGetValue(command, out id))
			{
				return id;
			}
			return null;
		}

		static Commands()
		{
			REGISTRY_COMMAND_SINGLPROC(Command.Unknown, "4aef29d6-5b1a-4323-8655-ef0d4f1bb79d");
			REGISTRY_COMMAND_SINGLPROC(Command.Error, "b18b98cc-b026-4bfe-8e33-e7afebfbe78b");
			REGISTRY_COMMAND_SINGLPROC(Command.ProtocolCompatible, "173cbbeb-1d81-4e01-bf3c-5d06f9c878c3");
			REGISTRY_COMMAND_SINGLPROC(Command.CloseConnection, "e71921fd-e5b3-4f9b-8be7-283e8bb2a531");
			REGISTRY_COMMAND_SINGLPROC(Command.Hello, "fea6b958-dafb-4f5c-b620-fe0aafbd47e2");
			REGISTRY_COMMAND_SINGLPROC(Command.KeepWaitCommand, "edbd2b76-eee4-4ad5-80c0-b95dc0e2dfeb");


			REGISTRY_COMMAND_SINGLPROC(Command.SpeedTest, "b2e4557e-80eb-4b86-8bfa-7a12caade6d0");

			REGISTRY_COMMAND_SINGLPROC(Command.UPoolAuthorization, "bf0510fb-66b8-454a-8eb9-ddd286520ffa");
			REGISTRY_COMMAND_SINGLPROC(Command.FomsAuthorization, "2898212c-870e-44b0-adb8-8a1a845a1f70");
			REGISTRY_COMMAND_SINGLPROC(Command.WebAuthorization, "7bd4b1c1-3f8f-4bcf-b941-5a0f1e7b449f");

			REGISTRY_COMMAND_SINGLPROC(Command.UPoolUserList, "2ec05fe5-366a-41c9-a283-5a617767738d");
			REGISTRY_COMMAND_SINGLPROC(Command.UPoolValidUsers, "c0feaea0-eb2f-4c12-92fd-74629bdd8ea9");
			REGISTRY_COMMAND_SINGLPROC(Command.UPoolChangesNotify, "c0feaea0-eb2f-4c13-92fd-74629bdd8ea9");
			REGISTRY_COMMAND_SINGLPROC(Command.UPoolSidVerify, "c0feaea0-eb2f-4c14-92fd-74629bdd8ea9");
			REGISTRY_COMMAND_SINGLPROC(Command.UPoolUserAuth, "fc7f12a8-9643-4e81-9d27-53b99c19d319");

			REGISTRY_COMMAND_SINGLPROC(Command.UserActiveStatus, "972a16d6-baa1-4410-98e4-1c7a9734481b");
			REGISTRY_COMMAND_SINGLPROC(Command.UserActiveSet, "ef443931-fceb-497c-89cf-0156aa98a057");
			REGISTRY_COMMAND_SINGLPROC(Command.UserResetAuth, "14c292a9-5e92-4c8d-8f61-ba3658254754");
			REGISTRY_COMMAND_SINGLPROC(Command.UserLogout, "481a49e4-e970-4748-9c3d-5e131a4a08e7");
			REGISTRY_COMMAND_SINGLPROC(Command.UserInfo, "56f0f673-b93e-470d-9325-8e4a64afdc3e");
			REGISTRY_COMMAND_SINGLPROC(Command.UserList, "2fa92c5d-7f0a-44ca-9dcc-c10c9d5c60d3");

			REGISTRY_COMMAND_SINGLPROC(Command.FomsEcho, "a8313da2-dd5d-4697-89fe-c0d89a6b715f");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncData, "cbff8510-0dfe-11e9-ab14-d663bd873d93");

			REGISTRY_COMMAND_SINGLPROC(Command.SendData, "cbff8512-0dfe-11e9-ab14-d663bd873d93");

			REGISTRY_COMMAND_SINGLPROC(Command.RequestSyncData, "cbff8920-0dfe-11e9-ab14-d663bd873d93");
			REGISTRY_COMMAND_SINGLPROC(Command.GetSyncData, "cbff8821-0dfe-11e9-ab14-d663bd873d93");
			REGISTRY_COMMAND_SINGLPROC(Command.GetSyncData2, "0a4359c7-e1e0-4cb6-89be-9d798930dc2c");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncDataCheck, "545535a0-ed69-4587-bdf7-f6cb19b8da60");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncDataCount, "ecc2fa12-1782-4ae4-8026-acbce9680f7d");

			REGISTRY_COMMAND_SINGLPROC(Command.RequestNsiData, "1baf0501-8463-45e4-9209-0368c1232355");
			REGISTRY_COMMAND_SINGLPROC(Command.GetNsiData, "34b4517d-902c-4f93-857f-ebf928fbb3bf");

			REGISTRY_COMMAND_SINGLPROC(Command.SendScore, "cbff8923-0dfe-11e9-ab14-d663bd873d93");
			REGISTRY_COMMAND_SINGLPROC(Command.SendScoreData, "cbff8822-0dfe-11e9-ab14-d663bd873d93");
			REGISTRY_COMMAND_SINGLPROC(Command.SendScoreCheck, "53982e4a-9430-4cb3-8743-da3e696b6fd0");

			REGISTRY_COMMAND_SINGLPROC(Command.SendReport, "42f0163b-6743-40a7-9d30-ca980707faea");
			REGISTRY_COMMAND_SINGLPROC(Command.SendReportData, "ed24ce5f-9f69-44b3-9cc5-1b933f6eb8ab");

			REGISTRY_COMMAND_SINGLPROC(Command.SmoScores, "d307296e-fc68-432e-8972-54060e439347");
			REGISTRY_COMMAND_SINGLPROC(Command.RequestSmoScore, "a372111a-f4af-4861-9c61-eb3ab1b08451");
			REGISTRY_COMMAND_SINGLPROC(Command.GetSmoScoreData, "8b67a97a-576f-4dfa-93ba-22ea4a374752");
			REGISTRY_COMMAND_SINGLPROC(Command.BreakDataTransfer, "cbff8e30-0dfe-11e9-ab14-d663bd873d93");

			REGISTRY_COMMAND_SINGLPROC(Command.GroupAdd, "5fc81e1e-2b4d-43c0-983e-8e218ff9e8f9");
			REGISTRY_COMMAND_SINGLPROC(Command.GroupEdit, "02118def-10e5-4fca-b492-63cf5f62a1d9");
			REGISTRY_COMMAND_SINGLPROC(Command.GroupDelete, "b5bcfc10-40eb-4b99-ac3e-44e4377944eb");
			REGISTRY_COMMAND_SINGLPROC(Command.GroupInfo, "47afc108-ff2e-45d4-86f8-0b6292f6c358");
			REGISTRY_COMMAND_SINGLPROC(Command.GroupList, "ee9f9ffd-62a7-4bf3-87bf-02644a99c260");
			REGISTRY_COMMAND_SINGLPROC(Command.AssignGroup, "842876d0-3ee0-4c56-a125-3e715e40c1d2");

			REGISTRY_COMMAND_SINGLPROC(Command.TaskStartNow, "3088861b-f6ff-456f-9c6c-0325344898c2");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskProgress, "12561ec5-e3ba-45ff-96b8-f147456afaba");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskInterrupt, "903ccdae-443f-4aaa-89d2-6eb4f787ebb3");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskInterruptDone, "7b63393f-2a54-4132-9b00-367625e9b85c");

			REGISTRY_COMMAND_SINGLPROC(Command.TaskModelCreate, "50d9cc3e-c54e-42dc-9ca9-af740764d489");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskModelEdit, "2a3e45d9-42b5-4861-8ddc-9b0bc8538743");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskModelDelete, "7dfebaa2-79b2-44d0-9654-3969842484b1");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskModelInfo, "33263c34-4afb-4f85-b4fb-67f49933428a");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskModelList, "e59db341-1dfb-48ad-a2ad-8ad48a1f85f3");

			REGISTRY_COMMAND_SINGLPROC(Command.TaskScoreCreate, "b87fd1ab-663e-4586-ab38-07a2d3de675c");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskScoreEdit, "30545d4e-a83f-4b4a-b4ca-2c7321c50e3f");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskScoreDelete, "3bf9ccd5-b1e7-4f73-a47f-5043fceb1aad");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskScoreInfo, "90a04054-39ed-4601-ae89-b8f4c11f5b9e");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskScoreList, "5c0210ab-cc1e-4704-b747-03922dc3e27f");

			REGISTRY_COMMAND_SINGLPROC(Command.TaskContentCreate, "2e51292d-c37a-4dcb-9035-6f78a38569e6");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskAlert, "292d2e51-9f5a-9035-94dc-6fa38585c37a");

			REGISTRY_COMMAND_SINGLPROC(Command.ModelEdit, "16a56acd-e551-41d9-ac0c-e0ed9f1fab78");
			REGISTRY_COMMAND_SINGLPROC(Command.ModelDelete, "7615c9e3-b236-4365-9b0b-ada257f17bba");
			REGISTRY_COMMAND_SINGLPROC(Command.ModelInfo, "28c510a8-7923-46ed-89a5-5699362b8bc5");
			REGISTRY_COMMAND_SINGLPROC(Command.ModelList, "829aef04-b7d0-4efa-9906-69369c0a30f0");

			REGISTRY_COMMAND_SINGLPROC(Command.ScoreEdit, "8ec320fa-73f9-4ddf-b535-c2bdb5837da0");
			REGISTRY_COMMAND_SINGLPROC(Command.ScoreDelete, "7c9f6b60-8ef2-4e72-85da-dde4eb66c37b");
			REGISTRY_COMMAND_SINGLPROC(Command.ScoreInfo, "71253bcc-5b18-487a-a9ef-0a06acdb1bca");
			REGISTRY_COMMAND_SINGLPROC(Command.ScoreList, "d7fc2b29-8c9a-4d84-bb72-ad005ac3dffe");

			REGISTRY_COMMAND_SINGLPROC(Command.CreateSyncPlanning, "48815c00-b09b-49c8-a07e-dc4d610da863");
			REGISTRY_COMMAND_SINGLPROC(Command.CreateSyncPlanningDebug, "28b6a424-fd5c-4421-a81f-18371f142c8c");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncDataNow, "7aadf7c4-b689-4198-b994-aa52f9742283");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncDataEnabled, "67b5e7c3-dd9c-4cd8-97a6-17206dac5f39");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncDataInfo, "8d80f7e0-25d0-4aba-9bcf-73ec8d529fcd");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncDataSet, "254c0f87-359a-4657-9092-d4e653dae348");

			//REGISTRY_COMMAND_SINGLPROC(MedicalProfileList,       "fcdb379e-b78b-497a-a250-57edb30d3c31")
			//REGISTRY_COMMAND_SINGLPROC(MedicalProfileInfo,       "749e942d-62b9-4f3f-9d94-c3e4e54138d5")
			//REGISTRY_COMMAND_SINGLPROC(KindOfHelpList,           "d10e573e-ef3b-42b9-9252-7875f7166c7a")
			//REGISTRY_COMMAND_SINGLPROC(KindOfHelpInfo,           "637600de-9a26-4e18-bfc4-c32869979a2f")
			//REGISTRY_COMMAND_SINGLPROC(DiagnosisList,            "c97cc066-b722-44ca-b04f-02e48f37f814")
			//REGISTRY_COMMAND_SINGLPROC(DiagnosisInfo,            "6e2599ca-bdbd-460e-acb7-b80a17d0fb71")
			//REGISTRY_COMMAND_SINGLPROC(ClinicList,               "4cfbb44f-39c5-4ba4-9abb-e6387020b729")
			//REGISTRY_COMMAND_SINGLPROC(ClinicInfo,               "8aff74a7-dd49-4fb9-b4b3-47f7128af5cb")

			//REGISTRY_COMMAND_SINGLPROC(Command.NsiVidmpList, "18d4ba47-95aa-45c1-8ed4-5f888638f90a");
			//REGISTRY_COMMAND_SINGLPROC(Command.NsiProfileList, "d1da093d-346e-45ff-88cf-75a97cc94e6f");
			//REGISTRY_COMMAND_SINGLPROC(Command.NsiLpuList, "d0fa1b55-2f33-4b32-b189-1fd8a78e98d5");
			//REGISTRY_COMMAND_SINGLPROC(Command.NsiMkbList, "a2322349-7629-426d-9e36-b36e6a5a8099");

			REGISTRY_COMMAND_SINGLPROC(Command.TaskReportCreate, "147b9b31-c4a5-468f-ae5d-b930f9cfc1d1");
			REGISTRY_COMMAND_SINGLPROC(Command.ReportInfo, "9dec65db-9e82-4651-a0d0-4cd35d53b6f6");
			REGISTRY_COMMAND_SINGLPROC(Command.ReportList, "c9dbbd69-e70f-4123-910a-886863b639e9");
			REGISTRY_COMMAND_SINGLPROC(Command.ReportData, "7091cd69-1a27-4c13-b4c1-720064300559");
			REGISTRY_COMMAND_SINGLPROC(Command.ReportEdit, "4e61d479-100d-4c72-be13-2c359d819389");
			REGISTRY_COMMAND_SINGLPROC(Command.ReportDelete, "6c62b4fb-308f-43ea-b198-8047311f64ca");

			REGISTRY_COMMAND_SINGLPROC(Command.ModelXgbDelete, "be983008-05c5-4009-b4d1-9d6e4dd6884c");
			REGISTRY_COMMAND_SINGLPROC(Command.ModelXgbInfo, "16f55bb2-ecea-406e-8569-cf64ec545e2e");
			REGISTRY_COMMAND_SINGLPROC(Command.ModelXgbEdit, "5d199423-be4d-49a3-8687-8a7e1fdc9a2a");
			REGISTRY_COMMAND_SINGLPROC(Command.ModelXgbOption, "11b010e6-8d7d-4641-a3b2-abaf2be675ad");

			REGISTRY_COMMAND_SINGLPROC(Command.EventLogList, "87f3207f-8f65-4be9-8841-9b55fcb6c23f");
			REGISTRY_COMMAND_SINGLPROC(Command.Monitoring, "641fd153-22e4-4959-9e6b-889d6cea3181");

			REGISTRY_COMMAND_SINGLPROC(Command.AisVersion, "3b52226b-cf24-4ccf-bb61-7877a3348dde");

			REGISTRY_COMMAND_SINGLPROC(Command.SyncNsiVidmp, "feadcdf0-e4d4-4b6d-8716-c850e0a8931f");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncNsiProfile, "66e3dc8f-9b0b-44ca-826e-08ab531aae5a");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncNsiLpu, "342801f6-4a79-48d9-9d20-aed8d3b277a8");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncNsiMkb, "0c4ab327-5799-410a-b49c-5896883d88da");
		}
	}
}
