﻿using System;

namespace AisFomsWorker.Dll
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Linq;

	/// <summary>
	/// Запрос на синхронизацию данных
	/// </summary>
	public class CatalogContent : SyncContent
	{
		public int count { get; set; }
		public JArray items { get; set; }
	}

	public class CatalogParam : CatalogContent
	{
		[JsonIgnore] public DateTime DatBeg { get; set; }
		[JsonProperty("DatBeg")]
		public string Dat_Beg {
			get { return DatBeg.ToString("dd.MM.yyyy"); }
			set { DatBeg = DateTime.Parse(value); }
		}

		[JsonIgnore] public DateTime DatEnd { get; set; }
		[JsonProperty("DatEnd")]
		public string Dat_End
		{
			get { return DatEnd.ToString("dd.MM.yyyy"); }
			set { DatEnd = DateTime.Parse(value); }
		}

		[JsonIgnore] public DateTime TimeMark { get; set; }
		[JsonProperty("TimeMark")]
		public string Time_Mark
		{
			get { return TimeMark.ToString("dd.MM.yyyy HH:mm:ss.fff"); }
			set { TimeMark = DateTime.Parse(value); }
		}
	}

	/// <summary>
	/// Загружаемая запись в АИС
	/// </summary>
	public class AisReestrItem
	{
		public Guid GKEY { get; set; }
		public Guid IDSL { get; set; }
		public long TIME_MARK { get; set; }
		public String OT_PER { get; set; }
		public String MSK_OT { get; set; }
		public String CODE_MSK { get; set; }
		public Int32 VID_MP { get; set; } // = 0;
		public Int32 USL_OK { get; set; } // = 0;
		public Int32 PROFIL { get; set; } // = 0;
		public String MKB1 { get; set; }
		public String MKB2 { get; set; }
		public String MKB3 { get; set; }
		public String CODE_USL { get; set; }
		public String CODE_MD { get; set; }
		public double KOL_USL { get; set; } // = 0;
		public double KOL_FACT { get; set; } // = 0;
		public String ISH_MOV { get; set; }
		public Int32 RES_GOSP { get; set; } // = 0;
		public double TARIF_B { get; set; } // = 0;
		public double TARIF_S { get; set; } // = 0;
		public double TARIF_1K { get; set; } // = 0;
		public double SUM_RUB { get; set; } // = 0;
		public String VID_TR { get; set; }
		public String EXTR { get; set; }
		public String CODE_OTD { get; set; }
		public String SOUF { get; set; }
		public Int32 SPEC_MD { get; set; } // = 0;
		public Int32 DOMC_TYPE { get; set; } // = 0;
		public String OKATO_INS { get; set; }
		public String NOVOR { get; set; }
		public String CODE_LPU { get; set; }
		public String VID_SF { get; set; }
		public String NHISTORY { get; set; }
		public String PERSCODE { get; set; }
		public int DATE_IN { get; set; } // = 0;
		public int DATE_OUT { get; set; } // = 0;
		public double TARIF_D { get; set; } // = 0;
		public String VID_KOEFF { get; set; }
		public String USL_TMP { get; set; }
		public int BIRTHDAY { get; set; } // = 0;
		public String SEX { get; set; }
		public String COUNTRY { get; set; }
		public String SEX_P { get; set; }
		public int BIRTHDAY_P { get; set; } // = 0;
		public String INV { get; set; }
		public int DATE_NPR { get; set; } // = 0;
		public Int32 FOR_POM { get; set; } // = 0;
		public String MSE { get; set; }
		public String P_CEL { get; set; }
		public String DN { get; set; }
		public int TAL_P { get; set; } // = 0;
		public String PROFIL_K { get; set; }
		public String NAPR_MO { get; set; }
		public String MKB0 { get; set; }
		public Int32 DS_ONK { get; set; } // = 0;
		public Int32 VAL_KOEFF { get; set; } // = 0;
		public String C_ZAB { get; set; }
		public double EKMP { get; set; } // = 0;
		public double MEE { get; set; } // = 0;
	}
}
