﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AisFomsWorker.Dll
{
    using Newtonsoft.Json;
    using System.IO;
    using System.Xml;
	using System.Xml.Serialization;
	using System.Reflection;
    using System.Globalization;

    /// <summary>
    /// to-do: Перетащить весь функционал Dll в AisExpLibrary
    /// </summary>
    public static class Utils
	{
		public delegate void WriterDelegate(string message, bool clearning = false);

		public static int SwapEndianness(int value)
		{
			var b1 = (value >> 0) & 0xff;
			var b2 = (value >> 8) & 0xff;
			var b3 = (value >> 16) & 0xff;
			var b4 = (value >> 24) & 0xff;
			return b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
		}

		/*private uint SwapEndianness(uint value) {
			var b1 = (value >> 0) & 0xff;
			var b2 = (value >> 8) & 0xff;
			var b3 = (value >> 16) & 0xff;
			var b4 = (value >> 24) & 0xff;
			return b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
		}*/

		public static Guid ChangeByteOrder(Guid guid)
		{
			var s = guid.ToByteArray();
			var d = new byte[]
						{
						s[3], s[2], s[1], s[0], s[5], s[4], s[7], s[6],
						s[8], s[9], s[10], s[11], s[12], s[13], s[14], s[15]
						};

			return new Guid(d);
		}

		public static string GetID(this Command cmd)
		{
			return Commands.GetCommandID(cmd);
		}

		public static void SaveObjInXml<T>(T prm, Func<string> OnFileName)
		{
			var serializer = new XmlSerializer(typeof(T));
			try
			{
				string fileName = OnFileName();
				//if (File.Exists(fileName)) File.Delete(fileName);
				XmlDocument xmlDocument = new XmlDocument();
				using (MemoryStream stream = new MemoryStream())
				{
					XmlSerializerNamespaces ns = new XmlSerializerNamespaces();
					ns.Add("", "");
					serializer.Serialize(stream, prm, ns);
					stream.Position = 0;
					xmlDocument.Load(stream);
					XmlWriterSettings xws = new XmlWriterSettings();
					xws.Encoding = System.Text.Encoding.GetEncoding("windows-1251");
					xws.Indent = true;
					xws.OmitXmlDeclaration = true;
					using (XmlWriter xw = XmlWriter.Create(fileName, xws))
					{
						xmlDocument.Save(xw);
						xw.Flush();
						xw.Close();
					}
					stream.Flush();
					stream.Close();
					stream.Dispose();
				}
			}
			catch (Exception ex)
			{
				//Log exception here
			}
		}

		/*private static void SaveObjInJson<T>(T prm, Func<string> OnFileName)
		{
			try
			{
				string fileName = OnFileName();
				if (File.Exists(fileName)) File.Delete(fileName);
				JsonSerializer serializer = new JsonSerializer();
				//serializer.Converters.Add(new JavaScriptDateTimeConverter());
				serializer.NullValueHandling = NullValueHandling.Ignore;
				using (StreamWriter sw = new StreamWriter(fileName))
				using (JsonWriter writer = new JsonTextWriter(sw))
				{
					serializer.Serialize(writer, prm);
				}
			}
			catch (Exception ex)
			{
				//Log exception here
			}
		}*/

		public static T LoadObjFromXmlString<T>(string Body)
		{
			T result = default(T);
			var serializer = new XmlSerializer(typeof(T));
			using (var reader = new StringReader(Body))
			{
				try
				{
					result = (T)serializer.Deserialize(reader);
				}
				catch (Exception e)
				{
					result = default(T);
				}
			}
			return result; //*/
			/*T result = default(T);
			var serializer = new XmlSerializer(typeof(T));
			byte[] encodedString = Encoding.UTF8.GetBytes(Body);
			using (MemoryStream ms = new MemoryStream(encodedString))
			{ //(var reader = new StringReader(XmlText)) {
			  // Put the byte array into a stream and rewind it to the beginning
				ms.Flush();
				ms.Position = 0;
				try
				{
					result = (T)serializer.Deserialize(ms);
				}
				catch (Exception e)
				{
					result = default(T);
					throw e;
				}
			}
			return result;//*/
		}

		public static long ToLongUnixTime(DateTime date)
		{
			//return (long)(date.ToUniversalTime() - new DateTime(1970, 1, 1)).TotalMilliseconds;
			TimeSpan span = (date.ToUniversalTime() - new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc));
			return (long)span.TotalMilliseconds;
		}

		public static int ToShortUnixTime(DateTime date)
		{
			//return (int)(date.ToUniversalTime() - new DateTime(1970, 1, 1)).TotalSeconds;
			TimeSpan span = (date.ToUniversalTime() - new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc));
			return (int)span.TotalSeconds;
		}

		public static DateTime FromUnixTimeMs(long unixTime, bool local = true)
		{
			//DateTime dt = new DateTime(1970, 1, 1).AddMilliseconds(unixTime);
			//return local ? dt.ToLocalTime() : dt;
			DateTimeOffset dateTimeOffset = DateTimeOffset.FromUnixTimeMilliseconds(unixTime);
			return dateTimeOffset.LocalDateTime;
		}

		public static DateTime FromUnixTimeSec(int unixTime, bool local = true)
		{
			//DateTime dt = new DateTime(1970, 1, 1).AddSeconds(unixTime);
			//return local ? dt.ToLocalTime() : dt;
			DateTimeOffset dateTimeOffset = DateTimeOffset.FromUnixTimeSeconds(unixTime);
			return dateTimeOffset.LocalDateTime;
		}

		/// <summary>
		/// Конвертор коллекций по названию свойств
		/// </summary>
		/// <typeparam name="T">Исходный класс</typeparam>
		/// <typeparam name="X">Выходной класс</typeparam>
		/// <param name="Items">Исходный массив</param>
		/// <returns>Результирующий список</returns>
		public static List<X> ConvertToAis<T, X>(T[] Items) where X : class, new()
		{
			Type inpType = typeof(T);
			Type aisType = typeof(X);
			var popAis = new List<string>();
			foreach (var prop in aisType.GetProperties(BindingFlags.Public | BindingFlags.SetProperty | BindingFlags.Instance))
			{
				var pr = inpType.GetProperty(prop.Name);
				if (pr != null)
				{
					popAis.Add(prop.Name);
				}
			};
			var result = new List<X>();
			for (int i = 0; i < Items.Length; i++)
			{
				var thous = Items[i];
				X Item = new X();
				/*string propName = "";
				try {//*/
				foreach (var pr in popAis)
				{
					string propName = pr;
					var Prop = inpType.GetProperty(propName);
					var propType = Nullable.GetUnderlyingType(Prop.PropertyType);
					bool isNullType = (propType != null);
					if (!isNullType) propType = Prop.PropertyType;
					var value = Prop.GetValue(thous);
					String val = "";
					var prop = aisType.GetProperty(propName);
					var pt = Nullable.GetUnderlyingType(prop.PropertyType);
					bool ptNullType = (pt != null);
					if (!ptNullType) pt = prop.PropertyType;

					if (propType == typeof(String))
					{
						val = (String)value ?? "";
					}
					else if (propType == typeof(Int64))
					{
						val = (isNullType && value == null) ? String.Empty/*default(Int64)*/ : ((Int64)value).ToString(CultureInfo.InvariantCulture);
					}
					else if (propType == typeof(Int32))
					{
						val = (isNullType && value == null) ? String.Empty/*default(Int32)*/ : ((Int32)value).ToString(CultureInfo.InvariantCulture);
					}
					else if (propType == typeof(Int16))
					{
						val = (isNullType && value == null) ? String.Empty/*default(Int16)*/ : ((Int16)value).ToString(CultureInfo.InvariantCulture);
					}
					else if (propType == typeof(Double))
					{
						val = (isNullType && value == null) ? String.Empty/*default(Double)*/ : ((Double)value).ToString(CultureInfo.InvariantCulture);
					}
					else if (propType == typeof(DateTime))
					{
						if (pt == typeof(Int64))
							val = (isNullType && value == null) ? String.Empty/*0*/ : Utils.ToLongUnixTime((DateTime)value).ToString(CultureInfo.InvariantCulture);
						else if (pt == typeof(Int32))
							val = (isNullType && value == null) ? String.Empty/*0*/ : Utils.ToShortUnixTime((DateTime)value).ToString(CultureInfo.InvariantCulture);
						else
							throw new Exception("Неправильный выходной тип на дату");
						if (String.IsNullOrEmpty(val) && (pt == typeof(Int64) || pt == typeof(Int32)) && !ptNullType)
							val = "0";
					}
					else if (propType == typeof(Boolean))
					{
						val = (isNullType && value == null) ? String.Empty/*default(Boolean)*/ : ((bool)value ? 1 : 0).ToString(CultureInfo.InvariantCulture);
					}

					if (pt == typeof(String))
					{
						aisType.GetProperty(propName).SetValue(Item, val);
					}
					else if (pt == typeof(Int64))
					{
						aisType.GetProperty(propName).SetValue(Item, Int64.Parse(val, CultureInfo.InvariantCulture));
					}
					else if (pt == typeof(Int32))
					{
						aisType.GetProperty(propName).SetValue(Item, Int32.Parse(val, CultureInfo.InvariantCulture));
					}
					else if (pt == typeof(Int16))
					{
						aisType.GetProperty(propName).SetValue(Item, Int16.Parse(val, CultureInfo.InvariantCulture));
					}
					else if (pt == typeof(Double))
					{
						aisType.GetProperty(propName).SetValue(Item, Double.Parse(val, CultureInfo.InvariantCulture));
					}
					else if (pt == typeof(Boolean))
					{
						aisType.GetProperty(propName).SetValue(Item, Boolean.Parse(val));
					}
					else
						throw new Exception(String.Format("Необрабатываемый тип <{1}> у свойства [{0}] класса '{2}'.", propName, prop.PropertyType.Name, String.Format("{0}.{1}", aisType.Namespace, aisType.Name)));
				};
				/*}
				catch (Exception e) {
					throw e;
				}//*/
				result.Add(Item);
			}
			return result;
		}
	}
}
