﻿using System;
using System.Xml.Serialization;

namespace AisFomsWorker.Dll
{
	/// <summary>
	/// Класс Xml логера события подключение сервера АИС к клиенту ТФОМС
	/// </summary>
	[Serializable] 
	[XmlRoot("LOGGER")]
	public class XmlLoggerFile
	{
		[XmlAttribute] public string ConnectionDate { get; set; }

		public Message CompatibleQuery { get; set; }
		[XmlElement("Compatible")] public Message CompatibleAnswer { get; set; }

		public Message AuthorizationQuery { get; set; }
		[XmlElement("Authorization")] public Message AuthorizationAnswer { get; set; }
		
		public Message Query { get; set; }

		[XmlElement("Description")]
		public string Descr { get; set; }
		public bool DescrSpecified { get { return !String.IsNullOrEmpty(Descr); } }

		[XmlElement("Answer")]
		public Message[] Answer { get; set; }

		public string Error { get; set; }
	}
}
