﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AisFomsWorker
{
	using AisFomsWorker.Db;
	using Dll;
	using Newtonsoft.Json.Linq;
	using System.IO;
	using Dapper;
	using Utils = Dll.Utils;
	using System.Reflection;
	using System.Threading;
    using System.Threading.Tasks;
    using Dapper.Contrib.Extensions;
    using System.Data;
    using System.IO.Compression;

    public partial class Foms_Client
	{
		/// <summary>
		/// Получение ответа на запрос синхронизации данных ТФОМС из АИС
		/// </summary>
		/// <param name="InputMessage">Исходный запрос</param>
		/// <param name="CatalogPrm">Параметры исходящего запроса</param>
		/// <param name="cancellationToken">Токен отмены</param>
		/// <param name="onItemsReturned">Делегат "после получение данных"</param>
		/// <param name="onSaved">Делегат "после формирования истории"</param>
		/// <param name="onResult">Делегат после формирования результата</param>
		private async Task<Message> getSyncData2(Message InputMessage, CatalogParam CatalogPrm, CancellationToken cancellationToken,
			Action onItemsReturned, Action<List<HistoryRecord>> onSaved, Action<Message, CatalogContent, AisReestrItem[], List<HistoryRecord>> onResult)
		{
			var datBeg = CatalogPrm.DatBeg;
			var datEnd = CatalogPrm.DatEnd;
			var timeMark = CatalogPrm.TimeMark;
			int recCount = CatalogPrm.count;
			var qTimeMark = CatalogPrm.timeMark;

			//Type inpType = typeof(LoadItem); 
			Type inpType = null; 
			//LoadItem[] Items = null; 
			ILoadItem[] Items = null;
			if (!DbConectSuccess) this.CheckDbConnect();
			if (!DbConectSuccess) { //*/
				string fileDemo = Path.GetFullPath(AppDomain.CurrentDomain.BaseDirectory + @"\..\..\Exp1000Demo.xml");
				if (System.Diagnostics.Debugger.IsAttached && File.Exists(fileDemo)) { // считываем данные с xml файла
					string xmlText = File.ReadAllText(fileDemo, Encoding.GetEncoding(1251));
					var demoThousand = Utils.LoadObjFromXmlString<Xml1000Demo>(xmlText);
					inpType = typeof(LoadDemoItem);
					Items = demoThousand.Items ?? new LoadDemoItem[0];
				}
				else
					throw new Exception("Database unavailable"); // to-do: отправлять АИСу --- 60 Ошибки ФОМС сервера  ---
					//		DECL_ERROR_CODE(foms_database_unavailable, 60, "60e36d14-fc4f-4e7e-a249-c7fca1aaca1b", u8"Database unavailable")
			}
			else {
				Exception innExc = null;
				try {
					int? commandTimeout = null;
					if (this.DbObjTimeoutParam != null && DbObjTimeoutParam.GetRegistryLoad > 0)
						commandTimeout = DbObjTimeoutParam.GetRegistryLoad;
					DatabaseConnection.Open();
					Items = (await DatabaseConnection.QueryAsync<LoadItem>(
									new CommandDefinition(
										"ais.GetRegistry",
										parameters: new
										{
											DatBeg = datBeg,
											DatEnd = datEnd,
											TimeMark = timeMark,
											RecCount = recCount,
											QTimeMark = qTimeMark
										},
										commandType: System.Data.CommandType.StoredProcedure,
										commandTimeout: commandTimeout,
										cancellationToken: cancellationToken
									))
							).ToArray();
					inpType = typeof(LoadItem);
				} 
				catch (Exception e) {
					innExc = e;
				}
				finally {
					if (DatabaseConnection.State != System.Data.ConnectionState.Closed)
						DatabaseConnection.Close();
				}
				if (innExc != null)
					throw innExc;
			};//*/

			onItemsReturned();
			cancellationToken.ThrowIfCancellationRequested();

			Type dstType = typeof(HistoryRecord);
			var props = dstType.GetProperties(BindingFlags.Public | BindingFlags.SetProperty | BindingFlags.Instance).Select(p => p.Name).ToArray();

			//var Loaded = Utils.ConvertToAis<LoadItem, AisReestrItem>(Items);
			MethodInfo methodInfo = typeof(Utils).GetMethod("ConvertToAis", BindingFlags.Static | BindingFlags.Public);
			MethodInfo methodRun = methodInfo.MakeGenericMethod(new Type[] { inpType, typeof(AisReestrItem) });
			List<AisReestrItem> Loaded = (List<AisReestrItem>)methodRun.Invoke(null, new object[] { Items });

			var History = new List<HistoryRecord>();
			for (int i = 0; i < Loaded.Count; i++) {
				var thous = Items[i];
				var Item = Loaded[i];

				var lst = History.LastOrDefault(t => t.TF_UIDIDSL.Equals(thous.TF_UIDIDSL));
				Item.IDSL = (lst == null) ? Guid.NewGuid() : lst.IDSL;
				Item.GKEY = Guid.NewGuid();

				HistoryRecord historyRec = new HistoryRecord();
				foreach (var name in props) {
					string prName = name;
					try {
						var prop = inpType.GetProperty(name);
						if (prop == null) continue;
						var val = prop.GetValue(thous);
						dstType.GetProperty(name).SetValue(historyRec, val);
					}
					catch (Exception e) {
						throw e;
					}
				}
				historyRec.GKEY = Item.GKEY;
				historyRec.IDSL = Item.IDSL;
				
				historyRec.QDATE_IN = Item.DATE_IN;
				historyRec.QDATE_OUT = Item.DATE_OUT;
				historyRec.QBIRTHDAY = Item.BIRTHDAY;
				historyRec.QBIRTHDAY_P = Item.BIRTHDAY_P;
				historyRec.QDATE_NPR = Item.DATE_NPR;
				historyRec.QTAL_P = Item.TAL_P;
				History.Add(historyRec);
			}

			if (onSaved != null)
				onSaved(History);

			var answer = InputMessage.GetAnswer();

			AisReestrItem[] result = Loaded.ToArray();

			CatalogPrm.items = JArray.FromObject(result);
			CatalogPrm.count = recCount;
			CatalogContent obj = (CatalogContent)CatalogPrm;
			answer.content = JObject.FromObject(obj);
			answer.maxTimeLife = null;

			onResult(answer, obj, result, History);

			return answer;
		}

		/// <summary>
		/// Обрабатывает входящий запрос от АИС на синхронизацию данных из ТФОМС
		/// </summary>
		/// <param name="LoggerFile">Объект xml логера</param>
		/// <param name="InputMessage">Исходный запрос</param>
		/// <param name="FileName">файл xml логера</param>
		/// <param name="OnDate">Дата команды</param>
		/// <param name="Dir">Директория логера</param>
		/// <param name="FileNamePart">Частичка имени файла логера</param>
		/// <param name="MaxTimeLife">Время ожидание АИС (сек)</param>
		/// <param name="sw">Объект подсчета времени</param>
		/// <param name="WaitContinue">Предел секунд, чтобы кинуть KeepWaitCommand и успеть</param>
		private void SyncData2(XmlLoggerFile LoggerFile, Message InputMessage,
			ref string FileName, DateTime OnDate, string Dir, ref string FileNamePart,
			int MaxTimeLife, System.Diagnostics.Stopwatch sw, int WaitContinue
		) {
			int ms = 1000 * MaxTimeLife;
			var answers = new List<Message>();
			CatalogContent content = InputMessage.content.ToObject<CatalogContent>();
			DateTime startDate = new DateTime(1970, 1, 1);
			var contParam = new CatalogParam()
			{
				period = content.period,
				DatBeg = content.period.begin.HasValue ? Utils.FromUnixTimeMs(content.period.begin.Value) : startDate,
				DatEnd = content.period.end.HasValue ? Utils.FromUnixTimeMs(content.period.end.Value) : startDate,
				count = content.count,
				timeMark = content.timeMark,
				TimeMark = Utils.FromUnixTimeMs(content.timeMark),
				items = null
			};

			FileNamePart = String.Format("SyncData ({0} - {1}; {2}; {3}) ", contParam.DatBeg.ToString("dd.MM.yyyy"), contParam.DatEnd.ToString("dd.MM.yyyy"), contParam.TimeMark.ToString("dd.MM.yyyy HH+mm+ss,fff"), content.count);
			string fileName = String.Format("{0}\\{2}{1}.xml", Dir, OnDate.ToString("HH-mm-ss"), FileNamePart);
			File.Move(FileName, fileName);
			FileName = fileName;
			string fileNamePart = FileNamePart;

			LoggerFile.Descr = String.Format("{0} - Синхронизация данных начата", DateTime.Now.ToString());
			LoggerFile.Query.content = JObject.FromObject(contParam);
			SaveLoggerXml(LoggerFile, FileName);
			if (contParam.DatBeg == startDate || contParam.DatEnd == startDate || (content.period.begin ?? 0) > (content.period.end ?? 0))
				throw new Exception("Неправильные даты period");

			if (DatabaseConnection != null && DatabaseConnection is System.Data.SqlClient.SqlConnection) {
				var minSqlDate = new DateTime(1753, 1, 1, 12, 0, 0); // особенность скл сервера на передачу маленькой даты
				if (contParam.TimeMark < minSqlDate) {
					contParam.TimeMark = minSqlDate;
					contParam.timeMark = Utils.ToLongUnixTime(contParam.TimeMark);
				}
			};

			// сохраняем запрос от сервера в БД
			QuerySyncRecord querySaver = null;
			if (!DbConectSuccess) this.CheckDbConnect();
			if (DbConectSuccess) {
				try {
					querySaver = new QuerySyncRecord()
					{
						GID = Guid.Parse(InputMessage.id),
						QDatBeg = content.period.begin.Value,
						DatBeg = contParam.DatBeg,
						QDatEnd = content.period.end.Value,
						DatEnd = contParam.DatEnd,
						MaxTimeLife = InputMessage.maxTimeLife,
						QTimeMark = content.timeMark,
						TimeMark = contParam.TimeMark,
						RecordCount = content.count,
						dt_ins = DateTime.Now,
						user_ins = "Ais_Worker"
					};
					long newId = DatabaseConnection.Insert(querySaver);
					if (querySaver.QuerySyncData_Id == 0 && newId > 0)
						querySaver.QuerySyncData_Id = newId;
					LoggerFile.Descr += String.Format(" (QuerySyncData_Id={0})", querySaver.QuerySyncData_Id);
					SaveLoggerXml(LoggerFile, FileName);
				}
				catch (Exception shg) {
					this.WriteError(shg);
					querySaver = null;
				};
			}

			Type typHist = typeof(HistoryRecord); // формируем имя таблицы на скл сервере
			string tableName = typHist.Name, schema = "dbo";
			var tableAttr = typHist.GetCustomAttribute<System.ComponentModel.DataAnnotations.Schema.TableAttribute>();
			if (tableAttr != null)
			{
				if (!String.IsNullOrEmpty(tableAttr.Name))
					tableName = tableAttr.Name;
				if (String.IsNullOrEmpty(tableAttr.Schema))
				{
					if (tableName.IndexOf('.') > -1)
					{
						schema = tableName.Split('.')[0];
						tableName = tableName.Split('.')[1];
					}
				}
				else
					schema = tableAttr.Schema;
			};
			var datTable = new DataTable(tableName, schema);
			var colsInfo = typHist.GetProperties(BindingFlags.Public | BindingFlags.SetProperty | BindingFlags.Instance)
					.Select(t => {
						string propName = t.Name, colName = "";
						if (t.GetCustomAttribute<KeyAttribute>() == null || t.GetCustomAttribute<System.ComponentModel.DataAnnotations.Schema.NotMappedAttribute>() != null)
						{
							var cola = t.GetCustomAttribute<System.ComponentModel.DataAnnotations.Schema.ColumnAttribute>();
							colName = (cola == null) ? propName : ((System.ComponentModel.DataAnnotations.Schema.ColumnAttribute)cola).Name;
						};
						return new { PropName = propName, Info = new Tuple<string, Type>(colName ?? propName, t.PropertyType) };
					})
					.Where(t => !String.IsNullOrEmpty(t.Info.Item1))
				.ToDictionary(x => x.PropName, y => y.Info);
			foreach (var col in colsInfo)
			{
				var datCol = new DataColumn(col.Value.Item1);
				var nullType = Nullable.GetUnderlyingType(col.Value.Item2);
				datCol.DataType = nullType ?? col.Value.Item2;
				datCol.AllowDBNull = (nullType != null) || (datCol.DataType == typeof(String));
				datTable.Columns.Add(datCol);
			}

			int savHistoryCount = 0, n = 0;

			DateTime dtTimeMark = Utils.FromUnixTimeMs(0);
			long? maxTM = null;
			if (contParam.TimeMark > startDate) {
				dtTimeMark = contParam.TimeMark;
			};
			maxTM = Utils.ToLongUnixTime(dtTimeMark.AddMilliseconds(1));
			int hMs = 1;
			/*if (DatabaseConnection != null && DatabaseConnection is System.Data.SqlClient.SqlConnection) // set TIME_MARK type datetime2
				hMs = 5; //*/

			Message answer = null; string jsonFile = "";
			var taskMsg = this.getSyncData2(InputMessage, contParam, ProcessTokenSource.Token,
					onItemsReturned: () => {
						ProcessTokenSource.Token.ThrowIfCancellationRequested();
						if (!AliveClient()) { // ловим обрыв после завершения скл запроса
							ProcessTokenSource.Cancel(throwOnFirstException: true);
							LoggerFile.Descr += String.Format("; {0} Сервер АИС разорвал соединение", DateTime.Now.ToString());
							SaveLoggerXml(LoggerFile, fileName);
						}
					},
					onSaved: (HistoryLst) => {
						if ((HistoryLst ?? new List<HistoryRecord>()).Count == 0) return;
						/// присваиваем искуственный TIME_MARK + приращение hMs
						HistoryLst.ForEach(item => {
							item.QuerySyncData_Id = (querySaver==null || querySaver.QuerySyncData_Id<1) ? 0 : querySaver.QuerySyncData_Id;

							maxTM = maxTM.Value + hMs;
							item.QTIME_MARK = maxTM.Value;
							item.TIME_MARK = Utils.FromUnixTimeMs(item.QTIME_MARK);
							//string s = item.TIME_MARK.ToString("dd.MM.yyyy HH-mm-ss.fff");

							var row = datTable.NewRow();
							foreach (var col in colsInfo) {
								var prop = typHist.GetProperty(col.Key);
								var value = prop.GetValue(item);
								row[col.Value.Item1] = value ?? DBNull.Value;
							}
							savHistoryCount++;
							datTable.Rows.Add(row);
						});
					},
					onResult: (resMsg, catalog, items, HistoryLst) => {
						ProcessTokenSource.Token.ThrowIfCancellationRequested();
						savHistoryCount = (savHistoryCount == items.Length) ? items.Length : 0;
						n = items.Length;

						for (int i = 0; i < n; i++) {
							items[i].TIME_MARK = HistoryLst[i].QTIME_MARK;
						}
						catalog.items = JArray.FromObject(items);

						dtTimeMark = startDate; // зануляем
						maxTM = (n == 0) ? (long?)null : items.Max(t => t.TIME_MARK);
						if (maxTM.HasValue) {
							dtTimeMark = Utils.FromUnixTimeMs(maxTM.Value);
							//string s = dtTimeMark.ToString("dd.MM.yyyy HH-mm-ss.fff");
						}

						resMsg.Descr = String.Format("{0} - Пакет размером {1} записей готов к отправке ", DateTime.Now.ToString(), n);
						jsonFile = String.Format("{0}\\{2}{1}.json", Dir, OnDate.ToString("HH-mm-ss"), fileNamePart);
						SaveObjInJson<CatalogContent>(catalog, jsonFile);

						resMsg.content = JObject.FromObject(catalog);
					}
				);

			const int addSecLife = 15;

			int lastWait = sw.Elapsed.Seconds, secWait = 0, waitCount = 0; // посылаем wait в 1й раз ВСЕГДА
			if (true || (MaxTimeLife - lastWait) < WaitContinue)
			{
				secWait = WaitContinue - (MaxTimeLife - lastWait);
				var keepWait = BuildWaitCommand(InputMessage, MaxTimeLife + addSecLife);
				SendData(binWriter, keepWait, false);
				sw.Restart();
				keepWait.Num = ++waitCount;
				keepWait.Descr = String.Format("First waiter = {0}", DateTime.Now.ToString());
				answers.Add(keepWait);
				LoggerFile.Answer = answers.ToArray();
				SaveLoggerXml(LoggerFile, FileName);
			}

			bool tcpServerDisconnected = false;
			while (!taskMsg.IsCompleted)
			{
				taskMsg.Wait(ms);

				//Thread.Sleep(minMsCheck);
				if (taskMsg.IsCompleted) break;
				if (taskMsg.IsFaulted) throw taskMsg.Exception;

				if (!tcpServerDisconnected && !AliveClient()) {
					ProcessTokenSource.Cancel(throwOnFirstException: true);
					LoggerFile.Descr += String.Format("; {0} Сервер АИС разорвал соединение", DateTime.Now.ToString());
					SaveLoggerXml(LoggerFile, FileName);
					Thread.Sleep(2500); //throw new Exception("Соединение разорвано");
					tcpServerDisconnected = true;
					//break;
				}

				if (!tcpServerDisconnected) {
					var keepWait = BuildWaitCommand(InputMessage, MaxTimeLife + addSecLife);
					SendData(binWriter, keepWait, false);
					sw.Restart();
					keepWait.Num = ++waitCount;
					keepWait.Descr = String.Format("Waiter = {0}", DateTime.Now.ToString());
					answers.Add(keepWait);
					LoggerFile.Answer = answers.ToArray();
					SaveLoggerXml(LoggerFile, FileName);
				}
			}

			lastWait = sw.Elapsed.Seconds; // посылаем wait в последний раз
			if (!tcpServerDisconnected && (MaxTimeLife - lastWait) < WaitContinue)
			{
				secWait = WaitContinue - (MaxTimeLife - lastWait);
				var keepWait = BuildWaitCommand(InputMessage, secWait);
				SendData(binWriter, keepWait, false);
				sw.Restart();
				keepWait.Num = ++waitCount;
				keepWait.Descr = String.Format("Last waiter = {0}", DateTime.Now.ToString());
				answers.Add(keepWait);
				LoggerFile.Answer = answers.ToArray();
				SaveLoggerXml(LoggerFile, FileName);
			}

			answer = taskMsg.Result;
			SendData(binWriter, answer, false); //sw.ElapsedMilliseconds
			answer.Descr += String.Format("; {0} - пакет отправлен (запас ожидания {1} мс от начального MaxTimeLife={2}){3}", 
								DateTime.Now.ToString(), ms - sw.Elapsed.Milliseconds, ms
								, (!maxTM.HasValue) ? "" :  " {"+String.Format("maxTimeMark={0}, qtm={1}", dtTimeMark.ToString("dd.MM.yyyy HH-mm-ss.fff"), maxTM) + "}"
							);
			sw.Stop();

			string zipFile = "";
			if (!String.IsNullOrEmpty(jsonFile) && File.Exists(jsonFile))
				try { /// архивируем JSON результат 
					zipFile = Path.GetDirectoryName(jsonFile) + "\\" + Path.GetFileNameWithoutExtension(jsonFile) + String.Format(" [{0}]", n) + ".zip"; //Path.ChangeExtension(jsonFile, "zip");
					using (var fileStream = new FileStream(zipFile, FileMode.CreateNew)) {
						using (var archive = new ZipArchive(fileStream, ZipArchiveMode.Create, true)) {
							var bytes = File.ReadAllBytes(jsonFile);
							var fileTitle = Path.GetFileName(jsonFile);
							var zipArchiveEntry = archive.CreateEntry(fileTitle, CompressionLevel.Optimal);
							using (var zipStream = zipArchiveEntry.Open())
								zipStream.Write(bytes, 0, bytes.Length);
							archive.Dispose();
						}
						fileStream.Dispose();
					}
				}
				catch {
					zipFile = null;
				}
			if (!String.IsNullOrEmpty(zipFile)) {
				try {
					File.Delete(jsonFile);
				}
				catch {
					//
				}
			}

			answer.content = JObject.FromObject(new { OnDate = DateTime.Now.ToString(), Length = n });
			answers.Add(answer);
			LoggerFile.Answer = answers.ToArray();
			SaveLoggerXml(LoggerFile, FileName);

			if (!(querySaver == null || querySaver.QuerySyncData_Id < 1) && savHistoryCount > 0) {
				// вставляем отправленные записи в ais.HistorySyncData
				if (DatabaseConnection is System.Data.SqlClient.SqlConnection)
				{
					var sqlServer = (System.Data.SqlClient.SqlConnection)DatabaseConnection;
					if (sqlServer.State == ConnectionState.Closed)
						sqlServer.Open();
					var bulkCopyier = new System.Data.SqlClient.SqlBulkCopy(sqlServer);
					if (DbObjTimeoutParam != null && DbObjTimeoutParam.HistorySyncDataBulkCopy > 0)
						bulkCopyier.BulkCopyTimeout = DbObjTimeoutParam.HistorySyncDataBulkCopy;
					bulkCopyier.DestinationTableName = String.Format("{0}{1}", String.IsNullOrEmpty(schema) ? "" : schema + ".", tableName);
					foreach (DataColumn column in datTable.Columns) {
						bulkCopyier.ColumnMappings.Add(column.ColumnName, column.ColumnName);
					}
					Exception innExc = null;
					try {
						long allRows = 0;
						bulkCopyier.NotifyAfter = datTable.Rows.Count;
						bulkCopyier.SqlRowsCopied += (s, e) => { allRows = e.RowsCopied; };
						bulkCopyier.WriteToServer(datTable);
						if (allRows > 0) {
							fileName = String.Format("{0}\\{2}{1} [{3}].xml", Dir, OnDate.ToString("HH-mm-ss"), FileNamePart, allRows);
							if (File.Exists(FileName))
								File.Move(FileName, fileName);
							FileName = fileName;
						}
					}
					catch (Exception e) {
						innExc = e;
					}
					finally { 
						sqlServer.Close();
					}
					if (innExc != null)
						throw innExc;
				}
				//else to-do другими ТФОМСами
			}
		}
	}
}
