﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AisFomsWorker
{
	using AisFomsWorker.Db;
	using Dll;
	using Newtonsoft.Json.Linq;
	using System.IO;
	using Dapper;
	using Utils = Dll.Utils;
	using System.Reflection;
	using System.Threading;
    using System.Threading.Tasks;
    using Dapper.Contrib.Extensions;
    using System.Data;
    using System.IO.Compression;

    public partial class Foms_Client
	{
		/// <summary>
		/// Получение ответа на запрос сверки загрузки данных ТФОМС из АИС
		/// </summary>
		/// <param name="InputMessage">Исходный запрос</param>
		/// <param name="CheckPrm">Параметры исходящего запроса</param>
		/// <param name="cancellationToken">Токен отмены</param>
		/// <param name="onItemsReturned">Делегат "после получение данных"</param>
		private async Task<Message> getCheckData(Message InputMessage, CheckParam CheckPrm, CancellationToken cancellationToken, Action onItemsReturned, Action<Message, CheckContent> onResult = null)
		{
			var datBeg = CheckPrm.DatBeg;
			var datEnd = CheckPrm.DatEnd;
			var timeMark = CheckPrm.TimeMark;
			var qTimeMark = CheckPrm.timeMark;
			if (DatabaseConnection != null && DatabaseConnection is System.Data.SqlClient.SqlConnection)
			{
				var startDate = new DateTime(1753, 1, 1, 12, 0, 0); // особенность скл сервера на передачу маленькой даты
				if (timeMark < startDate)
				{
					timeMark = startDate;
					qTimeMark = Utils.ToLongUnixTime(timeMark);
				}
			};

			List <HistorySyncItem> Items = null;
			if (!DbConectSuccess) this.CheckDbConnect();
			if (!DbConectSuccess) { //*/
				string fileDemo = Path.GetFullPath(AppDomain.CurrentDomain.BaseDirectory + @"\..\..\Exp1000Demo.xml");
				if (System.Diagnostics.Debugger.IsAttached && File.Exists(fileDemo))
				{ // считываем данные с xml файла
					string xmlText = File.ReadAllText(fileDemo, Encoding.GetEncoding(1251));
					var demoThousand = Utils.LoadObjFromXmlString<Xml1000Demo>(xmlText);
					long ms = (qTimeMark > 0) ? qTimeMark : 1;
					Items = (demoThousand.Items ?? new LoadDemoItem[0])
									.Select(t => {
										var tm = Utils.FromUnixTimeMs(++ms);
										return new HistorySyncItem() { GKEY = Guid.NewGuid(), TIME_MARK = tm, QTIME_MARK = ms };
									})
								.ToList();
				}
				else
					throw new Exception("Database unavailable"); // to-do: отправлять АИСу --- 60 Ошибки ФОМС сервера  ---
																 //		DECL_ERROR_CODE(foms_database_unavailable, 60, "60e36d14-fc4f-4e7e-a249-c7fca1aaca1b", u8"Database unavailable")
			}
			else
			{
				Exception innExc = null;
				try
				{
					int? commandTimeout = null;
					if (this.DbObjTimeoutParam != null && DbObjTimeoutParam.GetHistoryCheck > 0)
						commandTimeout = DbObjTimeoutParam.GetHistoryCheck;
					DatabaseConnection.Open();
					Items = (await DatabaseConnection.QueryAsync<HistorySyncItem>(
									new CommandDefinition(
										"ais.GetHistory_SyncDataCheck",
										parameters: new
										{
											DatBeg = datBeg,
											DatEnd = datEnd,
											TimeMark = timeMark,
											QTimeMark = qTimeMark
										},
										commandType: System.Data.CommandType.StoredProcedure,
										commandTimeout: commandTimeout,
										cancellationToken: cancellationToken
									))
							).ToList();
				}
				catch (Exception e)
				{
					innExc = e;
				}
				finally
				{
					if (DatabaseConnection.State != System.Data.ConnectionState.Closed)
						DatabaseConnection.Close();
				}
				if (innExc != null)
					throw innExc;
			};//*/

			onItemsReturned();
			cancellationToken.ThrowIfCancellationRequested();

			Int64 crc = 0;
			foreach (var item in Items) {
				crc ^= item.QTIME_MARK;
			};

			var answer = InputMessage.GetAnswer();
			CheckPrm.crc = crc; 

			CheckContent obj = (CheckContent)CheckPrm;
			answer.content = JObject.FromObject(obj);
			answer.maxTimeLife = null;

			if (onResult != null)
				onResult(answer, obj);

			return answer;
		}

		/// <summary>
		/// Обрабатывает входящий запрос от АИС на сверку загрузки данных из ТФОМС
		/// </summary>
		/// <param name="LoggerFile">Объект xml логера</param>
		/// <param name="InputMessage">Исходный запрос</param>
		/// <param name="FileName">файл xml логера</param>
		/// <param name="OnDate">Дата команды</param>
		/// <param name="Dir">Директория логера</param>
		/// <param name="FileNamePart">Частичка имени файла логера</param>
		/// <param name="MaxTimeLife">Время ожидание АИС (сек)</param>
		/// <param name="sw">Объект подсчета времени</param>
		/// <param name="WaitContinue">Предел секунд, чтобы кинуть KeepWaitCommand и успеть</param>
		private void CheckData(XmlLoggerFile LoggerFile, Message InputMessage,
			ref string FileName, DateTime OnDate, string Dir, ref string FileNamePart,
			int MaxTimeLife, System.Diagnostics.Stopwatch sw, int WaitContinue
		) {
			int ms = 1000 * MaxTimeLife;
			var answers = new List<Message>();
			CheckContent content = InputMessage.content.ToObject<CheckContent>();
			DateTime startDate = new DateTime(1970, 1, 1);
			var contParam = new CheckParam()
			{
				period = content.period,
				DatBeg = content.period.begin.HasValue ? Utils.FromUnixTimeMs(content.period.begin.Value) : startDate,
				DatEnd = content.period.end.HasValue ? Utils.FromUnixTimeMs(content.period.end.Value) : startDate,
				timeMark = content.timeMark,
				TimeMark = Utils.FromUnixTimeMs(content.timeMark)
			};
			//if (File.Exists(FileName)) {
			FileNamePart = String.Format("CheckData ({0} - {1}; {2}) ", contParam.DatBeg.ToString("dd.MM.yyyy"), contParam.DatEnd.ToString("dd.MM.yyyy"), contParam.TimeMark.ToString("dd.MM.yyyy HH+mm+ss,fff"));
			string fileName = String.Format("{0}\\{2}{1}.xml", Dir, OnDate.ToString("HH-mm-ss"), FileNamePart);
			File.Move(FileName, fileName);
			FileName = fileName;
			string fileNamePart = FileNamePart;
			//}
			LoggerFile.Descr = String.Format("{0} - Проверка синхронизация данных начата", DateTime.Now.ToString());
			LoggerFile.Query.content = JObject.FromObject(contParam);
			SaveLoggerXml(LoggerFile, FileName);
			if (contParam.DatBeg == startDate || contParam.DatEnd == startDate || (content.period.begin ?? 0) > (content.period.end ?? 0))
				throw new Exception("Неправильные даты period");

			Message answer = null; Int64? crc = -1;
			var taskMsg = this.getCheckData(InputMessage, contParam, ProcessTokenSource.Token,
					onItemsReturned: () => {
						ProcessTokenSource.Token.ThrowIfCancellationRequested();
						//Thread.Sleep(150);
						if (!AliveClient()) { // ловим обрыв после завершения скл запроса
							ProcessTokenSource.Cancel(throwOnFirstException: true);
							LoggerFile.Descr += String.Format("; {0} Сервер АИС разорвал соединение", DateTime.Now.ToString());
							SaveLoggerXml(LoggerFile, fileName);
						}
					},
					onResult: (msg, cont) => {
						crc = cont.crc;
					}
				);

			//int minMsCheck = (maxTimeLife / 5) * 1000;
			const int addSecLife = 15;
			//if (minMsCheck < 1000) minMsCheck = 1000;

			int lastWait = sw.Elapsed.Seconds, secWait = 0, waitCount = 0; // посылаем wait в 1й раз ВСЕГДА
			if (true || (MaxTimeLife - lastWait) < WaitContinue)
			{
				secWait = WaitContinue - (MaxTimeLife - lastWait);
				var keepWait = BuildWaitCommand(InputMessage, MaxTimeLife + addSecLife);
				SendData(binWriter, keepWait, false);
				sw.Restart();
				keepWait.Num = ++waitCount;
				keepWait.Descr = String.Format("First waiter = {0}", DateTime.Now.ToString());
				answers.Add(keepWait);
				LoggerFile.Answer = answers.ToArray();
				SaveLoggerXml(LoggerFile, FileName);
			}

			bool tcpServerDisconnected = false;
			while (!taskMsg.IsCompleted)
			{
				taskMsg.Wait(ms);

				//Thread.Sleep(minMsCheck);
				if (taskMsg.IsCompleted) break;
				if (taskMsg.IsFaulted) throw taskMsg.Exception;

				if (!tcpServerDisconnected && !AliveClient())
				{
					ProcessTokenSource.Cancel(throwOnFirstException: true);
					LoggerFile.Descr += String.Format("; {0} Сервер АИС разорвал соединение", DateTime.Now.ToString());
					SaveLoggerXml(LoggerFile, FileName);
					Thread.Sleep(2500); //throw new Exception("Соединение разорвано");
					tcpServerDisconnected = true;
					//break;
				}

				if (!tcpServerDisconnected)
				{
					var keepWait = BuildWaitCommand(InputMessage, MaxTimeLife + addSecLife);
					SendData(binWriter, keepWait, false);
					sw.Restart();
					keepWait.Num = ++waitCount;
					keepWait.Descr = String.Format("Waiter = {0}", DateTime.Now.ToString());
					answers.Add(keepWait);
					LoggerFile.Answer = answers.ToArray();
					SaveLoggerXml(LoggerFile, FileName);
				}
			}

			lastWait = sw.Elapsed.Seconds; // посылаем wait в последний раз
			if (!tcpServerDisconnected && (MaxTimeLife - lastWait) < WaitContinue)
			{
				secWait = WaitContinue - (MaxTimeLife - lastWait);
				var keepWait = BuildWaitCommand(InputMessage, secWait);
				SendData(binWriter, keepWait, false);
				sw.Restart();
				keepWait.Num = ++waitCount;
				keepWait.Descr = String.Format("Last waiter = {0}", DateTime.Now.ToString());
				answers.Add(keepWait);
				LoggerFile.Answer = answers.ToArray();
				SaveLoggerXml(LoggerFile, FileName);
			}

			answer = taskMsg.Result;
			SendData(binWriter, answer, false); //sw.ElapsedMilliseconds
			answer.Descr += String.Format("; {0} - пакет отправлен (запас ожидания {1} мс от начального MaxTimeLife={2})", DateTime.Now.ToString(), ms - sw.Elapsed.Milliseconds, ms);
			sw.Stop();

			if (crc.HasValue) {
				fileName = String.Format("{0}\\{2}{1} [{3}].xml", Dir, OnDate.ToString("HH-mm-ss"), FileNamePart, crc.Value);
				if (File.Exists(FileName))
					File.Move(FileName, fileName);
				FileName = fileName;
			}

			answers.Add(answer);
			LoggerFile.Answer = answers.ToArray();
			SaveLoggerXml(LoggerFile, FileName);
		}
	}
}
