﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AisFomsWorker
{
	using System.ServiceProcess;
	using System.IO;
    using System.Threading;
	using System.Configuration;
    using System.Net.Sockets;
    using System.Net;
    //using Newtonsoft.Json;

    public class FomsWorkerService : ServiceBase
	{
		protected override void Dispose(bool disposing) {
			//if (disposing && (components != null)) {
			//	components.Dispose();
			//}
			base.Dispose(disposing);
		}

		public FomsWorkerService() {
			this.ServiceName = "AisFomsService";
			this.AutoLog = true;
			//InitializeComponent();
			this.CanShutdown = false;
			this.CanStop = true;
			this.CanPauseAndContinue = false;

			SeriveIsStopped = false;
		}

		/// <summary>
		/// Последние записанные байты в лог
		/// </summary>
		private int _lastWriteln { get; set; }

		/// <summary>
		/// Логгер службы
		/// </summary>
		public FileStream Logger { get; protected set; }

		/// <summary>
		/// Пишем строчку в файл лога
		/// </summary>
		/// <param name="message">Строки</param>
		/// <param name="clearning">Будет ли в будущем это строчка затерта?</param>
		public void LoggingLine(string message, bool clearning = false) {
			if (String.IsNullOrEmpty(message) || Logger == null) return;
			byte[] data = Encoding.UTF8.GetBytes(message + Environment.NewLine);
			int byt = data.Length;
			if (_lastWriteln > 0) Logger.Seek(-1 * _lastWriteln, SeekOrigin.End);
			Logger.Write(data, 0, byt);
			Logger.Flush(true);
			_lastWriteln = (clearning) ? byt : 0;
		}

		/// <summary>
		/// Освобождение ресурсов
		/// </summary>
		public void Freee()
		{
			try
			{
				GC.Collect();
				GC.WaitForPendingFinalizers();
			}
			catch (Exception exc)
			{
				string s = exc.Message;
			}
			finally
			{
				//
			}
		}

		/// <summary>
		/// Папка для логов
		/// </summary>
		public string LoggerDir { get; private set; }

		public Foms_Server Server { get; private set; }

		protected override void OnStart(string[] args)
		{
			string logDirParam = ConfigurationManager.AppSettings.Get("LogDir") ?? "";
			if (String.IsNullOrEmpty(logDirParam)) {
				logDirParam = AppDomain.CurrentDomain.BaseDirectory + @"\LOGS\";
			}
			if (!Directory.Exists(logDirParam))
				Directory.CreateDirectory(logDirParam);
			this.LoggerDir = logDirParam;

			string strParam = ConfigurationManager.AppSettings.Get("port") ?? "";
			int Port = Int32.Parse(strParam);

			string password = ConfigurationManager.AppSettings.Get("password") ?? "";

			string fileStartName = String.Format(@"{0}\{1}.txt", LoggerDir, DateTime.Now.ToString("dd.MM.yyyy")); // "dd.MM.yyyy HH-mm-ss"
			//if (System.Diagnostics.Debugger.IsAttached && File.Exists(fileStartName)) File.Delete(fileStartName);

			bool ex = File.Exists(fileStartName);
			this.Logger = File.Open(fileStartName, FileMode.OpenOrCreate, FileAccess.Write, FileShare.Read);
			Logger.Seek(0, SeekOrigin.End);
			if (ex) 
				LoggingLine(Environment.NewLine + Environment.NewLine);

			LoggingLine(String.Format("#{0} СТАРТ СЛУЖБЫ", DateTime.Now.ToString()));
			//LoggingLine(String.Format("\tPort = {0}", Port));
			strParam = ConfigurationManager.AppSettings.Get("GetRegistry_Sec") ?? "";
			int getRegistrySec;
			if (String.IsNullOrEmpty(strParam) || !Int32.TryParse(strParam, out getRegistrySec)) 
				getRegistrySec = 0;
			else 
				LoggingLine(String.Format("\t GetRegistryTimeOutSec = {0}", getRegistrySec));

			int historySyncDataBulkCopySec;
			strParam = ConfigurationManager.AppSettings.Get("HistorySyncDataBulkCopy_Sec") ?? "";
			if (String.IsNullOrEmpty(strParam) || !Int32.TryParse(strParam, out historySyncDataBulkCopySec))
				historySyncDataBulkCopySec = 0;
			else 
				LoggingLine(String.Format("\t HistorySyncDataBulkCopySec = {0}", historySyncDataBulkCopySec));

			int getHistoryCheckSec;
			strParam = ConfigurationManager.AppSettings.Get("GetHistoryCheck_Sec") ?? "";
			if (String.IsNullOrEmpty(strParam) || !Int32.TryParse(strParam, out getHistoryCheckSec))
				getHistoryCheckSec = 0;
			else
				LoggingLine(String.Format("\t GetHistoryCheckTimeOutSec = {0}", getHistoryCheckSec));
			//LoggingLine(String.Format("\tPassword = '{0}'", password));
			Logger.Close();

			SeriveIsStopped = false;
			Logger = File.Open(fileStartName, FileMode.Append, FileAccess.Write, FileShare.Read);

			Exception innExc = null;
			try {
				this.Server = new Foms_Server(Port, password, LoggerDir, getRegistrySec, historySyncDataBulkCopySec, getHistoryCheckSec) { LoggingLine = new Dll.Utils.WriterDelegate(LoggingLine) };
			}
			catch (Exception exc) {
				this.Server = null;
				innExc = exc;
			}
			
			if (innExc != null) {
				WriteError(innExc, Msg: String.Format(Environment.NewLine + "Ошибка создания сокета ({0})", Port).ToUpper());
				throw innExc;
			}

			if (!Environment.UserInteractive) //System.Diagnostics.Debugger.IsAttached
				Thread.Sleep(10 * 1000); // ждем 10 сек чтобы успеть подключится отладчиком

			Thread thread = new Thread(new ThreadStart(Server.Start));
			thread.Start();
		}

		/// <summary>
		/// Пишем ошибку в лог
		/// </summary>
		/// <param name="exc">Ошибка</param>
		/// <param name="WithInner">Вместе с внутренней информацией</param>
		protected void WriteError(Exception exc, bool WithInner = true, string Msg = "ERROR")
		{
			if (exc == null || Logger == null) return;
			LoggingLine(String.Format("#{0} {2}: {1}", DateTime.Now.ToString("HH:mm:ss"), exc.Message ?? "", Msg));
			if (exc.InnerException != null && WithInner) {
				LoggingLine(String.Format("#\tInner Exc: {0}", exc.InnerException.Message ?? ""));
			}
		}	

		/// <summary>
		/// Режим "СТОП" служба
		/// </summary>
		public bool SeriveIsStopped { get; set; }

		//public Thread MainThread { get; private set; }

		protected override void OnStop()
		{
			string fileName = String.Format(@"{0}\{1}~{2}.txt", LoggerDir, DateTime.Now.ToString("dd.MM.yyyy"), DateTime.Now.ToString("HH-mm-ss"));
			FileStream logger = File.Open(fileName, FileMode.CreateNew, FileAccess.Write, FileShare.Read);

			int _lastWrite = 0;
			Action<string, bool> loggingLine = (message, clearning) => {
				if (String.IsNullOrEmpty(message) || logger == null) return;
				byte[] data = Encoding.UTF8.GetBytes(message + Environment.NewLine);
				int byt = data.Length;
				if (_lastWrite > 0) logger.Seek(-1 * _lastWrite, SeekOrigin.End);
				logger.Write(data, 0, byt);
				logger.Flush(true);
				_lastWrite = (clearning) ? byt : 0;
			};


			loggingLine(String.Format("#{0} STOP WORKER", DateTime.Now), false);
			Server.LoggingLine = new Dll.Utils.WriterDelegate(loggingLine);
			SeriveIsStopped = true;

			Server.Stop();

			Thread.Sleep(7 * 1000); /// даём время чтобы всё завершилось

			if (Logger != null) {
				try {
					Logger.Close();
					Logger.Dispose();
				}
				finally {
					Logger.Dispose();
					Logger = null;
				}
			};

			if (logger != null) {
				try {
					loggingLine(String.Format("#{0} Service stopped.", DateTime.Now), false);
					logger.Close();
				}
				finally {
					logger.Dispose();
					logger = null;
				}
			};
		}

		/// <summary>
		/// https://alastaircrabtree.com/how-to-run-a-dotnet-windows-service-as-a-console-app/
		/// </summary>
		public void RunAsConsole(string[] args) {
			Console.WriteLine("\n{0} OnStart running..", DateTime.Now.ToString());
			OnStart(args);
			Console.WriteLine("\n{0} Press [Escape] to exit...", DateTime.Now.ToString());
			var key = ConsoleKey.Enter;
			while (key != ConsoleKey.Escape) {
				//if (key != ConsoleKey.Enter) Console.WriteLine(key.ToString());
				key = Console.ReadKey().Key;
			};
			Console.WriteLine("\n{0} Stopped service..", DateTime.Now.ToString());
			OnStop();//*/

			// проверка клиента на другой машине (аналогично АИС-Эмулятору)
			/*TcpClient client = null;
			try { 
				client = new TcpClient("192.168.135.184", port: 62065);
				NetworkStream stream = client.GetStream();

				/// здороваемся
				Guid hello = Dll.Utils.ChangeByteOrder(new Guid("fea6b958-dafb-4f5c-b620-fe0aafbd47e2"));
				byte[] data = hello.ToByteArray();
				stream.Write(data, 0, data.Length);
				do {
					int bytes = stream.Read(data, 0, data.Length);
					hello = Dll.Utils.ChangeByteOrder(new Guid(data));
				}
				while (stream.DataAvailable);
				//Console.WriteLine("Client say hello <fea6b958 - dafb - 4f5c - b620 - fe0aafbd47e2> = '{0}'", hello.ToString()); // "fea6b958-dafb-4f5c-b620-fe0aafbd47e2"
				if (hello != new Guid("fea6b958-dafb-4f5c-b620-fe0aafbd47e2"))
					throw new Exception(String.Format("Unknow guid {0}", hello));

				var binReader = new BinaryReader(stream, Encoding.UTF8);
				var binWriter = new BinaryWriter(stream, Encoding.UTF8);

				Action<Dll.Message> SendData = (message) => {
					string jsnData = Newtonsoft.Json.JsonConvert.SerializeObject(message, Newtonsoft.Json.Formatting.None,
							new Newtonsoft.Json.JsonSerializerSettings() { NullValueHandling = Newtonsoft.Json.NullValueHandling.Ignore }
						);
					byte[] bb = Encoding.UTF8.GetBytes(jsnData);
					lock (stream) {
						binWriter.Write(Dll.Utils.SwapEndianness(bb.Length));
						binWriter.Write(bb);
						binWriter.Flush();
					}
				};

				Func<Dll.Message> ReadNextPacket = () => {
					string str = null; bool forceWait = true;
					if (stream.DataAvailable || forceWait) {
						lock (stream) { //netStream
							byte[] aa = binReader.ReadBytes(4);
							int size = BitConverter.ToInt32(aa.Reverse().ToArray(), 0);
							str = Encoding.UTF8.GetString(binReader.ReadBytes(size));
						}
						return Newtonsoft.Json.Linq.JObject.Parse(str).ToObject<Dll.Message>();
					}
					else return null;
				};

				/// пакет совместимости
				Dll.Message msg = new Dll.Message() { MsgCommand = Dll.Command.ProtocolCompatible };
				SendData(msg);
				msg = ReadNextPacket();
				if (msg.MsgCommand != Dll.Command.ProtocolCompatible)
					throw new Exception("Client send not Command.ProtocolCompatible");

				/// пароль
				msg.MsgExecStatus = Dll.MsgExecStatus.Unknown;
				msg.MsgCommand = Dll.Command.FomsAuthorization;
				msg.content = Newtonsoft.Json.Linq.JObject.FromObject(new Dll.AuthContent() { Password = "bf5343bbe49241e9ba54cacf61547e93" });
				SendData(msg);
				msg = ReadNextPacket();
				bool isDone = false;
				if (msg.MsgType == Dll.MsgType.Answer) {
					isDone = (msg.MsgExecStatus == Dll.MsgExecStatus.Success) && (msg.MsgCommand == Dll.Command.FomsAuthorization);
				};
				if (!isDone)
					throw new Exception("Client not FomsAuthorization");

				msg.MsgExecStatus = Dll.MsgExecStatus.Unknown;
			}
			catch (Exception e) {
				string s = e.Message;
				if (e.InnerException != null)
					s += String.Format("\r\n	Inner: {0}", e.InnerException.Message);
				Console.WriteLine(s);
			}
			finally {
				if (client != null && client.Connected)
					client.Close();
			}
			Console.WriteLine("\r\nAny key to end..");
			Console.ReadKey(); //*/
		}
	}
}
