﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AisFomsWorker
{
    //using AisFomsWorker.Db;
    using Dll;
    //using Newtonsoft.Json;
    //using Newtonsoft.Json.Linq;
    using System.IO;
    using System.Net.Sockets;
	using System.Threading;
	using System.Globalization;
    using Utils = Dll.Utils;
	//using System.Reflection;
    using System.Data;
	//using Dapper;
	//using Dapper.Contrib.Extensions;

    public partial class Foms_Client
	{
		public DbTimeoutParam DbObjTimeoutParam { get; private set; }

		public bool DbConectSuccess { get; private set; }
		void CheckDbConnect() {
			DbConectSuccess = true;
			try {
				if (DatabaseConnection.State == ConnectionState.Closed) {
					DatabaseConnection.Open();
					DatabaseConnection.Close();
				}
			}
			catch (Exception e)
			{
				WriteError(e, Msg: "Ошибка подключения к БД");
				DbConectSuccess = false;
			}
			finally
			{
				if (DatabaseConnection.State == ConnectionState.Open)
					DatabaseConnection.Close();
			}
		}

		public Foms_Client(TcpClient client, string passwod, string loggerDir, IDbConnection sqlConnect, Utils.WriterDelegate loggingLine, DbTimeoutParam ObjTimeoutParam)
		{
			LoggingLine = loggingLine;
			Password = passwod;
			LoggerDir = loggerDir;
			tcpClient = client;
			DbObjTimeoutParam = ObjTimeoutParam;
			DatabaseConnection = sqlConnect;
			//(new Thread(new ThreadStart(StartLogging)) { IsBackground = true }).Start();
			CheckDbConnect();
		}

		public void StartConn()
		{
			try
			{
				netStream = tcpClient.GetStream();
				binReader = new BinaryReader(netStream, Encoding.UTF8);
				binWriter = new BinaryWriter(netStream, Encoding.UTF8);

				// Say "hello".
				byte[] hello = binReader.ReadBytes(16);
				Guid h = Utils.ChangeByteOrder(new Guid(hello));

				if (h != new Guid(Command.Hello.GetID())) return; // сервер не сказал привет

				DateTime connectTime = DateTime.Now;

				string dir = String.Format("{0}\\{1}", LoggerDir, connectTime.ToString("yyyy-MM-dd"));
				if (!Directory.Exists(dir))
					Directory.CreateDirectory(dir);
				string fileName = String.Format("{0}\\{1}.xml", dir, connectTime.ToString("HH-mm-ss"));
				var loggerFile = new XmlLoggerFile() { ConnectionDate = connectTime.ToString("dd.MM.yyyy HH:mm:ss") };

				//Отвечаем тем же самым пакетом приветствия
				binWriter.Write(hello);
				binWriter.Flush();

				Message msg = ReadNextPacket(binReader, true);
				loggerFile.CompatibleQuery = msg;
				SaveLoggerXml(loggerFile, fileName);

				if (msg.MsgCommand == Command.ProtocolCompatible)
				{
					SendData(binWriter, msg);
					loggerFile.CompatibleQuery = null;
					loggerFile.CompatibleAnswer = msg;
					SaveLoggerXml(loggerFile, fileName);
				}
				else
				{
					loggerFile.Error = String.Format("{0} MsgCommand <> Command.ProtocolCompatible", DateTime.Now);
					SaveLoggerXml(loggerFile, fileName);
					if (File.Exists(fileName))
						File.Move(fileName, String.Format("{0}\\{1}.xml", dir, connectTime.ToString("HH-mm-ss").Replace("-", "~")));
					return;
				}

				msg = ReadNextPacket(binReader, true);
				loggerFile.AuthorizationQuery = msg;
				SaveLoggerXml(loggerFile, fileName);
				if (msg.MsgCommand == Command.FomsAuthorization)
				{
					var auth = msg.content.ToObject<AuthContent>();
					if (String.Compare(Password, auth.Password, false) != 0)
					{
						loggerFile.Error = String.Format("{0} Authorization failed.", DateTime.Now);
						SaveLoggerXml(loggerFile, fileName);
						if (File.Exists(fileName))
							File.Move(fileName, String.Format("{0}\\{1}.xml", dir, connectTime.ToString("HH-mm-ss").Replace("-", "~")));
						return;
					};
					var answer = msg.GetAnswer();
					loggerFile.AuthorizationQuery = null;
					loggerFile.AuthorizationAnswer = answer;
					SendData(binWriter, answer);
					//loggerFile.AuthorizationAnswer.content = null;
					SaveLoggerXml(loggerFile, fileName);
				}
				else
				{
					loggerFile.Error = String.Format("{0} MsgCommand <> Command.FomsAuthorization", DateTime.Now);
					SaveLoggerXml(loggerFile, fileName);
					if (File.Exists(fileName))
						File.Move(fileName, String.Format("{0}\\{1}.xml", dir, connectTime.ToString("HH-mm-ss").Replace("-", "~")));
					return;
				}

				//Запрашиваем ручную синхронизацию
				//CreateSyncPlanningContent tst = new CreateSyncPlanningContent() { timeMark = DateTime.Now.AddYears(-10).UnixTime(), period = new Period(new DateTime(2019, 2, 1), new DateTime(2019, 1, 1)) };
				//msg = new Message() { MsgCommand = Command.CreateSyncPlanningDebug, content = JObject.FromObject(tst) };
				//SendData(bw, msg);
				//Receiver();

				Receiver(loggerFile, fileName, connectTime, dir);
			}
			catch (Exception e)
			{
				this.WriteError(e);
			}
		}

		public CancellationTokenSource ProcessTokenSource { get; private set; }

		private void Receiver(XmlLoggerFile LoggerFile, string FileName, DateTime ConnectTime, string Dir)
		{
			Message msg = null; 
			bool con_Stop = false;
			int queryCount = 0;
			while (con_Stop == false)
			{
				while (tcpClient.Client != null && tcpClient.Client.Connected)
				{
					msg = ReadNextPacket(binReader, false);
					if (msg != null) break;
					Thread.Sleep(250);
					if (!AliveClient())
					{
						con_Stop = true;
						break;
					}
				};
				string FileNamePart = (queryCount == 0) ? "" : String.Format(" ({0})", queryCount);
				if (msg == null) { // подключение от АИС было, а сообщения "Что мол надо от нас" нет или разрыв соединения
					if (File.Exists(FileName) && queryCount == 0)  {
						if (con_Stop || tcpClient.Client == null || !tcpClient.Client.Connected) {
							File.Delete(FileName); // удаляем лог пустышку
						}
						else
							File.Move(FileName, String.Format("{0}\\{1}{2}.xml", Dir, ConnectTime.ToString("HH-mm-ss").Replace("-", "_"), FileNamePart));
					}
					break;
				}

				int MaxTimeLife = msg.maxTimeLife ?? 60, delta = 3;
				int maxTimeLife = MaxTimeLife - delta;
				if (maxTimeLife <= 0) maxTimeLife = 1;
				//int ms = 1000 * maxTimeLife;

				System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
				sw.Start();
				const int waitContinue = 5;

				LoggerFile.Query = null;
				LoggerFile.Descr = String.Empty;
				LoggerFile.Answer = null;
				LoggerFile.Error = String.Empty;
				if (!String.IsNullOrWhiteSpace(FileNamePart)) {
					FileName = String.Format("{0}\\{1}{2}.xml", Dir, DateTime.Now.ToString("HH-mm-ss"), FileNamePart);
				}

				var onDate = ConnectTime; // на каждый запрос свой лог файл
				if (queryCount > 0) {
					onDate = DateTime.Now;
					FileName = String.Format("{0}\\{1}.xml", Dir, onDate.ToString("HH-mm-ss"));
					FileNamePart = String.Empty;
					LoggerFile.CompatibleAnswer = null;
					LoggerFile.AuthorizationAnswer = null;
				};


				msg.Descr = String.Format("OnDate = {0}, maxTimeLife = {1} [Delta = {2} сек]", onDate.ToString(), maxTimeLife, delta);
				LoggerFile.Query = msg;
				SaveLoggerXml(LoggerFile, FileName);
				ProcessTokenSource = new CancellationTokenSource();

				try {
					if (msg.MsgCommand == Command.GetSyncData2) {
						this.SyncData2(LoggerFile, msg, ref FileName, onDate, Dir, ref FileNamePart, maxTimeLife, sw, waitContinue);
					}
					else if (msg.MsgCommand == Command.SyncDataCheck) {
						this.CheckData(LoggerFile, msg, ref FileName, onDate, Dir, ref FileNamePart, maxTimeLife, sw, waitContinue);
					}
					else
						throw new NotImplementedException("Ответ не реализован");
				}
				catch (Exception e)
				{
					string str = String.Format("{0} {1}{2}", DateTime.Now, e.Message, (e.InnerException==null) ? "" : String.Concat(" (", e.InnerException.Message ?? "", ")"));
					if (e.InnerException != null && e.InnerException.InnerException != null) {
						str = String.Concat(str, " [", e.InnerException.InnerException.Message ?? "", "]");
					};
					LoggerFile.Error = str;
					SaveLoggerXml(LoggerFile, FileName);
					if (File.Exists(FileName))
						File.Move(FileName, String.Format("{0}\\{2}{1}.xml", Dir, onDate.ToString("HH-mm-ss").Replace("-", "~"), FileNamePart));
				}
				finally {
					if (ProcessTokenSource != null)
						ProcessTokenSource.Dispose();
					ProcessTokenSource = null;
					queryCount++;
					if (sw != null) {
						if (sw.IsRunning) 
							sw.Stop();
						sw = null;
					}
				}
			}
		}
	}
}
