﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AisFomsWorker
{
    using AisFomsWorker.Db;
    using Dll;
    using Newtonsoft.Json;
    using Newtonsoft.Json.Linq;
    using System.IO;
    using System.Net.Sockets;
	using System.Threading;
	using System.Globalization;
    using Utils = Dll.Utils;
    using System.Data;
	using System.Data.SqlClient;
	using Dapper;
	//using Dapper.Contrib;
    using Dapper.Contrib.Extensions;

    public partial class Foms_Client
	{
		#region Для логирования
		public Utils.WriterDelegate LoggingLine { get; private set; }

		private void Writeln(string message, bool clearning = false) { if (LoggingLine != null) LoggingLine(message, clearning); }

		/// <summary>
		/// Пишем ошибку в лог
		/// </summary>
		/// <param name="exc">Ошибка</param>
		/// <param name="WithInner">Вместе с внутренней информацией</param>
		protected void WriteError(Exception exc, bool WithInner = true, string Msg = "ERROR")
		{
			if (exc == null || LoggingLine == null) return;
			string s = exc.Message ?? "";
			if (!(exc.InnerException != null && WithInner) && !s.EndsWith(Environment.NewLine)) s += Environment.NewLine;
			LoggingLine(String.Format("#{0} {2}: {1}", DateTime.Now.ToString("HH:mm:ss"), s, Msg));
			if (exc.InnerException != null && WithInner) {
				s = exc.InnerException.Message ?? "";
				if (!s.EndsWith(Environment.NewLine)) s += Environment.NewLine;
				LoggingLine(String.Format("#\tInner Exc: {0}", s));
			}
		}

		/// <summary>
		/// Папка для логов
		/// </summary>
		public string LoggerDir { get; private set; }
		#endregion

		protected IDbConnection DatabaseConnection { get; private set; }

		protected TcpClient tcpClient { get; private set; }

		protected string Password { get; private set; }

		protected NetworkStream netStream { get; private set; }
		protected BinaryReader binReader { get; private set; }
		protected BinaryWriter binWriter { get; private set; }

		//static object lock_obj = new object();

		/// <summary>
		/// Close connection
		/// </summary>
		public void CloseConn()
		{
			try {
				binReader.Close();
				binWriter.Close();
				netStream.Close();
				tcpClient.Close();
			}
			catch (Exception e) {
				string s = e.Message;
			}
			if (DatabaseConnection != null) {
				if (DatabaseConnection.State != ConnectionState.Closed)
					DatabaseConnection.Close();
				DatabaseConnection.Dispose();
			}
		}

		void SaveObjInJson<T>(T prm, string FileName)
		{
			try
			{
				if (File.Exists(FileName)) File.Delete(FileName);
				JsonSerializer serializer = new JsonSerializer();
				//serializer.Converters.Add(new JavaScriptDateTimeConverter());
				serializer.NullValueHandling = NullValueHandling.Ignore;
				using (StreamWriter sw = new StreamWriter(FileName))
				using (JsonWriter writer = new JsonTextWriter(sw))
				{
					serializer.Serialize(writer, prm);
				}
			}
			catch (Exception ex)
			{
				//Log exception here
			}
		}

		void SaveLoggerXml(XmlLoggerFile Obj, string FileName) { 
			try
			{
				string dir = Path.GetDirectoryName(FileName);
				if (!Directory.Exists(dir))
					Directory.CreateDirectory(dir);
			}
			finally
			{
				Utils.SaveObjInXml<XmlLoggerFile>(Obj, () => FileName);
			};
		}

		/// <summary>
		/// Живой ли TcpClient
		/// </summary>
		protected bool AliveClient() {
			if (tcpClient.Client == null || !tcpClient.Client.Connected) return false;
			// Detect if client disconnected
			if (tcpClient.Client.Poll(0, SelectMode.SelectRead)) {
				byte[] buff = new byte[1];
				if (tcpClient.Client.Receive(buff, SocketFlags.Peek) == 0) {
					return false; // Client disconnected
				}
				else
					return true;
			}
			return true;
		}

		private Message BuildWaitCommand(Message msg, int seconds) {
			//Console.WriteLine("keepWaitCommand");
			Message keepWaitCommand = new Message();
			keepWaitCommand.command = Command.KeepWaitCommand.GetID();
			keepWaitCommand.MsgPriority = MsgPriority.High;
			keepWaitCommand.tags = msg.tags;
			keepWaitCommand.content = JObject.FromObject(new { messageId = msg.id, commandId = msg.command, timeToAdd = seconds });
			return keepWaitCommand; //SendData(bw, keepWaitCommand, false);
		}

		private void SendData(BinaryWriter writer, Message message, bool ignoreNulls = true/*, long? ElapsedMilliseconds = null*/)
		{
			string jsnData = JsonConvert.SerializeObject(message, Formatting.None,
					new JsonSerializerSettings()
					{
						NullValueHandling = ignoreNulls ? NullValueHandling.Ignore : NullValueHandling.Include
					}
				);

			byte[] bb = Encoding.UTF8.GetBytes(jsnData);
			lock (netStream) { //netStream
				// проверяем живой ли connection
				if (tcpClient.Client.Connected) {
					writer.Write(Dll.Utils.SwapEndianness(bb.Length));
					writer.Write(bb);
					writer.Flush();
				}
			}
		}

		private Message ReadNextPacket(BinaryReader reader, bool forceWait = false)
		{
			string data = null;
			if (netStream.DataAvailable || forceWait) {
				lock (netStream) { //netStream
					byte[] aa = reader.ReadBytes(4);
					int size = BitConverter.ToInt32(aa.Reverse().ToArray(), 0);
					data = Encoding.UTF8.GetString(reader.ReadBytes(size));
				}
				return JObject.Parse(data).ToObject<Message>();
			}
			else return null;
		}
	}
}