﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AisFomsWorker
{
	using System.Net.Sockets;
	using System.Net;
	using System.Threading;
	using Utils = Dll.Utils;
	using System.Data;
	using System.Configuration;

	public class Foms_Server
	{
		public int Port { get; private set; }

		public string Password { get; private set; }

		#region Для логирования
		public Utils.WriterDelegate LoggingLine { get; set; }

		private void Writeln(string message, bool clearning = false) { if (LoggingLine != null) LoggingLine(message, clearning); }

		/// <summary>
		/// Пишем ошибку в лог
		/// </summary>
		/// <param name="exc">Ошибка</param>
		/// <param name="WithInner">Вместе с внутренней информацией</param>
		protected void WriteError(Exception exc, bool WithInner = true, string Msg = "ERROR")
		{
			if (exc == null || LoggingLine == null) return;
			string s = exc.Message ?? "";
			if (!(exc.InnerException != null && WithInner) && !s.EndsWith(Environment.NewLine)) s += Environment.NewLine;
			LoggingLine(String.Format("#{0} {2}: {1}", DateTime.Now.ToString("HH:mm:ss"), s, Msg));
			if (exc.InnerException != null && WithInner) {
				s = exc.InnerException.Message ?? "";
				if (!s.EndsWith(Environment.NewLine)) s += Environment.NewLine;
				LoggingLine(String.Format("#\tInner Exc: {0}", s));
			}
		}

		/// <summary>
		/// Папка для логов
		/// </summary>
		public string LoggerDir { get; private set; }
		#endregion

		public DbTimeoutParam DbObjTimeoutParam { get; private set; }

		public Foms_Server(int port, string password, string loggerDir, int getRegistrySec, int historySyncDataBulkCopySec, int getHistoryCheckSec) {
			Port = port;
			Password = password;
			LoggerDir = loggerDir;
			DbObjTimeoutParam = new DbTimeoutParam();
			if (getRegistrySec > 0) DbObjTimeoutParam.GetRegistryLoad = getRegistrySec;
			if (historySyncDataBulkCopySec > 0) DbObjTimeoutParam.HistorySyncDataBulkCopy = historySyncDataBulkCopySec;
			if (getHistoryCheckSec > 0) DbObjTimeoutParam.GetHistoryCheck = getHistoryCheckSec;

			Listener = new TcpListener(IPAddress.Any, Port);
			Listener.Start();
		}

		public TcpListener Listener { get; private set; }

		/// <summary>
		/// IP адрес в локальной сети
		/// </summary>
		private IPAddress GetLocalIPAddress()
		{
			if (!System.Net.NetworkInformation.NetworkInterface.GetIsNetworkAvailable())
			{
				return null;
			}
			IPHostEntry host = Dns.GetHostEntry(Dns.GetHostName());
			return host
				.AddressList
				.FirstOrDefault(ip => ip.AddressFamily == AddressFamily.InterNetwork);
		}

		public void Start()
		{
			if (LoggingLine != null) {
				IPAddress myIp = null;
				try {
					myIp = GetLocalIPAddress();
				}
				catch {
					myIp = null;
				}
				Writeln(String.Format(Environment.NewLine + "{0} Старт прослушки {2}:{1}" + Environment.NewLine, DateTime.Now, Port, (myIp == null) ? "localhost" : myIp.ToString()));
			}

			//var tcpClient = Listener.AcceptTcpClient();
			//ThreadPool.QueueUserWorkItem(new WaitCallback((Object StateInfo) => {
			//	Foms_Client foms = null;
			//	try {
			//		foms = new Foms_Client((TcpClient)StateInfo, Password ?? "", LoggerDir ?? "");
			//		foms.StartConn();
			//	}
			//	finally {
			//		if (foms != null) {
			//			Thread.Sleep(100);
			//			foms.CloseConn();
			//		};
			//	};
			//}), tcpClient);

			_ct = _cts.Token;
			Listener.BeginAcceptTcpClient(ProcessRequest, Listener);
		}

		private CancellationToken _ct; // см. http://qaru.site/questions/281235/stopping-a-tcplistener-after-calling-beginaccepttcpclient
		private CancellationTokenSource _cts = new CancellationTokenSource();

		// Process single request.
		void ProcessRequest(IAsyncResult ar)
		{
			//Stop if operation was cancelled.
			if (_ct != null && _ct.IsCancellationRequested) {
				return;
			}

			var listener = ar.AsyncState as TcpListener;
			if (listener == null) {
				return;
			}

			// Check cancellation again. Stop if operation was cancelled.
			if (_ct != null && _ct.IsCancellationRequested) {
				return;
			}

			// Starts waiting for the next request.
			listener.BeginAcceptTcpClient(ProcessRequest, listener);

			// Gets client and starts processing received request.
			using (TcpClient client = listener.EndAcceptTcpClient(ar)) {
				Foms_Client rp = null;
				IDbConnection sqlConnect = null;
				try {
					string connectString = ConfigurationManager.ConnectionStrings["FomsConnectionDB"].ConnectionString;
					try {
						/// to-do: вынести параметр TypeDB в конфиг и в зависимости от него создавать коннект на другие СУБД
						sqlConnect = new System.Data.SqlClient.SqlConnection(connectString); // реализация под Sql Server

					}
					catch (Exception e) {
						//WriteError(e, Msg: "Ошибка создания DbConnection");
						throw e;
						//sqlConnect = null;
					}
					rp = new Foms_Client(client, Password ?? "", LoggerDir ?? "", sqlConnect, LoggingLine, DbObjTimeoutParam ?? new DbTimeoutParam());
					rp.StartConn();
				}
				catch (Exception e) {
					WriteError(e);
				}
				finally {
					if (rp != null && rp.ProcessTokenSource != null) {
						try {
							rp.ProcessTokenSource.Cancel();
						}
						catch (Exception e) {
							string s = e.Message;
						}
						finally {
							Thread.Sleep(250 * 100);
						}
					};
					if (rp != null)
						try {
							rp.CloseConn();
						}
						catch (Exception e) {
							WriteError(e);
						}
				}
			}
		}

		public void Stop() {
			// If listening has been cancelled, simply go out from method.
			if (_ct != null && _ct.IsCancellationRequested) {
				return;
			}

			// Cancels listening.
			if (_cts != null) _cts.Cancel();

			// Waits a little, to guarantee 
			// that all operation receive information about cancellation.
			Thread.Sleep(250);

			Listener.Stop();
		}
	}

	public class DbTimeoutParam {
		public int GetRegistryLoad { get; set; }
		public int HistorySyncDataBulkCopy { get; set; }
		public int GetHistoryCheck { get; set;  }
	}
}
