﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Configuration.Install;
using System.Linq;
using System.ServiceProcess;
using System.Text;
using System.Threading.Tasks;

namespace AisFomsWorker
{
	static class Program
	{
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		static void Main(string[] args)
		{
			//ServiceBase[] ServicesToRun = new ServiceBase[] { new FomsWorkerService() };
			//ServiceBase.Run(ServicesToRun);
			FomsWorkerService service = new FomsWorkerService();
			if (Environment.UserInteractive) {
				service.RunAsConsole(args);
			}
			else {
				ServiceBase[] ServicesToRun;
				ServicesToRun = new ServiceBase[] { service };
				ServiceBase.Run(ServicesToRun);
			}
		}
	}


		/// <summary>
		/// Служебный класс для установки служб Windows
		/// </summary>
		[RunInstaller(true)]
		public class ProjectInstaller : Installer
		{
			private ServiceProcessInstaller serviceProcess;
			private ServiceInstaller serviceInstaller;

			const string Name = "AisFomsService";

			public ProjectInstaller()
			{
				serviceProcess = new ServiceProcessInstaller();

				// учетная запись, под которой будет запускаться служба
				serviceProcess.Account = ServiceAccount.LocalSystem;

				serviceInstaller = new ServiceInstaller();
				serviceInstaller.ServiceName = Name;
				serviceInstaller.Description = "Служба для взаимодействия с АИС Эксперт по протоколу TCP (ТФОМС)";

				// указываем, чтобы служба запускалась вручную
				serviceInstaller.StartType = ServiceStartMode.Manual;

				Installers.Add(serviceProcess);
				Installers.Add(serviceInstaller);

				serviceInstaller.AfterInstall += serviceInstaller_AfterInstall;
			}

			void serviceInstaller_AfterInstall(object sender, InstallEventArgs e)
			{
				/*if (!System.Diagnostics.Debugger.IsAttached) {
					ServiceController sc = new ServiceController(Name);
					sc.Start();
				}*/
			}
		}
}
