﻿using System;
using System.Xml.Serialization;

namespace AisFomsWorker
{
//*
	/// <summary>
	/// Класс для Exp1000Demo.xml
	/// </summary>
	[Serializable] [XmlRoot("Data")]
	public class Xml1000Demo
	{
		[XmlArray("table_table")] [XmlArrayItem("table")]
		public LoadDemoItem[] Items { get; set; }
	}

	/// <summary>
	/// Аналог класса Db.LoadItem, заточенная под xml
	/// </summary>
	[Serializable]
	public class LoadDemoItem : Db.ILoadItem
	{
		/// <summary>
		/// Идентификатор случая
		/// </summary>
		[XmlAttribute] public long TF_UIDIDSL { get; set; }

		/// <summary>
		/// Идентификатор услуги в случае
		/// </summary>
		[XmlAttribute] public long TF_GKEY { get; set; }

		[XmlAttribute] public DateTime LastDtChange { get; set; }
		[XmlAttribute] public String OT_PER { get; set; }
		[XmlAttribute] public String MSK_OT { get; set; }
		[XmlAttribute] public Int32 CODE_MSK { get; set; }
		[XmlAttribute] public Int32 VID_MP { get; set; }
		[XmlAttribute] public Int32 USL_OK { get; set; }
		[XmlAttribute] public Int32 PROFIL { get; set; }
		[XmlAttribute] public String MKB1 { get; set; }
		[XmlAttribute] public String MKB2 { get; set; }
		[XmlAttribute] public String MKB3 { get; set; }
		[XmlAttribute] public String CODE_USL { get; set; }
		[XmlAttribute] public String CODE_MD { get; set; }
		[XmlAttribute] public double KOL_USL { get; set; }
		[XmlAttribute] public Int32 KOL_FACT { get; set; }
		[XmlAttribute] public Int32 ISH_MOV { get; set; }
		[XmlAttribute] public Int32 RES_GOSP { get; set; }
		[XmlAttribute] public double TARIF_B { get; set; }
		[XmlAttribute] public double TARIF_S { get; set; }
		[XmlAttribute] public double TARIF_1K { get; set; }
		[XmlAttribute] public double SUM_RUB { get; set; }
		[XmlAttribute] public double VID_TR { get; set; }
		[XmlAttribute] public Int16 EXTR { get; set; }
		[XmlAttribute] public String CODE_OTD { get; set; }

		[XmlAttribute("SOUF")] public string _SOUF { get; set; }
		[XmlIgnore] 
		public Int16? SOUF {
			get { return String.IsNullOrEmpty(_SOUF) ? (Int16?)null : Int16.Parse(_SOUF); }
			set { _SOUF = (value == null) ? "" : value.Value.ToString(); }
		}

		[XmlAttribute] public Int32 SPEC_MD { get; set; }
		[XmlAttribute] public Int32 DOMC_TYPE { get; set; }
		[XmlAttribute] public String OKATO_INS { get; set; }
		[XmlAttribute] public String NOVOR { get; set; }
		[XmlAttribute] public int CODE_LPU { get; set; }
		[XmlAttribute] public String VID_SF { get; set; }
		[XmlAttribute] public String NHISTORY { get; set; }
		[XmlAttribute] public Int64 PERSCODE { get; set; }
		[XmlAttribute] public DateTime DATE_IN { get; set; }
		[XmlAttribute] public DateTime DATE_OUT { get; set; }
		[XmlAttribute] public double TARIF_D { get; set; }
		[XmlAttribute] public String VID_KOEFF { get; set; }
		[XmlAttribute] public String USL_TMP { get; set; }
		[XmlAttribute] public DateTime BIRTHDAY { get; set; }
		[XmlAttribute] public Int16 SEX { get; set; }
		[XmlAttribute] public String COUNTRY { get; set; }

		[XmlAttribute("SEX_P")] public string _SEX_P { get; set; }
		[XmlIgnore]
		public Int16? SEX_P
		{
			get { return String.IsNullOrEmpty(_SEX_P) ? (Int16?)null : Int16.Parse(_SEX_P); }
			set { _SEX_P = (value == null) ? "" : value.Value.ToString(); }
		}

		[XmlAttribute("BIRTHDAY_P")] public string _BIRTHDAY_P { get; set; }
		[XmlIgnore]
		public DateTime? BIRTHDAY_P
		{
			get { return String.IsNullOrEmpty(_BIRTHDAY_P) ? (DateTime?)null : DateTime.Parse(_BIRTHDAY_P); }
			set { _BIRTHDAY_P = (value == null) ? "" : value.Value.ToString(); }
		}

		[XmlAttribute("INV")] public string _INV { get; set; }
		[XmlIgnore]
		public Int16? INV
		{
			get { return String.IsNullOrEmpty(_INV) ? (Int16?)null : Int16.Parse(_INV); }
			set { _INV = (value == null) ? "" : value.Value.ToString(); }
		}

		[XmlAttribute("DATE_NPR")] public string _DATE_NPR { get; set; }
		[XmlIgnore]
		public DateTime? DATE_NPR
		{
			get { return String.IsNullOrEmpty(_DATE_NPR) ? (DateTime?)null : DateTime.Parse(_DATE_NPR); }
			set { _DATE_NPR = (value == null) ? "" : value.Value.ToString(); }
		}

		[XmlAttribute] public Int32 FOR_POM { get; set; }

		[XmlAttribute("MSE")] public string _MSE { get; set; }
		[XmlIgnore]
		public bool? MSE
		{
			get { return String.IsNullOrEmpty(_MSE) ? (bool?)null : Boolean.Parse(_MSE); }
			set { _MSE = (value == null) ? "" : value.Value.ToString(); }
		}

		[XmlAttribute] public String P_CEL { get; set; }
		
		[XmlAttribute("DN")] public string _DN { get; set; }
		[XmlIgnore]
		public Int16? DN
	{
			get { return String.IsNullOrEmpty(_DN) ? (Int16?)null : Int16.Parse(_DN); }
			set { _DN = (value == null) ? "" : value.Value.ToString(); }
		}

		[XmlAttribute("TAL_P")] public string _TAL_P { get; set; }
		[XmlIgnore]
		public DateTime? TAL_P
		{
			get { return String.IsNullOrEmpty(_TAL_P) ? (DateTime?)null : DateTime.Parse(_TAL_P); }
			set { _TAL_P = (value == null) ? "" : value.Value.ToString(); }
		}

		[XmlAttribute] public Int16 PROFIL_K { get; set; }
		[XmlAttribute] public String NAPR_MO { get; set; }
		[XmlAttribute] public String MKB0 { get; set; }

		[XmlAttribute("DS_ONK")] public string _DS_ONK { get; set; }
		[XmlIgnore]
		public bool? DS_ONK
		{
			get { return String.IsNullOrEmpty(_DS_ONK) ? (bool?)null : Boolean.Parse(_DS_ONK); }
			set { _DS_ONK = (value == null) ? "" : value.Value.ToString(); }
		}

		[XmlAttribute] public Int32 VAL_KOEFF { get; set; }

		[XmlAttribute("C_ZAB")] public string _C_ZAB { get; set; }
		[XmlIgnore] 
		public Int32? C_ZAB {
			get { return String.IsNullOrEmpty(_C_ZAB) ? (Int32?)null : Int32.Parse(_C_ZAB); }
			set { _C_ZAB = (value == null) ? "" : value.Value.ToString(); }
		}
		[XmlAttribute] public double EKMP { get; set; }
		[XmlAttribute] public double MEE { get; set; }
	}
//*/
}
