﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DemoApp
{
	using Newtonsoft.Json;
	using con = System.Console;
	//using AisExpLibrary;
	using System.IO;
	using System.Net.Sockets;
	using System.Net;
	using System.Runtime.Serialization.Formatters.Binary;
	using System.Runtime.Serialization;
    using System.Threading;
    using Витакор;
    using Newtonsoft.Json.Linq;

    class TFOMS_Server
	{
		private int _port;
		private TcpListener _tcpListener;
		
		//private bool _running;
		//private TcpClient connectedTcpClient;
		
		//private Thread _connectionThread;

		public TFOMS_Server(int port)
		{
			this._port = port;
			this._tcpListener = new TcpListener(IPAddress.Loopback, port);
			
		}

		public void Start()
		{
			_tcpListener.Start();
			Console.WriteLine("Waiting for a connection...\r\n");

			//this._connectionThread = new Thread(new ThreadStart(ListenForClientConnections));
			//this._connectionThread.Start();

			while (true)
			{
				try
				{
					var tcpClient = _tcpListener.AcceptTcpClient();
					ThreadPool.QueueUserWorkItem(new WaitCallback(ListenForClientConnections), tcpClient);
				}
				catch (Exception e)
				{
					string s = e.Message;
				}
			}

		}

		public void Stop()
		{
			if (_tcpListener != null)
				this._tcpListener.Stop();
				
		}

		private void ListenForClientConnections(Object StateInfo)
		{
			//var tcpClient = this._tcpListener.AcceptTcpClient();

			// Просто создаем новый экземпляр класса Client и передаем ему приведенный к классу TcpClient объект StateInfo
			new Client((TcpClient)StateInfo);
		}
	}

	class Program
	{
		static int Port = 62065;
		static void Main(string[] args)
		{
			TFOMS_Server server = null;
			try {
				server = new TFOMS_Server(Port);
				server.Start();
			}
			catch (Exception exc)
			{
				con.WriteLine(String.Format("\r\nException: {0}", exc.Message));
			}
			finally {
				if (server != null) server.Stop();
			}
			con.WriteLine("\r\n> End.");
			con.ReadKey();
		}
	}

	/// <summary>
	/// Класс-обработчик клиента
	/// </summary>
	class Client
	{
		public Client(TcpClient c)
		{
			client = c;
			// Handle client in another thread.
			(new Thread(new ThreadStart(SetupConn)) { IsBackground = true }).Start();
		}

		public TcpClient client;
		public NetworkStream netStream;  // Raw-data stream of connection.
		public BinaryReader br;
		public BinaryWriter bw;

		//private static object lock_obj = new object();
		
		public static int SwapEndianness(int value)
		{
			var b1 = (value >> 0) & 0xff;
			var b2 = (value >> 8) & 0xff;
			var b3 = (value >> 16) & 0xff;
			var b4 = (value >> 24) & 0xff;

			return b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
		}

		public static uint SwapEndianness(uint value)
		{
			var b1 = (value >> 0) & 0xff;
			var b2 = (value >> 8) & 0xff;
			var b3 = (value >> 16) & 0xff;
			var b4 = (value >> 24) & 0xff;

			return b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
		}

		private void SendData(BinaryWriter writer, Message message, bool ignoreNulls = true, long? ElapsedMilliseconds = null)
		{
			/*var ser = new Newtonsoft.Json.JsonSerializer() {
				NullValueHandling = ignoreNulls ? Newtonsoft.Json.NullValueHandling.Ignore : Newtonsoft.Json.NullValueHandling.Include,
				Formatting = Formatting.None,
			};
			string data = JObject.FromObject(message, ser).ToString();
 			data = data.Replace(System.Environment.NewLine, "");
			data = data.Replace((char)32 + "", "");*/
			//Console.WriteLine($"Message Send (lenght ='{data.Length}') messageID:{message.id}, command:{message.MsgCommand.ToString()}({message.command}) {(ElapsedMilliseconds.HasValue ? ElapsedMilliseconds.Value.ToString() + "ms" : string.Empty)}");

			string jsnData = JsonConvert.SerializeObject(message, Formatting.None, 
					new JsonSerializerSettings() {
						NullValueHandling = ignoreNulls ? NullValueHandling.Ignore : NullValueHandling.Include 
					}
				);

			byte[] bb = Encoding.UTF8.GetBytes(jsnData);
			lock (netStream)
			{
				// проверяем живой ли connection
				if (client.Client.Connected)
				{
					writer.Write(SwapEndianness(bb.Length));
					writer.Write(bb);
					writer.Flush();
				}
			}
		}

		private Message ReadNextPacket(BinaryReader reader, bool forceWait = false)
		{
			string data = null;
			if (netStream.DataAvailable || forceWait)
			{
				lock (netStream)
				{
					byte[] aa = reader.ReadBytes(4);
					int size = BitConverter.ToInt32(aa.Reverse().ToArray(), 0);
					data = Encoding.UTF8.GetString(reader.ReadBytes(size));
				}
				return JObject.Parse(data).ToObject<Message>();
			}
			else return null;
		}

		void SetupConn()  // Setup connection and login or register.
		{
			try
			{
				netStream = client.GetStream();
				// Now we have encrypted connection.

				br = new BinaryReader(netStream, Encoding.UTF8);
				bw = new BinaryWriter(netStream, Encoding.UTF8);

				// Say "hello".
				byte[] hello = br.ReadBytes(16);
				Guid h = new Guid(hello).ChangeByteOrder();

				if (h == new Guid(Command.Hello.GetID()))
				{
					Console.WriteLine("Autorize");
					//Отвечаем тем же самым пакетом приветствия
					bw.Write(hello);
					bw.Flush();

					Message msg = ReadNextPacket(br, true);
					Console.WriteLine("ProtocolCompare");
					if (msg.MsgCommand == Command.ProtocolCompatible)
					{
						SendData(bw, msg);
					}
					else
					{
						return;
					}
					msg = ReadNextPacket(br, true);
					if (msg.MsgCommand == Command.FomsAuthorization)
					{
						var answer = msg.GetAnswer();
						SendData(bw, answer);
					}
					else
					{
						return;
					}
					
					//Запрашиваем ручную синхронизацию
					//CreateSyncPlanningContent tst = new CreateSyncPlanningContent() { timeMark = DateTime.Now.AddYears(-10).UnixTime(), period = new Period(new DateTime(2019, 2, 1), new DateTime(2019, 1, 1)) };
					//msg = new Message() { MsgCommand = Command.CreateSyncPlanningDebug, content = JObject.FromObject(tst) };
					//SendData(bw, msg);

					Receiver();


				}
				CloseConn();
			}
			catch (Exception ex)
			{
				CloseConn();
			}
		}

		void CloseConn() // Close connection.
		{
			try
			{
				//clientInfo.LoggedIn = false;
				//server.activeClients.Remove(clientInfo);
				br.Close();
				bw.Close();
				//ssl.Close();
				netStream.Close();
				client.Close();
			}
			catch { }
		}

		void Receiver()  // Receive all incoming packets.
		{
			//clientInfo.LoggedIn = true;

			try
			{
				while (client.Client.Connected)  // While we are connected.
				{

					Message msg = ReadNextPacket(br, false);  // Get incoming packet.
					if (msg != null)
					{
						//Console.WriteLine($"Message recive '{msg.MsgCommand.ToString()}' ({DateTime.Now.ToString("dd.MM.yyyy HH:mm:ss")})");
						ThreadPool.QueueUserWorkItem(new WaitCallback(ProcessMessage), msg);
					}
					Thread.Sleep(100);
				}
			}
			catch (Exception)
			{
				//Продолжаем работать...
			}

			//clientInfo.LoggedIn = false;
		}

		private void ProcessMessage(object message)
		{

			Message msg = (Message)message;

			Message result = null;
			try
			{
				System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
				sw.Start();
				if (msg.maxTimeLife.HasValue)
				{
					int ms = msg.maxTimeLife.Value * 1000;
					ms = ms - 3000;
					if (ms <= 0) { ms = 1000; }
					Task<Message> task = Task.Run<Message>(() => DoMessage(msg));
					bool finish = false;
					int lastwait = 0;
					while (!task.IsCompleted)
					{
						System.Diagnostics.Stopwatch step = new System.Diagnostics.Stopwatch();
						step.Start();
						task.Wait(ms);
						if (!task.IsCompleted)
						{
							//Время обработки команды заканчивается, просим еще подождать...
							SendWaitCommand(msg, msg.maxTimeLife.Value);
						}
						step.Stop();
						lastwait = step.Elapsed.Seconds;
					}
					if (task.IsFaulted)
					{
						throw task.Exception;
					}
					result = task.Result;

					if (finish && (msg.maxTimeLife.Value - lastwait) < 5)
					{
						SendWaitCommand(msg, 5 - (msg.maxTimeLife.Value - lastwait));
					}

				}
				else
				{
					result = DoMessage(msg);
				}
				sw.Stop();
				if (result != null)
				{
					SendData(bw, result, false, sw.ElapsedMilliseconds);
				}
			}
			catch (Exception ex)
			{
				result = msg.GetError(ex.Message);
				SendData(bw, result, false);
			}
		}

		private void SendWaitCommand(Message msg, int seconds)
		{
			Console.WriteLine("keepWaitCommand");
			Message keepWaitCommand = new Message();
			keepWaitCommand.command = Command.KeepWaitCommand.GetID();
			keepWaitCommand.MsgPriority = MsgPriority.High;
			keepWaitCommand.content = JObject.FromObject(new { messageId = msg.id, commandId = msg.command, timeToAdd = seconds });
			SendData(bw, keepWaitCommand, false);
		}

		private Message DoMessage(Message msg)
		{
			Message result = null;
			try
			{
				switch (msg.MsgCommand)
				{
					/*case Command.Unknown:*/
					case Command.FomsEcho:
						result = msg.GetAnswer(true);
						break;
					case Command.Error:
						break;
					case Command.CloseConnection:
						break;
					/*case Command.SyncData:
						break;
					case Command.SendData:
						break;
					case Command.RequestSyncData:
						break;
					case Command.GetSyncData:
						break;*/
					case Command.GetSyncData2: //result = GetSyncData2(msg);
						var items = new ReestrItem[] { new ReestrItem ()
							{
								GKEY = Guid.NewGuid(),
								IDSL = Guid.NewGuid(),
								TIME_MARK = Utils.UnixTime(DateTime.Now),
								OT_PER = "1805",
								MSK_OT = "28",
								CODE_MSK = "28",
								VID_MP = 11,
								USL_OK = 3,
								PROFIL = 71,
								MKB1 = "J069",
								MKB2 = "",
								MKB3 = "",
								CODE_USL = "1719600",
								CODE_MD = "3045",
								KOL_USL = 1.0,
								KOL_FACT = 1,
								ISH_MOV = "32",
								RES_GOSP = 2,
								TARIF_B = 276.4,
								TARIF_S = 277.2,
								TARIF_1K = 0,
								SUM_RUB = 304.3,
								VID_TR = "",
								EXTR = "0",
								CODE_OTD = "",
								SOUF = "1",
								SPEC_MD = 90200,
								DOMC_TYPE = 3,
								OKATO_INS = "46000000",
								NOVOR = "0",
								CODE_LPU = "450102",
								VID_SF = "14",
								NHISTORY = "2021064",
								PERSCODE = "24352",
								DATE_IN = 1555915540,
								DATE_OUT = 1555915540,
								TARIF_D = 0.0,
								VID_KOEFF = "6",
								USL_TMP = "",
								BIRTHDAY = 1555915540,
								SEX = "1",
								COUNTRY = "643",
								SEX_P = "",
								BIRTHDAY_P = 1555915540,
								INV = "0",
								DATE_NPR = 1555915540,
								FOR_POM = 3,
								MSE = "0",
								P_CEL = "2.6",
								DN = "None",
								TAL_P = 1555915540,
								PROFIL_K = "None",
								NAPR_MO = "",
								MKB0 = "",
								DS_ONK = 0,
								VAL_KOEFF = 1,
								C_ZAB = "None",
								EKMP = 0,
								MEE = 0
							}
						}; 
						result = msg.GetAnswer();
						//string strSer = Newtonsoft.Json.JsonConvert.SerializeObject(items); 
						//result.content = JObject.FromObject(items.First());
						try {
							SyncPlanningContent content = msg.content.ToObject<SyncPlanningContent>();
							
							/*content.count = 5000;
							q = 12k
								5
								5
								2

							q = 5
								5
								0*/

							content.items = JArray.FromObject(items);
							content.timeMark = Utils.UnixTime(DateTime.Now);

							result.content = JObject.FromObject(content);
						}
						catch (Exception e) {
							result = null;
						}
						break;
					case Command.SyncDataCheck:
						//result = SyncDataCheck(msg);
						break;
					case Command.SendScoreCheck:
						/* окончание SyncDataCheck */

						//result = SendScoreCheck(msg);
						break;
					/*case Command.SyncDataCount:
						break;
					case Command.RequestNsiData:
						break;
					case Command.GetNsiData:
						break;
					case Command.SendScore:
						//result = SendScore(msg);
						break;
					case Command.SendScoreData:
						break;
					case Command.SendReport:
						break;
					case Command.SendReportData:
						break;
					case Command.SmoScores:
						break;
					case Command.RequestSmoScore:
						break;
					case Command.GetSmoScoreData:
						break;
					case Command.BreakDataTransfer:
						break;
					case Command.GroupAdd:
						break;
					case Command.GroupEdit:
						break;
					case Command.GroupDelete:
						break;
					case Command.GroupInfo:
						break;
					case Command.GroupList:
						break;
					case Command.AssignGroup:
						break;
					case Command.ScoreEdit:
						break;
					case Command.ScoreDelete:
						break;
					case Command.ScoreInfo:
						break;
					case Command.ScoreList:
						break;
					case Command.CreateSyncPlanning:
						break;
					case Command.CreateSyncPlanningDebug:
						break;
					case Command.SyncDataNow:
						break;
					case Command.SyncDataEnabled:
						break;
					case Command.SyncDataInfo:
						break;
					case Command.SyncDataSet:
						break;*/
					
					//case Command.NsiVidmpList: break; 
					//case Command.NsiProfileList: break;
					//case Command.NsiLpuList: break;
					//case Command.NsiMkbList: break;

					/*case Command.TaskReportCreate:
						break;
					case Command.ReportInfo:
						break;
					case Command.ReportList:
						break;
					case Command.ReportData:
						break;
					case Command.ReportEdit:
						break;
					case Command.ReportDelete:
						break;
					case Command.ModelXgbDelete:
						break;
					case Command.ModelXgbInfo:
						break;
					case Command.ModelXgbEdit:
						break;
					case Command.ModelXgbOption:
						break;
					case Command.EventLogList:
						break;
					case Command.Monitoring:
						break;
					case Command.AisVersion:
						break;
					default:
						break;*/
				}
			}
			catch (Exception ex)
			{
				result = msg.GetError(ex.Message);
			}
			return result;
		}

		#region RECEIVED PACKETS
		/*private Message GetSyncData2(Message message)
		{
			Message result = message.GetAnswer();
			SyncPlanningContent content = message.content.ToObject<SyncPlanningContent>();

			APIClient cli = new APIClient();
			ListRequest r = new ListRequest();
			JObject filter = new JObject();

			Console.WriteLine($"Read data from {content.period.GetBegin().ToString("dd.MM.yyyy")} to {content.period.GetEnd().ToString("dd.MM.yyyy")}  time_mark {content.timeMark}  count = {content.count}");

			JObject load = new JObject();
			load["From"] = content.period.GetBegin().ToString("dd.MM.yyyy");
			load["To"] = content.period.GetEnd().ToString("dd.MM.yyyy");
			JObject stamp = new JObject();
			stamp["From"] = content.timeMark;

			filter["_D2"] = load;
			filter["TIME_MARK"] = stamp;
			r.filter = filter;
			r.sort = new SortInfo[1];
			r.sort[0] = new SortInfo();
			r.sort[0].field = "TIME_MARK";
			JToken p = cli.GetPage("services", r, null, 0, content.count);
			content.items = (JArray)((JObject)p)["content"];

			result.content = JObject.FromObject(content);
			return result;
		}*/

		/*private Message SyncDataCheck(Message message)
		{
			Message result = message.GetAnswer();
			SyncPlanningCheck content = message.content.ToObject<SyncPlanningCheck>();

			APIClient cli = new APIClient();
			ListRequest r = new ListRequest();
			JObject filter = new JObject();

			Console.WriteLine($"Read data for CHECKSUM from {content.period.GetBegin().ToString("dd.MM.yyyy")} to {content.period.GetEnd().ToString("dd.MM.yyyy")}  time_mark {content.timeMark} ");

			JObject load = new JObject();
			load["From"] = content.period.GetBegin().ToString("dd.MM.yyyy");
			load["To"] = content.period.GetEnd().ToString("dd.MM.yyyy");
			JObject stamp = new JObject();
			stamp["From"] = content.timeMark;

			filter["_D2"] = load;
			filter["TIME_MARK"] = stamp;
			r.filter = filter;
			r.sort = new SortInfo[1];
			r.sort[0] = new SortInfo();
			r.sort[0].field = "TIME_MARK";
			JToken p = cli.GetPage("services", r, "min", 1, 1000000);
			int cnt = ((JArray)((JObject)p)["content"]).Count();
			ulong crc = 0;
			foreach (JObject item in (JArray)((JObject)p)["content"])
			{
				crc ^= (ulong)item["TIME_MARK"].Value<long>();
			}
			content.crc = crc;

			result.content = JObject.FromObject(content);
			return result;
		}*/

		/*private Message SendScore(Message message)
		{
			Message result = message.GetAnswer();
			SendScoreContent content = message.content.ToObject<SendScoreContent>();


			APIClient cli = new APIClient();

			var r = cli.SaveObject("scoreInfo", new { content.id, content.name, descr = content.descript, content.userId, content.userName, content.modelId, content.modelName });
			JArray items = new JArray();
			var search = new JArray() { "scoreInfo.id", "IDSL" };
			foreach (var item in content.items)
			{
				items.Add(JObject.FromObject(new { search, scoreInfo = new { content.id }, item.IDSL, item.MEE, item.EKMP }));
			}
			var r2 = cli.SaveList("scoreInfoItem", items);
			return result;
		}*/

		/*private Message SendScoreCheck(Message message)
		{
			Message result = message.GetAnswer();
			SendScoreCheck content = message.content.ToObject<SendScoreCheck>();

			APIClient cli = new APIClient();
			ListRequest r = new ListRequest();
			JObject filter = new JObject();

			Console.WriteLine($"Read data for CHECKSUM from id={content.id} count={content.count} crc={content.crc} ");


			filter["scoreInfoId"] = content.id;
			r.filter = filter;
			r.sort = new SortInfo[1];
			r.sort[0] = new SortInfo();
			r.sort[0].field = "id";
			JToken p = cli.GetPage("scoreInfoItem", r, "min", 1, 1000000);
			int cnt = ((JArray)((JObject)p)["content"]).Count();
			ulong crc = 0;
			foreach (JObject item in (JArray)((JObject)p)["content"])
			{
				SimpleItem si = item.ToObject<SimpleItem>();
				byte[] bb = si.id.ToByteArray();
				ulong p1 = (ulong)BitConverter.ToInt64(bb, 0);
				ulong p2 = (ulong)BitConverter.ToInt64(bb, 8);
				ulong rez = p1 ^ p2;

				crc ^= rez;
			}
			content.crc = crc;
			content.count = cnt;
			result.content = JObject.FromObject(content);
			return result;
		}*/
		#endregion
	}

	[Serializable]
	internal class ReestrItem
	{
		public Guid GKEY { get; set; }
		public Guid IDSL { get; set; }
		public long TIME_MARK { get; set; }
		public String OT_PER { get; set; }
		public String MSK_OT { get; set; }
		public String CODE_MSK { get; set; }
		public Int32 VID_MP { get; set; } // = 0;
		public Int32 USL_OK { get; set; } // = 0;
		public Int32 PROFIL { get; set; } // = 0;
		public String MKB1 { get; set; }
		public String MKB2 { get; set; }
		public String MKB3 { get; set; }
		public String CODE_USL { get; set; }
		public String CODE_MD { get; set; }
		public double KOL_USL { get; set; } // = 0;
		public double KOL_FACT { get; set; } // = 0;
		public String ISH_MOV { get; set; }
		public Int32 RES_GOSP { get; set; } // = 0;
		public double TARIF_B { get; set; } // = 0;
		public double TARIF_S { get; set; } // = 0;
		public double TARIF_1K { get; set; } // = 0;
		public double SUM_RUB { get; set; } // = 0;
		public String VID_TR { get; set; }
		public String EXTR { get; set; }
		public String CODE_OTD { get; set; }
		public String SOUF { get; set; }
		public Int32 SPEC_MD { get; set; } // = 0;
		public Int32 DOMC_TYPE { get; set; } // = 0;
		public String OKATO_INS { get; set; }
		public String NOVOR { get; set; }
		public String CODE_LPU { get; set; }
		public String VID_SF { get; set; }
		public String NHISTORY { get; set; }
		public String PERSCODE { get; set; }
		public Int32 DATE_IN { get; set; } // = 0;
		public Int32 DATE_OUT { get; set; } // = 0;
		public double TARIF_D { get; set; } // = 0;
		public String VID_KOEFF { get; set; }
		public String USL_TMP { get; set; }
		public Int32 BIRTHDAY { get; set; } // = 0;
		public String SEX { get; set; }
		public String COUNTRY { get; set; }
		public String SEX_P { get; set; }
		public Int32 BIRTHDAY_P { get; set; } // = 0;
		public String INV { get; set; }
		public Int32 DATE_NPR { get; set; } // = 0;
		public Int32 FOR_POM { get; set; } // = 0;
		public String MSE { get; set; }
		public String P_CEL { get; set; }
		public String DN { get; set; }
		public Int32 TAL_P { get; set; } // = 0;
		public String PROFIL_K { get; set; }
		public String NAPR_MO { get; set; }
		public String MKB0 { get; set; }
		public Int32 DS_ONK { get; set; } // = 0;
		public Int32 VAL_KOEFF { get; set; } // = 0;
		public String C_ZAB { get; set; }


				//public String CODE_NOM1 { get; set; }
				//public String CODE_NOM2 { get; set; }
				//public String CODE_NOM3 { get; set; }
				//public String VAL_TMP { get; set; }
				//public String TIME_FIX { get; set; }
				//public String TIME_IN { get; set; }
				//public String TIME_OUT { get; set; }
				//public String DATE_FIX { get; set; }
				//public String KATEG_MD { get; set; }
				//public String POST_MD { get; set; }
				//public String KOL_DEF { get; set; }
				//public String VID_PROV { get; set; }
				//public String MED_AREA { get; set; }
				//public String TAL_HMP { get; set; }
				//public Int32 DATE_HMP { get; set; } // = 0;
				//public String MCOD_OUT { get; set; }
				//public String NOM_NPR { get; set; }
				//public String SERIES { get; set; }
				//public String NAME_MSK { get; set; }
				//public String OKATO_NAS { get; set; }
				//public String PR_LG { get; set; }


		public double EKMP { get; set; } // = 0;
		public double MEE { get; set; } // = 0;

		/*public override bool Equals(object obj)
		{
			return obj is NewClass other &&
				   GKEY.Equals(other.GKEY) &&
				   SLUCH_I.Equals(other.SLUCH_I) &&
				   TIME_MARK == other.TIME_MARK &&
				   OT_PER == other.OT_PER &&
				   MSK_OT == other.MSK_OT &&
				   CODE_MSK == other.CODE_MSK &&
				   VID_MP == other.VID_MP &&
				   USL_OK == other.USL_OK &&
				   PROFIL == other.PROFIL &&
				   MKB1 == other.MKB1 &&
				   MKB2 == other.MKB2 &&
				   MKB3 == other.MKB3 &&
				   CODE_USL == other.CODE_USL &&
				   CODE_MD == other.CODE_MD &&
				   KOL_USL == other.KOL_USL &&
				   KOL_FACT == other.KOL_FACT &&
				   ISH_MOV == other.ISH_MOV &&
				   RES_GOSP == other.RES_GOSP &&
				   TARIF_B == other.TARIF_B &&
				   TARIF_S == other.TARIF_S &&
				   TARIF_1K == other.TARIF_1K &&
				   SUM_RUB == other.SUM_RUB &&
				   VID_TR == other.VID_TR &&
				   EXTR == other.EXTR &&
				   CODE_OTD == other.CODE_OTD &&
				   SOUF == other.SOUF &&
				   SPEC_MD == other.SPEC_MD &&
				   DOMC_TYPE == other.DOMC_TYPE &&
				   OKATO_INS == other.OKATO_INS &&
				   NOVOR == other.NOVOR &&
				   CODE_LPU == other.CODE_LPU &&
				   VID_SF == other.VID_SF &&
				   NHISTORY == other.NHISTORY &&
				   PERSCODE == other.PERSCODE &&
				   DATE_IN == other.DATE_IN &&
				   DATE_OUT == other.DATE_OUT &&
				   TARIF_D == other.TARIF_D &&
				   VID_KOEFF == other.VID_KOEFF &&
				   USL_TMP == other.USL_TMP &&
				   BIRTHDAY == other.BIRTHDAY &&
				   SEX == other.SEX &&
				   COUNTRY == other.COUNTRY &&
				   SEX_P == other.SEX_P &&
				   BIRTHDAY_P == other.BIRTHDAY_P &&
				   INV == other.INV &&
				   DATE_NPR == other.DATE_NPR &&
				   FOR_POM == other.FOR_POM &&
				   MSE == other.MSE &&
				   P_CEL == other.P_CEL &&
				   DN == other.DN &&
				   TAL_P == other.TAL_P &&
				   PROFIL_K == other.PROFIL_K &&
				   NAPR_MO == other.NAPR_MO &&
				   MKB0 == other.MKB0 &&
				   DS_ONK == other.DS_ONK &&
				   VAL_KOEFF == other.VAL_KOEFF &&
				   C_ZAB == other.C_ZAB &&
				   CODE_NOM1 == other.CODE_NOM1 &&
				   CODE_NOM2 == other.CODE_NOM2 &&
				   CODE_NOM3 == other.CODE_NOM3 &&
				   VAL_TMP == other.VAL_TMP &&
				   TIME_FIX == other.TIME_FIX &&
				   TIME_IN == other.TIME_IN &&
				   TIME_OUT == other.TIME_OUT &&
				   DATE_FIX == other.DATE_FIX &&
				   KATEG_MD == other.KATEG_MD &&
				   POST_MD == other.POST_MD &&
				   KOL_DE == other.KOL_DE &&
				   VID_PRO == other.VID_PRO &&
				   MED_AREA == other.MED_AREA &&
				   TAL_HMP == other.TAL_HMP &&
				   DATE_HMP == other.DATE_HMP &&
				   MCOD_OUT == other.MCOD_OUT &&
				   NOM_NPR == other.NOM_NPR &&
				   SERIES == other.SERIES &&
				   NAME_MSK == other.NAME_MSK &&
				   OKATO_NAS == other.OKATO_NAS &&
				   PR_LG == other.PR_LG &&
				   EKMP == other.EKMP &&
				   MEE == other.MEE;
		}*/

		/*public override int GetHashCode()
		{
			var hashCode = -1207122420;
			hashCode = hashCode * -1521134295 + EqualityComparer<Guid>.Default.GetHashCode(GKEY);
			hashCode = hashCode * -1521134295 + EqualityComparer<Guid>.Default.GetHashCode(SLUCH_I);
			hashCode = hashCode * -1521134295 + TIME_MARK.GetHashCode();
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(OT_PER);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(MSK_OT);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(CODE_MSK);
			hashCode = hashCode * -1521134295 + VID_MP.GetHashCode();
			hashCode = hashCode * -1521134295 + USL_OK.GetHashCode();
			hashCode = hashCode * -1521134295 + PROFIL.GetHashCode();
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(MKB1);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(MKB2);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(MKB3);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(CODE_USL);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(CODE_MD);
			hashCode = hashCode * -1521134295 + KOL_USL.GetHashCode();
			hashCode = hashCode * -1521134295 + KOL_FACT.GetHashCode();
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(ISH_MOV);
			hashCode = hashCode * -1521134295 + RES_GOSP.GetHashCode();
			hashCode = hashCode * -1521134295 + TARIF_B.GetHashCode();
			hashCode = hashCode * -1521134295 + TARIF_S.GetHashCode();
			hashCode = hashCode * -1521134295 + TARIF_1K.GetHashCode();
			hashCode = hashCode * -1521134295 + SUM_RUB.GetHashCode();
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(VID_TR);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(EXTR);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(CODE_OTD);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(SOUF);
			hashCode = hashCode * -1521134295 + SPEC_MD.GetHashCode();
			hashCode = hashCode * -1521134295 + DOMC_TYPE.GetHashCode();
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(OKATO_INS);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(NOVOR);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(CODE_LPU);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(VID_SF);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(NHISTORY);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(PERSCODE);
			hashCode = hashCode * -1521134295 + DATE_IN.GetHashCode();
			hashCode = hashCode * -1521134295 + DATE_OUT.GetHashCode();
			hashCode = hashCode * -1521134295 + TARIF_D.GetHashCode();
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(VID_KOEFF);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(USL_TMP);
			hashCode = hashCode * -1521134295 + BIRTHDAY.GetHashCode();
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(SEX);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(COUNTRY);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(SEX_P);
			hashCode = hashCode * -1521134295 + BIRTHDAY_P.GetHashCode();
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(INV);
			hashCode = hashCode * -1521134295 + DATE_NPR.GetHashCode();
			hashCode = hashCode * -1521134295 + FOR_POM.GetHashCode();
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(MSE);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(P_CEL);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(DN);
			hashCode = hashCode * -1521134295 + TAL_P.GetHashCode();
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(PROFIL_K);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(NAPR_MO);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(MKB0);
			hashCode = hashCode * -1521134295 + DS_ONK.GetHashCode();
			hashCode = hashCode * -1521134295 + VAL_KOEFF.GetHashCode();
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(C_ZAB);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(CODE_NOM1);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(CODE_NOM2);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(CODE_NOM3);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(VAL_TMP);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(TIME_FIX);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(TIME_IN);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(TIME_OUT);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(DATE_FIX);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(KATEG_MD);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(POST_MD);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(KOL_DE);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(VID_PRO);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(MED_AREA);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(TAL_HMP);
			hashCode = hashCode * -1521134295 + DATE_HMP.GetHashCode();
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(MCOD_OUT);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(NOM_NPR);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(SERIES);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(NAME_MSK);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(OKATO_NAS);
			hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(PR_LG);
			hashCode = hashCode * -1521134295 + EKMP.GetHashCode();
			hashCode = hashCode * -1521134295 + MEE.GetHashCode();
			return hashCode;
		}*/
	}
}
