﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Витакор // :-)
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Linq;
    using System.Collections.Specialized;
    using System.IO;
    using System.Net;
    using System.Net.Sockets;
    using System.Threading;

    public static class Utils
	{
		public static long UnixTime(this DateTime date)
		{
			return (long)(date.ToUniversalTime() - new DateTime(1970, 1, 1)).TotalMilliseconds;
		}

		public static DateTime FromUnixTimeMs(long unixTime, bool local = true)
		{
			DateTime dt = new DateTime(1970, 1, 1).AddMilliseconds(unixTime);
			return local ? dt.ToLocalTime() : dt;
		}

		public static string GetID(this Command cmd)
		{
			return Commands.GetCommandID(cmd);
		}

		public static string ToUnixString(this Guid guid,
		   string format = "D", IFormatProvider provider = null)
		{
			return guid.ChangeByteOrder().ToString(format, provider);
		}

		public static Guid ChangeByteOrder(this Guid guid)
		{
			var s = guid.ToByteArray();
			var d = new byte[]
						{
						s[3], s[2], s[1], s[0], s[5], s[4], s[7], s[6],
						s[8], s[9], s[10], s[11], s[12], s[13], s[14], s[15]
						};

			return new Guid(d);
		}
	}

	public class Server
	{
		TcpListener Listener; // Объект, принимающий TCP-клиентов
							  // Запуск сервера

		public Server()
		{
		}

		public void Start(int Port)
		{
			//Client.SyncDataCount2(null);
			Listener = new TcpListener(IPAddress.Any, Port); // Создаем "слушателя" для указанного порта
			Listener.Start(); // Запускаем его
							  // В бесконечном цикле

			while (true)
			{
				try
				{
					// Принимаем новых клиентов. После того, как клиент был принят, он передается в новый поток (ClientThread)
					// с использованием пула потоков.
					ThreadPool.QueueUserWorkItem(new WaitCallback(ClientThread), Listener.AcceptTcpClient());
				}
				catch
				{ }
			}
		}

		public void Stop()
		{
			// Если "слушатель" был создан
			if (Listener != null)
			{
				// Остановим его
				Listener.Stop();
			}
		}

		static void ClientThread(Object StateInfo)
		{
			// Просто создаем новый экземпляр класса Client и передаем ему приведенный к классу TcpClient объект StateInfo
			new Client((TcpClient)StateInfo);
		}
		// Остановка сервера

		~Server()
		{
			Stop();
		}



	}


	public class CreateSyncPlanningContent
	{
		public Period period { get; set; }
		public long timeMark { get; set; }



		public DateTime GetTimeMark()
		{
			return Utils.FromUnixTimeMs(timeMark);
		}
	}

	public class SyncPlanningContent : CreateSyncPlanningContent
	{
		public int count { get; set; }
		public JArray items { get; set; }
	}

	public class SyncPlanningCheck : CreateSyncPlanningContent
	{
		public UInt64 crc { get; set; }
	}

	public class Period
	{
		public long? begin { get; set; }
		public long? end { get; set; }

		public Period()
		{
		}

		public Period(DateTime begin, DateTime end)
		{
			this.begin = begin.UnixTime();
			this.end = end.UnixTime();
		}
		public DateTime GetBegin()
		{
			return begin.HasValue ? Utils.FromUnixTimeMs(begin.Value) : DateTime.MinValue;
		}

		public DateTime GetEnd()
		{
			return end.HasValue ? Utils.FromUnixTimeMs(end.Value) : DateTime.MinValue;
		}
	}
	
	public class SendScoreContent
	{
		public string id { get; set; }
		public string name { get; set; }
		public string descript { get; set; }
		public long createDate { get; set; }
		public Period period { get; set; }
		public string userId { get; set; }
		public string userName { get; set; }
		public string modelId { get; set; }
		public string modelName { get; set; }
		public string modelDescr { get; set; }
		public Period modelPeriod { get; set; }
		public bool isLast { get; set; }
		public SendScoreItem[] items { get; set; }
	}

	public class SendScoreItem
	{
		public string IDSL { get; set; }
		public float MEE { get; set; }
		public float EKMP { get; set; }
	}

	public class SendScoreCheck
	{
		public string id { get; set; }
		public int count { get; set; }
		public ulong crc { get; set; }
	}

	public class SimpleItem
	{
		public Guid id { get; set; }
	}

	public class NsiContent
	{
		public JArray items { get; set; }
	}


	public enum MsgType : int
	{
		Unknown = 0,
		Command = 1, // Сообщение-команда. Это может быть сообщение с командой
					 // на выполнение действия, либо это может быть запрос
					 // на получение данных. Предполагается, что в ответ
					 // на данное сообщение придет сообщение с типом Answer.
		Answer = 2, // Ответ на сообщением с типом Command.
		Event = 3  // Данный тип сообщения похож на Command, но не предполагает
				   // получения ответа (Answer). Он используется для рассылки
				   // широковещательных сообщений о событиях
	}

	// Статус выполнения/обработки сообщения. Используется в сообщениях
	// с типом Answer для того чтобы уведомить другую сторону о статусе
	// выполнения команды с типом Command
	public enum MsgExecStatus : int
	{
		Unknown = 0,
		Success = 1, // Сообщение было обработано успешно и содержит корректные
					 // ответные данные.
		Failed = 2, // Сообщение не было обработано успешно, но результат
					// не является ошибкой.
					// В данном случае сообщение (Message) будет содержать
					// данные в формате communication::data::MessageFailed.
		Error = 3  // При обработке сообщения произошла ошибка, и в качестве
				   // ответа отправляется сообщения с описанием причины ошибки.
				   // В данном случае сообщение (Message) будет содержать
				   // данные в формате communication::data::MessageError
	}

	public enum MsgPriority : int
	{
		High = 0,
		Normal = 1,
		Low = 2
		// Reserved = 3
	}

	public enum MsgCompression : int
	{
		None = 0,
		Zip = 1,
		Lzma = 2,
		Ppmd = 3,
		Disable = 7 // Используется в тех случаях когда нужно явно запретить
					// сжатие сообщения при его отправке в TCP сокет.
					// Это может потребоваться когда контент изначально сжат,
					// например, при отправке JPG, PNG, и прочих подобных
					// форматов
	}


	public class Message
	{

		private JToken _content;
		private int? _maxTimeLife;
		private BitVector32 vec = new BitVector32(0);
		private BitVector32.Section type;
		private BitVector32.Section execStatus;
		private BitVector32.Section priority;
		private BitVector32.Section compression;
		private BitVector32.Section tagsIsEmpty;
		private BitVector32.Section maxTimeLifeIsEmpty;
		private BitVector32.Section contentIsEmpty;
		private BitVector32.Section reserved2;
		private BitVector32.Section reserved3;
		private BitVector32.Section contentFormat;
		private BitVector32.Section reserved4;
		private BitVector32.Section flags2IsEmpty;

		public string id { get; set; }
		public string command { get; set; }


		public uint flags
		{
			get
			{
				return (uint)vec.Data;
			}
			set
			{
				vec = new BitVector32((int)value);
				InitVector();
			}
		}

		private void InitVector()
		{
			type = BitVector32.CreateSection(7);
			execStatus = BitVector32.CreateSection(7, type);
			priority = BitVector32.CreateSection(3, execStatus);
			compression = BitVector32.CreateSection(7, priority);
			tagsIsEmpty = BitVector32.CreateSection(1, compression);
			maxTimeLifeIsEmpty = BitVector32.CreateSection(1, tagsIsEmpty);
			contentIsEmpty = BitVector32.CreateSection(1, maxTimeLifeIsEmpty);
			reserved2 = BitVector32.CreateSection(3, contentIsEmpty);
			reserved3 = BitVector32.CreateSection(255, reserved2);
			contentFormat = BitVector32.CreateSection(7, reserved3);
			reserved4 = BitVector32.CreateSection(15, contentFormat);
			flags2IsEmpty = BitVector32.CreateSection(1, reserved4);
		}

		public int? maxTimeLife
		{
			get
			{
				return this._maxTimeLife;
			}
			set
			{
				this._maxTimeLife = value;
				vec[maxTimeLifeIsEmpty] = value.HasValue ? 0 : 1;
			}
		}

		public JToken content
		{
			get { return _content; }
			set
			{
				this._content = value;
				vec[contentIsEmpty] = value == null ? 1 : 0;
			}
		}

		[JsonIgnore]
		public MsgType MsgType
		{
			get
			{
				return (MsgType)vec[type];
			}
			set
			{
				vec[type] = (int)value;
			}
		}

		[JsonIgnore]
		public MsgExecStatus MsgExecStatus
		{
			get
			{
				return (MsgExecStatus)vec[execStatus];
			}
			set
			{
				vec[execStatus] = (int)value;
			}
		}

		[JsonIgnore]
		public MsgPriority MsgPriority
		{
			get
			{
				return (MsgPriority)vec[priority];
			}
			set
			{
				vec[priority] = (int)value;
			}
		}
		[JsonIgnore]
		public MsgCompression MsgCompression
		{
			get
			{
				return (MsgCompression)vec[compression];
			}
			set
			{
				vec[compression] = (int)value;
			}
		}

		[JsonIgnore]
		public Command MsgCommand
		{
			get
			{
				return Commands.GetCommand(this.command);
			}
			set
			{
				command = value.GetID();
			}
		}

		public Message()
		{
			InitVector();
			this.id = Guid.NewGuid().ToString();
			vec[tagsIsEmpty] = 1;
			vec[maxTimeLifeIsEmpty] = 1;
			vec[contentIsEmpty] = 1;
			vec[contentFormat] = 1;
			vec[flags2IsEmpty] = 1;
			this.MsgType = MsgType.Command;
			this.MsgExecStatus = MsgExecStatus.Unknown;
			this.MsgCompression = MsgCompression.None;
			this.MsgPriority = MsgPriority.Normal;
		}

		public Message GetAnswer(bool copyContent = false)
		{
			Message msg = new Message();
			msg.id = this.id;
			msg.command = this.command;
			msg.flags = this.flags;
			if (copyContent)
			{
				msg.content = this.content;
			}
			msg.MsgType = MsgType.Answer;
			msg.MsgExecStatus = MsgExecStatus.Success;
			msg.MsgCompression = MsgCompression.None;
			msg.MsgPriority = MsgPriority.Normal;
			return msg;
		}

		public Message GetError(string error)
		{
			Message msg = GetAnswer();
			msg.id = this.id;
			msg.command = this.command;
			msg.content = JObject.FromObject(new { group = 60, code = "6027874c-7b16-4eb4-9615-ac833b54be11", description = error });
			msg.MsgExecStatus = MsgExecStatus.Error;
			return msg;
		}

	}


	public enum Command
	{
		Unknown,
		Error,
		ProtocolCompatible,
		CloseConnection,
		Hello,
		KeepWaitCommand,


		SpeedTest,
		UPoolAuthorization,
		FomsAuthorization,
		WebAuthorization,
		UPoolUserList,
		UPoolValidUsers,
		UPoolChangesNotify,
		UPoolSidVerify,
		UPoolUserAuth,
		UserActiveStatus,
		UserActiveSet,
		UserResetAuth,
		UserLogout,
		UserInfo,
		UserList,
		FomsEcho,
		SyncData,
		SendData,
		SyncDataCheck,
		RequestSyncData,
		GetSyncData,
		GetSyncData2,
		SyncDataCount,
		RequestNsiData,
		GetNsiData,
		SendScore,
		SendScoreData,
		SendScoreCheck,

		SendReport,
		SendReportData,

		SmoScores,
		RequestSmoScore,
		GetSmoScoreData,
		BreakDataTransfer,

		GroupAdd,
		GroupEdit,
		GroupDelete,
		GroupInfo,
		GroupList,
		AssignGroup,

		TaskStartNow,
		TaskProgress,
		TaskInterrupt,
		TaskInterruptDone,

		TaskModelCreate,
		TaskModelEdit,
		TaskModelDelete,
		TaskModelInfo,
		TaskModelList,

		TaskScoreCreate,
		TaskScoreEdit,
		TaskScoreDelete,
		TaskScoreInfo,
		TaskScoreList,

		TaskContentCreate,
		TaskAlert,

		ModelEdit,
		ModelDelete,
		ModelInfo,
		ModelList,

		ScoreEdit,
		ScoreDelete,
		ScoreInfo,
		ScoreList,

		CreateSyncPlanning,
		CreateSyncPlanningDebug,
		SyncDataNow,
		SyncDataEnabled,
		SyncDataInfo,
		SyncDataSet,
		// NSI
		SyncNsiVidmp,
		SyncNsiProfile,
		SyncNsiLpu,
		SyncNsiMkb,

		TaskReportCreate,
		ReportInfo,
		ReportList,
		ReportData,
		ReportEdit,
		ReportDelete,

		ModelXgbDelete,
		ModelXgbInfo,
		ModelXgbEdit,
		ModelXgbOption,

		EventLogList,
		Monitoring,

		AisVersion,
	}

	public class Commands
	{
		private static Dictionary<Command, string> cmd = new Dictionary<Command, string>();
		private static Dictionary<string, Command> cmd2 = new Dictionary<string, Command>();

		private static void REGISTRY_COMMAND_SINGLPROC(Command command, string id)
		{
			try
			{
				cmd.Add(command, id);
				cmd2.Add(id, command);
			}
			catch
			{
			}
		}

		public static Command GetCommand(string id)
		{
			Command c;
			if (cmd2.TryGetValue(id, out c))
			{
				return c;
			}
			return Command.Unknown;
		}

		public static string GetCommandID(Command command)
		{
			string id;
			if (cmd.TryGetValue(command, out id))
			{
				return id;
			}
			return null;
		}

		static Commands()
		{
			REGISTRY_COMMAND_SINGLPROC(Command.Unknown, "4aef29d6-5b1a-4323-8655-ef0d4f1bb79d");
			REGISTRY_COMMAND_SINGLPROC(Command.Error, "b18b98cc-b026-4bfe-8e33-e7afebfbe78b");
			REGISTRY_COMMAND_SINGLPROC(Command.ProtocolCompatible, "173cbbeb-1d81-4e01-bf3c-5d06f9c878c3");
			REGISTRY_COMMAND_SINGLPROC(Command.CloseConnection, "e71921fd-e5b3-4f9b-8be7-283e8bb2a531");
			REGISTRY_COMMAND_SINGLPROC(Command.Hello, "fea6b958-dafb-4f5c-b620-fe0aafbd47e2");
			REGISTRY_COMMAND_SINGLPROC(Command.KeepWaitCommand, "edbd2b76-eee4-4ad5-80c0-b95dc0e2dfeb");


			REGISTRY_COMMAND_SINGLPROC(Command.SpeedTest, "b2e4557e-80eb-4b86-8bfa-7a12caade6d0");

			REGISTRY_COMMAND_SINGLPROC(Command.UPoolAuthorization, "bf0510fb-66b8-454a-8eb9-ddd286520ffa");
			REGISTRY_COMMAND_SINGLPROC(Command.FomsAuthorization, "2898212c-870e-44b0-adb8-8a1a845a1f70");
			REGISTRY_COMMAND_SINGLPROC(Command.WebAuthorization, "7bd4b1c1-3f8f-4bcf-b941-5a0f1e7b449f");

			REGISTRY_COMMAND_SINGLPROC(Command.UPoolUserList, "2ec05fe5-366a-41c9-a283-5a617767738d");
			REGISTRY_COMMAND_SINGLPROC(Command.UPoolValidUsers, "c0feaea0-eb2f-4c12-92fd-74629bdd8ea9");
			REGISTRY_COMMAND_SINGLPROC(Command.UPoolChangesNotify, "c0feaea0-eb2f-4c13-92fd-74629bdd8ea9");
			REGISTRY_COMMAND_SINGLPROC(Command.UPoolSidVerify, "c0feaea0-eb2f-4c14-92fd-74629bdd8ea9");
			REGISTRY_COMMAND_SINGLPROC(Command.UPoolUserAuth, "fc7f12a8-9643-4e81-9d27-53b99c19d319");

			REGISTRY_COMMAND_SINGLPROC(Command.UserActiveStatus, "972a16d6-baa1-4410-98e4-1c7a9734481b");
			REGISTRY_COMMAND_SINGLPROC(Command.UserActiveSet, "ef443931-fceb-497c-89cf-0156aa98a057");
			REGISTRY_COMMAND_SINGLPROC(Command.UserResetAuth, "14c292a9-5e92-4c8d-8f61-ba3658254754");
			REGISTRY_COMMAND_SINGLPROC(Command.UserLogout, "481a49e4-e970-4748-9c3d-5e131a4a08e7");
			REGISTRY_COMMAND_SINGLPROC(Command.UserInfo, "56f0f673-b93e-470d-9325-8e4a64afdc3e");
			REGISTRY_COMMAND_SINGLPROC(Command.UserList, "2fa92c5d-7f0a-44ca-9dcc-c10c9d5c60d3");

			REGISTRY_COMMAND_SINGLPROC(Command.FomsEcho, "a8313da2-dd5d-4697-89fe-c0d89a6b715f");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncData, "cbff8510-0dfe-11e9-ab14-d663bd873d93");

			REGISTRY_COMMAND_SINGLPROC(Command.SendData, "cbff8512-0dfe-11e9-ab14-d663bd873d93");

			REGISTRY_COMMAND_SINGLPROC(Command.RequestSyncData, "cbff8920-0dfe-11e9-ab14-d663bd873d93");
			REGISTRY_COMMAND_SINGLPROC(Command.GetSyncData, "cbff8821-0dfe-11e9-ab14-d663bd873d93");
			REGISTRY_COMMAND_SINGLPROC(Command.GetSyncData2, "0a4359c7-e1e0-4cb6-89be-9d798930dc2c");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncDataCheck, "545535a0-ed69-4587-bdf7-f6cb19b8da60");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncDataCount, "ecc2fa12-1782-4ae4-8026-acbce9680f7d");

			REGISTRY_COMMAND_SINGLPROC(Command.RequestNsiData, "1baf0501-8463-45e4-9209-0368c1232355");
			REGISTRY_COMMAND_SINGLPROC(Command.GetNsiData, "34b4517d-902c-4f93-857f-ebf928fbb3bf");

			REGISTRY_COMMAND_SINGLPROC(Command.SendScore, "cbff8923-0dfe-11e9-ab14-d663bd873d93");
			REGISTRY_COMMAND_SINGLPROC(Command.SendScoreData, "cbff8822-0dfe-11e9-ab14-d663bd873d93");
			REGISTRY_COMMAND_SINGLPROC(Command.SendScoreCheck, "53982e4a-9430-4cb3-8743-da3e696b6fd0");

			REGISTRY_COMMAND_SINGLPROC(Command.SendReport, "42f0163b-6743-40a7-9d30-ca980707faea");
			REGISTRY_COMMAND_SINGLPROC(Command.SendReportData, "ed24ce5f-9f69-44b3-9cc5-1b933f6eb8ab");

			REGISTRY_COMMAND_SINGLPROC(Command.SmoScores, "d307296e-fc68-432e-8972-54060e439347");
			REGISTRY_COMMAND_SINGLPROC(Command.RequestSmoScore, "a372111a-f4af-4861-9c61-eb3ab1b08451");
			REGISTRY_COMMAND_SINGLPROC(Command.GetSmoScoreData, "8b67a97a-576f-4dfa-93ba-22ea4a374752");
			REGISTRY_COMMAND_SINGLPROC(Command.BreakDataTransfer, "cbff8e30-0dfe-11e9-ab14-d663bd873d93");

			REGISTRY_COMMAND_SINGLPROC(Command.GroupAdd, "5fc81e1e-2b4d-43c0-983e-8e218ff9e8f9");
			REGISTRY_COMMAND_SINGLPROC(Command.GroupEdit, "02118def-10e5-4fca-b492-63cf5f62a1d9");
			REGISTRY_COMMAND_SINGLPROC(Command.GroupDelete, "b5bcfc10-40eb-4b99-ac3e-44e4377944eb");
			REGISTRY_COMMAND_SINGLPROC(Command.GroupInfo, "47afc108-ff2e-45d4-86f8-0b6292f6c358");
			REGISTRY_COMMAND_SINGLPROC(Command.GroupList, "ee9f9ffd-62a7-4bf3-87bf-02644a99c260");
			REGISTRY_COMMAND_SINGLPROC(Command.AssignGroup, "842876d0-3ee0-4c56-a125-3e715e40c1d2");

			REGISTRY_COMMAND_SINGLPROC(Command.TaskStartNow, "3088861b-f6ff-456f-9c6c-0325344898c2");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskProgress, "12561ec5-e3ba-45ff-96b8-f147456afaba");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskInterrupt, "903ccdae-443f-4aaa-89d2-6eb4f787ebb3");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskInterruptDone, "7b63393f-2a54-4132-9b00-367625e9b85c");

			REGISTRY_COMMAND_SINGLPROC(Command.TaskModelCreate, "50d9cc3e-c54e-42dc-9ca9-af740764d489");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskModelEdit, "2a3e45d9-42b5-4861-8ddc-9b0bc8538743");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskModelDelete, "7dfebaa2-79b2-44d0-9654-3969842484b1");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskModelInfo, "33263c34-4afb-4f85-b4fb-67f49933428a");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskModelList, "e59db341-1dfb-48ad-a2ad-8ad48a1f85f3");

			REGISTRY_COMMAND_SINGLPROC(Command.TaskScoreCreate, "b87fd1ab-663e-4586-ab38-07a2d3de675c");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskScoreEdit, "30545d4e-a83f-4b4a-b4ca-2c7321c50e3f");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskScoreDelete, "3bf9ccd5-b1e7-4f73-a47f-5043fceb1aad");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskScoreInfo, "90a04054-39ed-4601-ae89-b8f4c11f5b9e");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskScoreList, "5c0210ab-cc1e-4704-b747-03922dc3e27f");

			REGISTRY_COMMAND_SINGLPROC(Command.TaskContentCreate, "2e51292d-c37a-4dcb-9035-6f78a38569e6");
			REGISTRY_COMMAND_SINGLPROC(Command.TaskAlert, "292d2e51-9f5a-9035-94dc-6fa38585c37a");

			REGISTRY_COMMAND_SINGLPROC(Command.ModelEdit, "16a56acd-e551-41d9-ac0c-e0ed9f1fab78");
			REGISTRY_COMMAND_SINGLPROC(Command.ModelDelete, "7615c9e3-b236-4365-9b0b-ada257f17bba");
			REGISTRY_COMMAND_SINGLPROC(Command.ModelInfo, "28c510a8-7923-46ed-89a5-5699362b8bc5");
			REGISTRY_COMMAND_SINGLPROC(Command.ModelList, "829aef04-b7d0-4efa-9906-69369c0a30f0");

			REGISTRY_COMMAND_SINGLPROC(Command.ScoreEdit, "8ec320fa-73f9-4ddf-b535-c2bdb5837da0");
			REGISTRY_COMMAND_SINGLPROC(Command.ScoreDelete, "7c9f6b60-8ef2-4e72-85da-dde4eb66c37b");
			REGISTRY_COMMAND_SINGLPROC(Command.ScoreInfo, "71253bcc-5b18-487a-a9ef-0a06acdb1bca");
			REGISTRY_COMMAND_SINGLPROC(Command.ScoreList, "d7fc2b29-8c9a-4d84-bb72-ad005ac3dffe");

			REGISTRY_COMMAND_SINGLPROC(Command.CreateSyncPlanning, "48815c00-b09b-49c8-a07e-dc4d610da863");
			REGISTRY_COMMAND_SINGLPROC(Command.CreateSyncPlanningDebug, "28b6a424-fd5c-4421-a81f-18371f142c8c");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncDataNow, "7aadf7c4-b689-4198-b994-aa52f9742283");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncDataEnabled, "67b5e7c3-dd9c-4cd8-97a6-17206dac5f39");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncDataInfo, "8d80f7e0-25d0-4aba-9bcf-73ec8d529fcd");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncDataSet, "254c0f87-359a-4657-9092-d4e653dae348");

			//REGISTRY_COMMAND_SINGLPROC(MedicalProfileList,       "fcdb379e-b78b-497a-a250-57edb30d3c31")
			//REGISTRY_COMMAND_SINGLPROC(MedicalProfileInfo,       "749e942d-62b9-4f3f-9d94-c3e4e54138d5")
			//REGISTRY_COMMAND_SINGLPROC(KindOfHelpList,           "d10e573e-ef3b-42b9-9252-7875f7166c7a")
			//REGISTRY_COMMAND_SINGLPROC(KindOfHelpInfo,           "637600de-9a26-4e18-bfc4-c32869979a2f")
			//REGISTRY_COMMAND_SINGLPROC(DiagnosisList,            "c97cc066-b722-44ca-b04f-02e48f37f814")
			//REGISTRY_COMMAND_SINGLPROC(DiagnosisInfo,            "6e2599ca-bdbd-460e-acb7-b80a17d0fb71")
			//REGISTRY_COMMAND_SINGLPROC(ClinicList,               "4cfbb44f-39c5-4ba4-9abb-e6387020b729")
			//REGISTRY_COMMAND_SINGLPROC(ClinicInfo,               "8aff74a7-dd49-4fb9-b4b3-47f7128af5cb")

			//REGISTRY_COMMAND_SINGLPROC(Command.NsiVidmpList, "18d4ba47-95aa-45c1-8ed4-5f888638f90a");
			//REGISTRY_COMMAND_SINGLPROC(Command.NsiProfileList, "d1da093d-346e-45ff-88cf-75a97cc94e6f");
			//REGISTRY_COMMAND_SINGLPROC(Command.NsiLpuList, "d0fa1b55-2f33-4b32-b189-1fd8a78e98d5");
			//REGISTRY_COMMAND_SINGLPROC(Command.NsiMkbList, "a2322349-7629-426d-9e36-b36e6a5a8099");

			REGISTRY_COMMAND_SINGLPROC(Command.TaskReportCreate, "147b9b31-c4a5-468f-ae5d-b930f9cfc1d1");
			REGISTRY_COMMAND_SINGLPROC(Command.ReportInfo, "9dec65db-9e82-4651-a0d0-4cd35d53b6f6");
			REGISTRY_COMMAND_SINGLPROC(Command.ReportList, "c9dbbd69-e70f-4123-910a-886863b639e9");
			REGISTRY_COMMAND_SINGLPROC(Command.ReportData, "7091cd69-1a27-4c13-b4c1-720064300559");
			REGISTRY_COMMAND_SINGLPROC(Command.ReportEdit, "4e61d479-100d-4c72-be13-2c359d819389");
			REGISTRY_COMMAND_SINGLPROC(Command.ReportDelete, "6c62b4fb-308f-43ea-b198-8047311f64ca");

			REGISTRY_COMMAND_SINGLPROC(Command.ModelXgbDelete, "be983008-05c5-4009-b4d1-9d6e4dd6884c");
			REGISTRY_COMMAND_SINGLPROC(Command.ModelXgbInfo, "16f55bb2-ecea-406e-8569-cf64ec545e2e");
			REGISTRY_COMMAND_SINGLPROC(Command.ModelXgbEdit, "5d199423-be4d-49a3-8687-8a7e1fdc9a2a");
			REGISTRY_COMMAND_SINGLPROC(Command.ModelXgbOption, "11b010e6-8d7d-4641-a3b2-abaf2be675ad");

			REGISTRY_COMMAND_SINGLPROC(Command.EventLogList, "87f3207f-8f65-4be9-8841-9b55fcb6c23f");
			REGISTRY_COMMAND_SINGLPROC(Command.Monitoring, "641fd153-22e4-4959-9e6b-889d6cea3181");

			REGISTRY_COMMAND_SINGLPROC(Command.AisVersion, "3b52226b-cf24-4ccf-bb61-7877a3348dde");

			REGISTRY_COMMAND_SINGLPROC(Command.SyncNsiVidmp, "feadcdf0-e4d4-4b6d-8716-c850e0a8931f");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncNsiProfile, "66e3dc8f-9b0b-44ca-826e-08ab531aae5a");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncNsiLpu, "342801f6-4a79-48d9-9d20-aed8d3b277a8");
			REGISTRY_COMMAND_SINGLPROC(Command.SyncNsiMkb, "0c4ab327-5799-410a-b49c-5896883d88da");
		}
	}

/*Receiver();
CloseConn();
            }
            catch (Exception ex)
            {
                CloseConn();
Trace.TraceError($"{DateTime.Now}: [SetupConn] Error: \r\n {ex.ToString()}");
            }
        }*/
        
	/*void CloseConn() // Close connection.
{
	try
	{
		//clientInfo.LoggedIn = false;
		//server.activeClients.Remove(clientInfo);
		br.Close();
		bw.Close();
		//ssl.Close();
		netStream.Close();
		client.Close();
	}
	catch (Exception ex)
	{
		Trace.TraceError($"Ошибка завершения соединения. \r\n {ex.ToString()}\r\n");
	}
} //*/

/*void Receiver()  // Receive all incoming packets.
{
	//clientInfo.LoggedIn = true;

	try
	{
		while (client.Client.Connected)  // While we are connected.
		{

			Message msg = ReadNextPacket(br, false);  // Get incoming packet.
			if (msg != null)
			{
				Console.WriteLine($"Message recive '{msg.MsgCommand.ToString()}' ({DateTime.Now.ToString("dd.MM.yyyy HH:mm:ss")})");
				ThreadPool.QueueUserWorkItem(new WaitCallback(ProcessMessage), msg);
			}
			Thread.Sleep(100);
		}
	}
	catch (Exception ex)
	{
		Trace.TraceError($"Ошибка в методе Reciver. \r\n {ex.ToString()}\r\n");
	}

	//clientInfo.LoggedIn = false;
}//*/

/*private void ProcessMessage(object message)
{

	Message msg = (Message)message;

	Message result = null;
	try
	{
		System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
		sw.Start();
		if (msg.maxTimeLife.HasValue)
		{
			int ms = msg.maxTimeLife.Value * 1000;
			ms = ms - 3000;
			if (ms <= 0) { ms = 1000; }
			Task<Message> task = Task.Run<Message>(() => DoMessage(msg));
			bool finish = false;
			int lastwait = 0;
			while (!task.IsCompleted)
			{
				System.Diagnostics.Stopwatch step = new System.Diagnostics.Stopwatch();
				step.Start();
				task.Wait(ms);
				if (!task.IsCompleted)
				{
					//Время обработки команды заканчивается, просим еще подождать...
					SendWaitCommand(msg, msg.maxTimeLife.Value);
				}
				step.Stop();
				lastwait = step.Elapsed.Seconds;
			}
			if (task.IsFaulted)
			{
				throw task.Exception;
			}
			result = task.Result;

			if (finish && (msg.maxTimeLife.Value - lastwait) < 10)
			{
				SendWaitCommand(msg, msg.maxTimeLife.Value); // 10 - (msg.maxTimeLife.Value - lastwait)
			}

		}
		else
		{
			result = DoMessage(msg);
		}
		sw.Stop();
		if (result != null)
		{
			SendData(bw, result, false, sw.ElapsedMilliseconds);
		}
	}
	catch (Exception ex)
	{
		try
		{
			result = msg.GetError(ex.Message);
			SendData(bw, result, false);
			string objStr = string.Empty;
			if (msg != null)
			{
				objStr = JObject.FromObject(msg).ToString();
				if (objStr.Length > 10000)
				{
					objStr = objStr.Substring(1, 10000);
				}
			}
			Trace.TraceError($"{DateTime.Now}: [ProcessMessage] Error Incoming packet: {objStr} \r\n {ex.ToString()}");
		}
		catch (Exception e)
		{
			Trace.TraceError($"Ошибка записи в лог. \r\n {e.ToString()}\r\n");
		}
	}
}//*/

/*private void SendWaitCommand(Message msg, int seconds)
{
	Console.WriteLine("keepWaitCommand");
	Message keepWaitCommand = new Message();
	keepWaitCommand.command = Command.KeepWaitCommand.GetID();
	keepWaitCommand.MsgPriority = MsgPriority.High;
	keepWaitCommand.content = JObject.FromObject(new { messageId = msg.id, commandId = msg.command, timeToAdd = seconds });
	SendData(bw, keepWaitCommand, false);
}//*/

/*private Message DoMessage(Message msg)
{
	Message result = null;
	try
	{
		switch (msg.MsgCommand)
		{
			case Command.Unknown:
			case Command.FomsEcho:
				result = msg.GetAnswer(true);
				break;
			case Command.Error:
				break;
			case Command.CloseConnection:
				break;
			case Command.SyncData:
				break;
			case Command.SendData:
				break;
			case Command.RequestSyncData:
				break;
			case Command.GetSyncData:
				break;
			case Command.GetSyncData2:
				result = GetSyncData2(msg);
				break;
			case Command.SyncDataCheck:
				result = SyncDataCheck(msg);
				break;
			case Command.SendScoreCheck:
				result = SendScoreCheck(msg);
				break;
			case Command.SyncDataCount:
				result = SyncDataCount(msg);
				break;
			case Command.RequestNsiData:
				break;
			case Command.GetNsiData:
				break;
			case Command.SendScore:
				result = SendScore(msg);
				break;
			case Command.SendScoreData:
				break;
			case Command.SendReport:
				break;
			case Command.SendReportData:
				break;
			case Command.SmoScores:
				break;
			case Command.RequestSmoScore:
				break;
			case Command.GetSmoScoreData:
				break;
			case Command.BreakDataTransfer:
				break;
			case Command.GroupAdd:
				break;
			case Command.GroupEdit:
				break;
			case Command.GroupDelete:
				break;
			case Command.GroupInfo:
				break;
			case Command.GroupList:
				break;
			case Command.AssignGroup:
				break;
			case Command.ScoreEdit:
				break;
			case Command.ScoreDelete:
				break;
			case Command.ScoreInfo:
				break;
			case Command.ScoreList:
				break;
			case Command.CreateSyncPlanning:
				break;
			case Command.CreateSyncPlanningDebug:
				break;
			case Command.SyncDataNow:
				break;
			case Command.SyncDataEnabled:
				break;
			case Command.SyncDataInfo:
				break;
			case Command.SyncDataSet:
				break;
			case Command.SyncNsiVidmp:
				{
					result = GetSyncNsi(msg, "nsiVmp");
				}
				break;
			case Command.SyncNsiProfile:
				{
					result = GetSyncNsi(msg, "nsiProfile");
				}
				break;
			case Command.SyncNsiLpu:
				{
					result = GetSyncNsi(msg, "nsiLpu", "code");
				}
				break;
			case Command.SyncNsiMkb:
				{
					result = GetSyncNsi(msg, "nsiMkb", "mkbCode");
				}
				break;
			case Command.TaskReportCreate:
				break;
			case Command.ReportInfo:
				break;
			case Command.ReportList:
				break;
			case Command.ReportData:
				break;
			case Command.ReportEdit:
				break;
			case Command.ReportDelete:
				break;
			case Command.ModelXgbDelete:
				break;
			case Command.ModelXgbInfo:
				break;
			case Command.ModelXgbEdit:
				break;
			case Command.ModelXgbOption:
				break;
			case Command.EventLogList:
				break;
			case Command.Monitoring:
				break;
			case Command.AisVersion:
				break;
			default:
				break;
		}
	}
	catch (Exception ex)
	{
		try
		{
			result = msg.GetError(ex.Message);
			string objStr = string.Empty;
			if (msg != null)
			{
				objStr = JObject.FromObject(msg).ToString();
				if (objStr.Length > 10000)
				{
					objStr = objStr.Substring(1, 10000);
				}
			}
			Trace.TraceError($"{DateTime.Now}: [DoMessage] Error Incoming packet: { objStr } \r\n {ex.ToString()}");
		}
		catch (Exception e)
		{
			Trace.TraceError($"Ошибка при записи в лог методв DoMessage. \r\n {e.ToString()}\r\n");
		}
	}
	return result;
}//*/





#region SEND_PACKETS

#endregion


/*#region RECEIVED PACKETS

private Message GetSyncData2(Message message)
{
	Message result = message.GetAnswer();
	////ToDo
	return result;
}

private Message SyncDataCheck(Message message)
{
	Message result = message.GetAnswer();
	//ToDo
	return result;
}


public static Message SyncDataCount(Message message)
{
	Message result = message.GetAnswer();
	//ToDo
	return result;
}

private Message SendScore(Message message)
{
	Message result = message.GetAnswer();
	//ToDo
	return result;
}

private Message SendScoreCheck(Message message)
{
	Message result = message.GetAnswer();
	//ToDo
	return result;
}

private Message GetSyncNsi(Message message, string nsiName, string keyField = null)
{
	Message result = message.GetAnswer();
	//ToDo
	return result;
}
#endregion //*/


public class GroupData
{
	public int count { get; set; }
	public int total { get; set; }
	public Content[] content { get; set; }
}

public class Content
{
	public Row row { get; set; }
	public int count { get; set; }
}

public class Row
{
	public string _D2 { get; set; }
}

	// Класс-обработчик клиента
	class Client
	{
		public Client(TcpClient c)
		{
			client = c;
			// Handle client in another thread.
			(new Thread(new ThreadStart(SetupConn)) { IsBackground = true }).Start();
		}

		public TcpClient client;
		public NetworkStream netStream;  // Raw-data stream of connection.
		public BinaryReader br;
		public BinaryWriter bw;

		private static object lock_obj = new object();


		public static int SwapEndianness(int value)
		{
			var b1 = (value >> 0) & 0xff;
			var b2 = (value >> 8) & 0xff;
			var b3 = (value >> 16) & 0xff;
			var b4 = (value >> 24) & 0xff;

			return b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
		}

		public static uint SwapEndianness(uint value)
		{
			var b1 = (value >> 0) & 0xff;
			var b2 = (value >> 8) & 0xff;
			var b3 = (value >> 16) & 0xff;
			var b4 = (value >> 24) & 0xff;

			return b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
		}

		private void SendData(BinaryWriter writer, Message message, bool ignoreNulls = true, long? ElapsedMilliseconds = null)
		{
			string data = JObject.FromObject(message, new Newtonsoft.Json.JsonSerializer() { NullValueHandling = ignoreNulls ? Newtonsoft.Json.NullValueHandling.Ignore : Newtonsoft.Json.NullValueHandling.Include }).ToString();
			//Console.WriteLine($"Message Send (lenght ='{data.Length}') messageID:{message.id}, command:{message.MsgCommand.ToString()}({message.command}) {(ElapsedMilliseconds.HasValue ? ElapsedMilliseconds.Value.ToString() + "ms" : string.Empty)}");
			byte[] bb = Encoding.UTF8.GetBytes(data);
			lock (netStream)
			{
				// проверяем живой ли connection
				if (client.Client.Connected)
				{
					writer.Write(SwapEndianness(bb.Length));
					writer.Write(bb);
					writer.Flush();
				}
			}
		}


		private Message ReadNextPacket(BinaryReader reader, bool forceWait = false)
		{
			string data = null;
			if (netStream.DataAvailable || forceWait)
			{
				lock (netStream)
				{
					byte[] aa = reader.ReadBytes(4);
					int size = BitConverter.ToInt32(aa.Reverse().ToArray(), 0);
					data = Encoding.UTF8.GetString(reader.ReadBytes(size));
				}
				return JObject.Parse(data).ToObject<Message>();
			}
			else return null;
		}

		void SetupConn()  // Setup connection and login or register.
		{
			try
			{
				netStream = client.GetStream();
				// Now we have encrypted connection.

				br = new BinaryReader(netStream, Encoding.UTF8);
				bw = new BinaryWriter(netStream, Encoding.UTF8);

				// Say "hello".
				byte[] hello = br.ReadBytes(16);
				Guid h = new Guid(hello).ChangeByteOrder();

				if (h == new Guid(Command.Hello.GetID()))
				{
					Console.WriteLine("Autorize");
					//Отвечаем тем же самым пакетом приветствия
					bw.Write(hello);
					bw.Flush();
					Message msg = ReadNextPacket(br, true);
					Console.WriteLine("ProtocolCompare");
					if (msg.MsgCommand == Command.ProtocolCompatible)
					{
						SendData(bw, msg);
					}
					else
					{
						return;
					}
					msg = ReadNextPacket(br, true);
					if (msg.MsgCommand == Command.FomsAuthorization)
					{
						SendData(bw, msg.GetAnswer());
					}
					else
					{
						return;
					}
					//Запрашиваем ручную синхронизацию
					//CreateSyncPlanningContent tst = new CreateSyncPlanningContent() { timeMark = DateTime.Now.AddYears(-10).UnixTime(), period = new Period(new DateTime(2019, 2, 1), new DateTime(2019, 1, 1)) };
					//msg = new Message() { MsgCommand = Command.CreateSyncPlanningDebug, content = JObject.FromObject(tst) };
					//SendData(bw, msg);

					Receiver();


				}
				CloseConn();
			}
			catch (Exception ex)
			{
				CloseConn();
			}
		}
		void CloseConn() // Close connection.
		{
			try
			{
				//clientInfo.LoggedIn = false;
				//server.activeClients.Remove(clientInfo);
				br.Close();
				bw.Close();
				//ssl.Close();
				netStream.Close();
				client.Close();
			}
			catch { }
		}

		void Receiver()  // Receive all incoming packets.
		{
			//clientInfo.LoggedIn = true;

			try
			{
				while (client.Client.Connected)  // While we are connected.
				{

					Message msg = ReadNextPacket(br, false);  // Get incoming packet.
					if (msg != null)
					{
						//Console.WriteLine($"Message recive '{msg.MsgCommand.ToString()}' ({DateTime.Now.ToString("dd.MM.yyyy HH:mm:ss")})");
						ThreadPool.QueueUserWorkItem(new WaitCallback(ProcessMessage), msg);
					}
					Thread.Sleep(100);
				}
			}
			catch (Exception)
			{
				//Продолжаем работать...
			}

			//clientInfo.LoggedIn = false;
		}

		private void ProcessMessage(object message)
		{

			Message msg = (Message)message;

			Message result = null;
			try
			{
				System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
				sw.Start();
				if (msg.maxTimeLife.HasValue)
				{
					int ms = msg.maxTimeLife.Value * 1000;
					ms = ms - 3000;
					if (ms <= 0) { ms = 1000; }
					Task<Message> task = Task.Run<Message>(() => DoMessage(msg));
					bool finish = false;
					int lastwait = 0;
					while (!task.IsCompleted)
					{
						System.Diagnostics.Stopwatch step = new System.Diagnostics.Stopwatch();
						step.Start();
						task.Wait(ms);
						if (!task.IsCompleted)
						{
							//Время обработки команды заканчивается, просим еще подождать...
							SendWaitCommand(msg, msg.maxTimeLife.Value);
						}
						step.Stop();
						lastwait = step.Elapsed.Seconds;
					}
					if (task.IsFaulted)
					{
						throw task.Exception;
					}
					result = task.Result;

					if (finish && (msg.maxTimeLife.Value - lastwait) < 5)
					{
						SendWaitCommand(msg, 5 - (msg.maxTimeLife.Value - lastwait));
					}

				}
				else
				{
					result = DoMessage(msg);
				}
				sw.Stop();
				if (result != null)
				{
					SendData(bw, result, false, sw.ElapsedMilliseconds);
				}
			}
			catch (Exception ex)
			{
				result = msg.GetError(ex.Message);
				SendData(bw, result, false);
			}
		}

		private void SendWaitCommand(Message msg, int seconds)
		{
			Console.WriteLine("keepWaitCommand");
			Message keepWaitCommand = new Message();
			keepWaitCommand.command = Command.KeepWaitCommand.GetID();
			keepWaitCommand.MsgPriority = MsgPriority.High;
			keepWaitCommand.content = JObject.FromObject(new { messageId = msg.id, commandId = msg.command, timeToAdd = seconds });
			SendData(bw, keepWaitCommand, false);
		}

		private Message DoMessage(Message msg)
		{
			Message result = null;
			try
			{
				switch (msg.MsgCommand)
				{
					case Command.Unknown:
					case Command.FomsEcho:
						result = msg.GetAnswer(true);
						break;
					case Command.Error:
						break;
					case Command.CloseConnection:
						break;
					case Command.SyncData:
						break;
					case Command.SendData:
						break;
					case Command.RequestSyncData:
						break;
					case Command.GetSyncData:
						break;
					case Command.GetSyncData2:
						//result = GetSyncData2(msg);
						break;
					case Command.SyncDataCheck:
						//result = SyncDataCheck(msg);
						break;
					case Command.SendScoreCheck:
						//result = SendScoreCheck(msg);
						break;
					case Command.SyncDataCount:
						break;
					case Command.RequestNsiData:
						break;
					case Command.GetNsiData:
						break;
					case Command.SendScore:
						//result = SendScore(msg);
						break;
					case Command.SendScoreData:
						break;
					case Command.SendReport:
						break;
					case Command.SendReportData:
						break;
					case Command.SmoScores:
						break;
					case Command.RequestSmoScore:
						break;
					case Command.GetSmoScoreData:
						break;
					case Command.BreakDataTransfer:
						break;
					case Command.GroupAdd:
						break;
					case Command.GroupEdit:
						break;
					case Command.GroupDelete:
						break;
					case Command.GroupInfo:
						break;
					case Command.GroupList:
						break;
					case Command.AssignGroup:
						break;
					case Command.ScoreEdit:
						break;
					case Command.ScoreDelete:
						break;
					case Command.ScoreInfo:
						break;
					case Command.ScoreList:
						break;
					case Command.CreateSyncPlanning:
						break;
					case Command.CreateSyncPlanningDebug:
						break;
					case Command.SyncDataNow:
						break;
					case Command.SyncDataEnabled:
						break;
					case Command.SyncDataInfo:
						break;
					case Command.SyncDataSet:
						break;
					//case Command.NsiVidmpList: break; 
					//case Command.NsiProfileList: break;
					//case Command.NsiLpuList: break;
					//case Command.NsiMkbList: break;
					case Command.TaskReportCreate:
						break;
					case Command.ReportInfo:
						break;
					case Command.ReportList:
						break;
					case Command.ReportData:
						break;
					case Command.ReportEdit:
						break;
					case Command.ReportDelete:
						break;
					case Command.ModelXgbDelete:
						break;
					case Command.ModelXgbInfo:
						break;
					case Command.ModelXgbEdit:
						break;
					case Command.ModelXgbOption:
						break;
					case Command.EventLogList:
						break;
					case Command.Monitoring:
						break;
					case Command.AisVersion:
						break;
					default:
						break;
				}
			}
			catch (Exception ex)
			{
				result = msg.GetError(ex.Message);
			}
			return result;
		}





		#region SEND_PACKETS


		#endregion

		#region RECEIVED PACKETS

		/*private Message GetSyncData2(Message message)
		{
			Message result = message.GetAnswer();
			SyncPlanningContent content = message.content.ToObject<SyncPlanningContent>();

			APIClient cli = new APIClient();
			ListRequest r = new ListRequest();
			JObject filter = new JObject();

			Console.WriteLine($"Read data from {content.period.GetBegin().ToString("dd.MM.yyyy")} to {content.period.GetEnd().ToString("dd.MM.yyyy")}  time_mark {content.timeMark}  count = {content.count}");

			JObject load = new JObject();
			load["From"] = content.period.GetBegin().ToString("dd.MM.yyyy");
			load["To"] = content.period.GetEnd().ToString("dd.MM.yyyy");
			JObject stamp = new JObject();
			stamp["From"] = content.timeMark;

			filter["_D2"] = load;
			filter["TIME_MARK"] = stamp;
			r.filter = filter;
			r.sort = new SortInfo[1];
			r.sort[0] = new SortInfo();
			r.sort[0].field = "TIME_MARK";
			JToken p = cli.GetPage("services", r, null, 0, content.count);
			content.items = (JArray)((JObject)p)["content"];

			result.content = JObject.FromObject(content);
			return result;
		}*/

		/*private Message SyncDataCheck(Message message)
		{
			Message result = message.GetAnswer();
			SyncPlanningCheck content = message.content.ToObject<SyncPlanningCheck>();

			APIClient cli = new APIClient();
			ListRequest r = new ListRequest();
			JObject filter = new JObject();

			Console.WriteLine($"Read data for CHECKSUM from {content.period.GetBegin().ToString("dd.MM.yyyy")} to {content.period.GetEnd().ToString("dd.MM.yyyy")}  time_mark {content.timeMark} ");

			JObject load = new JObject();
			load["From"] = content.period.GetBegin().ToString("dd.MM.yyyy");
			load["To"] = content.period.GetEnd().ToString("dd.MM.yyyy");
			JObject stamp = new JObject();
			stamp["From"] = content.timeMark;

			filter["_D2"] = load;
			filter["TIME_MARK"] = stamp;
			r.filter = filter;
			r.sort = new SortInfo[1];
			r.sort[0] = new SortInfo();
			r.sort[0].field = "TIME_MARK";
			JToken p = cli.GetPage("services", r, "min", 1, 1000000);
			int cnt = ((JArray)((JObject)p)["content"]).Count();
			ulong crc = 0;
			foreach (JObject item in (JArray)((JObject)p)["content"])
			{
				crc ^= (ulong)item["TIME_MARK"].Value<long>();
			}
			content.crc = crc;

			result.content = JObject.FromObject(content);
			return result;
		}*/

		/*private Message SendScore(Message message)
		{
			Message result = message.GetAnswer();
			SendScoreContent content = message.content.ToObject<SendScoreContent>();


			APIClient cli = new APIClient();

			var r = cli.SaveObject("scoreInfo", new { content.id, content.name, descr = content.descript, content.userId, content.userName, content.modelId, content.modelName });
			JArray items = new JArray();
			var search = new JArray() { "scoreInfo.id", "IDSL" };
			foreach (var item in content.items)
			{
				items.Add(JObject.FromObject(new { search, scoreInfo = new { content.id }, item.IDSL, item.MEE, item.EKMP }));
			}
			var r2 = cli.SaveList("scoreInfoItem", items);
			return result;
		}*/

		/*private Message SendScoreCheck(Message message)
		{
			Message result = message.GetAnswer();
			SendScoreCheck content = message.content.ToObject<SendScoreCheck>();

			APIClient cli = new APIClient();
			ListRequest r = new ListRequest();
			JObject filter = new JObject();

			Console.WriteLine($"Read data for CHECKSUM from id={content.id} count={content.count} crc={content.crc} ");


			filter["scoreInfoId"] = content.id;
			r.filter = filter;
			r.sort = new SortInfo[1];
			r.sort[0] = new SortInfo();
			r.sort[0].field = "id";
			JToken p = cli.GetPage("scoreInfoItem", r, "min", 1, 1000000);
			int cnt = ((JArray)((JObject)p)["content"]).Count();
			ulong crc = 0;
			foreach (JObject item in (JArray)((JObject)p)["content"])
			{
				SimpleItem si = item.ToObject<SimpleItem>();
				byte[] bb = si.id.ToByteArray();
				ulong p1 = (ulong)BitConverter.ToInt64(bb, 0);
				ulong p2 = (ulong)BitConverter.ToInt64(bb, 8);
				ulong rez = p1 ^ p2;

				crc ^= rez;
			}
			content.crc = crc;
			content.count = cnt;
			result.content = JObject.FromObject(content);
			return result;
		}*/
		#endregion
	}

} // </Витакор :-)