# Бекенд-прокси для АИС Эксперт

## Запуск

Чтобы собрать проект нужно выполнить

```bash
./gradlew bootJar
```

Чтобы запустить локально:

```bash
./gradlew bootRun
```

## Документация на WEB-методы

Документация на HTTP-методы доступна по http://localhost:8080/swagger-ui.html после запуска бекенда.

WebSocket методы описаны в [этом файле](src/main/kotlin/aisexpert/backend/web/SimpService.kt).

## Развёртывание

1. Собрать проект. Для сборки нужна Java JDK 1.8. Сборку проекта не обязательно выполнять на сервере, где нужно развернуть проект.

```bash
./gradlew bootJar
```

2. Создать папку для проекта и сменить владельца на нужного пользователя.

```bash
mkdir /opt/aisexpert-backend
chown -R <user>:<group> /opt/aisexpert-backend
```

3. Скопировать JAR файл в папку проекта.

```bash
# если сборка выполнялась на сервере:
cp build/libs/aisexpert-backend.jar /opt/aisexpert-backend/
# если сборка выполнялась на другой машине:
scp build/libs/aisexpert-backend.jar <user>@<host>:/opt/aisexpert-backend/
```

Далее все действия выполняются на сервере.

4. Установить необходимые зависимости.

```bash
apt-get install openjdk-8-jre postgresql
```

5. Запустить и добавить в автозапуск PostgreSQL.

```bash
systemctl start postgresql
systemctl enable postgresql
```

6. Проверить установку Java.

```bash
$ java -version
openjdk version "1.8.0_191"
OpenJDK Runtime Environment (build 1.8.0_191-8u191-b12-2ubuntu0.16.04.1-b12)
OpenJDK 64-Bit Server VM (build 25.191-b12, mixed mode)
```

7. Создать пользователя и базу в PostgreSQL.

```bash
$ su postgres
$ psql
> CREATE USER aisexpert WITH ENCRYPTED PASSWORD '<pg-password>';
> CREATE DATABASE aisexpert;
> GRANT ALL PRIVILEGES ON DATABASE aisexpert TO aisexpert;
> \q
$ exit
```

8. Создать конфигурацию для systemd серсвиса в файле `/etc/systemd/system/aisexpert-backend.service`.

```ini
[Unit]
Description=AisExpert Web Backend service
After=network.target auditd.service

[Service]
Type=simple
User=<user>
Group=<group>
ExecStart=/opt/aisexpert-backend/run.sh
TimeoutSec=300
Restart=on-failure

[Install]
WantedBy=multi-user.target
```

9. Создать скрипт запуска приложения в файле `/opt/aisexpert-backend/run.sh`.

```bash
#!/bin/bash
cd "$(dirname "$0")"
java \
  -Xmx2G \
  -Daisexpert.host=<aisexpert-host> \
  -Daisexpert.password=<web-auth-password> \
  -Dspring.datasource.url=jdbc:postgresql://localhost/aisexpert \
  -Dspring.datasource.username=aisexpert \
  -Dspring.datasource.password=<pg-password> \
  -Dweb.supervising-fetch-interval=5000 \
  -Dweb.allowed-origin=* \
  -Dserver.use-forward-headers=true \
  -jar aisexpert-backend.jar
```

9.1. Чтобы использовать firebird вместо postgres нужно поменять скрипт:

```bash
#!/bin/bash
cd "$(dirname "$0")"
java \
  -Xmx2G \
  -Daisexpert.host=<aisexpert-host> \
  -Daisexpert.password=<web-auth-password> \
  -Dspring.datasource.url=jdbc:firebirdsql://<fb-host>:<fb-port>/<fb-database-path> \
  -Dspring.datasource.username=<fb-username> \
  -Dspring.datasource.password=<fb-password> \
  -Dspring.datasource.driver-class-name=org.firebirdsql.jdbc.FBDriver \
  -Dspring.jpa.hibernate.dialect=org.hibernate.dialect.FirebirdDialect \
  -Dweb.supervising-fetch-interval=5000 \
  -Dweb.allowed-origin=* \
  -Dserver.use-forward-headers=true \
  -jar aisexpert-backend.jar
```

10. Сделать скрипт исполняемым.

```bash
chmod +x /opt/aisexpert-backend/run.sh
```

11. Запустить systemd сервис и добавить его в автозапуск.

```bash
systemctl start aisexpert-backend
systemctl enable aisexpert-backend
```

12. Проверить что приложение запущено.

```bash
journalctl -u aisexpert-backend
# в логах должна быть запись примерно такого вида:
2019-03-07 16:38:52.156  INFO 10981 --- [           main] aisexpert.backend.ApplicationKt          : Started ApplicationKt in 11.435 seconds (JVM running for 12.085)
```