package aisexpert.backend

import org.springframework.boot.autoconfigure.SpringBootApplication
import org.springframework.boot.runApplication
import org.springframework.context.annotation.Bean
import org.springframework.core.task.TaskExecutor
import org.springframework.scheduling.annotation.EnableScheduling
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor

@SpringBootApplication
@EnableScheduling
class Application {
	@Bean
	fun aisTaskExecutor(): TaskExecutor {
		return ThreadPoolTaskExecutor().apply {
			corePoolSize = 4
			maxPoolSize = 4
			setThreadNamePrefix("ais-task-executor-")
			initialize()
		}
	}
}

fun main(args: Array<String>) {
	runApplication<Application>(*args)
}

